/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.BinaryField;
import db.BooleanField;
import db.ByteField;
import db.IntField;
import db.LongField;
import db.Record;
import db.ShortField;
import db.StringField;

class ColumnAdapter {
    static final int BYTE = 0;
    static final int BOOLEAN = 1;
    static final int SHORT = 2;
    static final int INT = 3;
    static final int LONG = 4;
    static final int STRING = 5;
    static final int BINARY = 6;
    int type;
    Class<?> valueClass;

    ColumnAdapter(Class<?> c) {
        if (c == ByteField.class) {
            this.type = 0;
            this.valueClass = Byte.class;
        } else if (c == BooleanField.class) {
            this.type = 1;
            this.valueClass = Boolean.class;
        } else if (c == ShortField.class) {
            this.type = 2;
            this.valueClass = Short.class;
        } else if (c == IntField.class) {
            this.type = 3;
            this.valueClass = Integer.class;
        } else if (c == LongField.class) {
            this.type = 4;
            this.valueClass = String.class;
        } else if (c == StringField.class) {
            this.type = 5;
            this.valueClass = String.class;
        } else if (c == BinaryField.class) {
            this.type = 6;
            this.valueClass = String.class;
        }
    }

    Class<?> getValueClass() {
        return this.valueClass;
    }

    Object getKeyValue(Record rec) {
        switch (this.type) {
            case 0: {
                return new Byte(((ByteField)rec.getKeyField()).getByteValue());
            }
            case 1: {
                return new Boolean(((BooleanField)rec.getKeyField()).getBooleanValue());
            }
            case 2: {
                return new Short(((ShortField)rec.getKeyField()).getShortValue());
            }
            case 3: {
                return new Integer(((IntField)rec.getKeyField()).getIntValue());
            }
            case 4: {
                return "0x" + Long.toHexString(rec.getKey());
            }
            case 5: {
                return ((StringField)rec.getKeyField()).getString();
            }
            case 6: {
                byte[] bytes = ((BinaryField)rec.getKeyField()).getBinaryData();
                StringBuffer buf = new StringBuffer("  byte[" + bytes.length + "] = ");
                if (bytes.length > 0) {
                    int len = Math.min(bytes.length, 20);
                    buf.append(bytes[0]);
                    for (int i = 1; i < len; ++i) {
                        buf.append(",");
                        buf.append(bytes[i]);
                    }
                    if (bytes.length > 20) {
                        buf.append("...");
                    }
                }
                return buf.toString();
            }
        }
        return "";
    }

    Object getValue(Record rec, int col) {
        switch (this.type) {
            case 0: {
                return new Byte(rec.getByteValue(col));
            }
            case 1: {
                return rec.getBooleanValue(col);
            }
            case 2: {
                return new Short(rec.getShortValue(col));
            }
            case 3: {
                return new Integer(rec.getIntValue(col));
            }
            case 4: {
                return "0x" + Long.toHexString(rec.getLongValue(col));
            }
            case 5: {
                return "  " + rec.getString(col);
            }
            case 6: {
                byte[] bytes = rec.getBinaryData(col);
                StringBuffer buf = new StringBuffer("  byte[" + bytes.length + "] = ");
                if (bytes.length > 0) {
                    int len = Math.min(bytes.length, 20);
                    String str = this.getByteString(bytes[0]);
                    buf.append(str);
                    for (int i = 1; i < len; ++i) {
                        buf.append(",");
                        buf.append(this.getByteString(bytes[i]));
                    }
                    if (bytes.length > 20) {
                        buf.append("...");
                    }
                }
                return buf.toString();
            }
        }
        return "";
    }

    private String getByteString(byte b) {
        String str = Integer.toHexString(b);
        if (str.length() > 2) {
            str = str.substring(str.length() - 2);
        }
        return "0x" + str;
    }
}

