/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.component.DecompilerController;
import ghidra.app.decompiler.component.DecompilerPanel;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.app.util.AddEditDialog;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.listing.Function;
import ghidra.util.UndefinedFunction;

public class RenameFunctionAction
extends AbstractDecompilerAction {
    private final DecompilerController controller;
    private final PluginTool tool;

    public RenameFunctionAction(PluginTool tool, DecompilerController controller) {
        super("Rename Function");
        this.tool = tool;
        this.controller = controller;
        this.setKeyBindingData(new KeyBindingData(76, 0));
        this.setPopupMenuData(new MenuData(new String[]{"Rename Function"}, "Decompile"));
    }

    private Function getFunction() {
        DecompilerPanel decompilerPanel = this.controller.getDecompilerPanel();
        ClangToken tokenAtCursor = decompilerPanel.getTokenAtCursor();
        if (tokenAtCursor instanceof ClangFuncNameToken) {
            return DecompilerUtils.getFunction(this.controller.getProgram(), (ClangFuncNameToken)tokenAtCursor);
        }
        return null;
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function func = this.getFunction();
        return func != null && !(func instanceof UndefinedFunction);
    }

    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Function function = this.getFunction();
        AddEditDialog dialog = new AddEditDialog("Edit Function Name", this.tool);
        dialog.editLabel(function.getSymbol(), this.controller.getProgram());
    }
}

