/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.correlator.program;

import generic.lsh.LSHMemoryModel;
import ghidra.feature.vt.api.correlator.program.SimilarSymbolNameProgramCorrelator;
import ghidra.feature.vt.api.main.VTProgramCorrelator;
import ghidra.feature.vt.api.util.VTAbstractProgramCorrelatorFactory;
import ghidra.feature.vt.api.util.VTOptions;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;

public class SimilarSymbolNameProgramCorrelatorFactory
extends VTAbstractProgramCorrelatorFactory {
    public static final String NAME = "Similar Symbol Name Match";
    public static final String MEMORY_MODEL = "Memory model";
    public static final LSHMemoryModel MEMORY_MODEL_DEFAULT = LSHMemoryModel.LARGE;
    public static final String MIN_NAME_LENGTH = "Minimum name length";
    public static final int MIN_NAME_LENGTH_DEFAULT = 6;

    @Override
    public int getPriority() {
        return 9001;
    }

    @Override
    protected VTProgramCorrelator doCreateCorrelator(ServiceProvider serviceProvider, Program sourceProgram, AddressSetView sourceAddressSet, Program destinationProgram, AddressSetView destinationAddressSet, VTOptions options) {
        return new SimilarSymbolNameProgramCorrelator(serviceProvider, sourceProgram, sourceAddressSet, destinationProgram, destinationAddressSet, options);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public VTOptions createDefaultOptions() {
        VTOptions options = new VTOptions(NAME);
        options.setEnum(MEMORY_MODEL, (Enum)MEMORY_MODEL_DEFAULT);
        options.setInt(MIN_NAME_LENGTH, 6);
        return options;
    }

    @Override
    public String getDescription() {
        return "Compares symbols by iterating over all defined function and data symbols meeting the minimum size requirement in the source program and looking for similar symbol matches in the destination program.  It reports back any that match closely.";
    }
}

