/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.api.db;

import db.DBHandle;
import db.Field;
import db.LongField;
import db.OpenMode;
import db.Record;
import db.RecordIterator;
import db.Table;
import ghidra.feature.vt.api.db.VTAssociationDB;
import ghidra.feature.vt.api.db.VTMatchSetDB;
import ghidra.feature.vt.api.db.VTMatchTableDBAdapter;
import ghidra.feature.vt.api.db.VTMatchTagDB;
import ghidra.feature.vt.api.main.VTMatchInfo;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class VTMatchTableDBAdapterV0
extends VTMatchTableDBAdapter {
    private Table table;
    private final DBHandle dbHandle;

    public VTMatchTableDBAdapterV0(DBHandle dbHandle, long tableID) throws IOException {
        this.dbHandle = dbHandle;
        this.table = dbHandle.createTable(TABLE_NAME + tableID, TABLE_SCHEMA, new int[]{VTMatchTableDBAdapter.ColumnDescription.ASSOCIATION_COL.column()});
    }

    public VTMatchTableDBAdapterV0(DBHandle dbHandle, long tableID, OpenMode openMode, TaskMonitor monitor) throws VersionException {
        this.dbHandle = dbHandle;
        this.table = dbHandle.getTable(TABLE_NAME + tableID);
        if (this.table == null) {
            throw new VersionException("Missing Table: " + TABLE_NAME);
        }
        if (this.table.getSchema().getVersion() != 0) {
            throw new VersionException("Expected version 0 for table " + TABLE_NAME + " but got " + this.table.getSchema().getVersion());
        }
    }

    @Override
    public Record insertMatchRecord(VTMatchInfo info, VTMatchSetDB matchSet, VTAssociationDB association, VTMatchTagDB tag) throws IOException {
        Record record = TABLE_SCHEMA.createRecord(this.table.getKey());
        record.setLongValue(VTMatchTableDBAdapter.ColumnDescription.TAG_KEY_COL.column(), tag == null ? -1L : tag.getKey());
        record.setString(VTMatchTableDBAdapter.ColumnDescription.SIMILARITY_SCORE_COL.column(), info.getSimilarityScore().toStorageString());
        record.setString(VTMatchTableDBAdapter.ColumnDescription.CONFIDENCE_SCORE_COL.column(), info.getConfidenceScore().toStorageString());
        record.setLongValue(VTMatchTableDBAdapter.ColumnDescription.ASSOCIATION_COL.column(), association.getKey());
        record.setIntValue(VTMatchTableDBAdapter.ColumnDescription.SOURCE_LENGTH_COL.column(), info.getSourceLength());
        record.setIntValue(VTMatchTableDBAdapter.ColumnDescription.DESTINATION_LENGTH_COL.column(), info.getDestinationLength());
        this.table.putRecord(record);
        return record;
    }

    @Override
    Record getMatchRecord(long matchRecordKey) throws IOException {
        return this.table.getRecord(matchRecordKey);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }

    @Override
    public RecordIterator getRecords() throws IOException {
        return this.table.iterator();
    }

    @Override
    void updateRecord(Record record) throws IOException {
        this.table.putRecord(record);
    }

    @Override
    boolean deleteRecord(long matchRecordKey) throws IOException {
        return this.table.deleteRecord(matchRecordKey);
    }

    @Override
    RecordIterator getRecords(long associationID) throws IOException {
        LongField field = new LongField(associationID);
        return this.table.indexIterator(VTMatchTableDBAdapter.ColumnDescription.ASSOCIATION_COL.column(), (Field)field, (Field)field, true);
    }
}

