/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib.Util;

import java.util.ArrayList;
import java.util.List;
import org.jf.dexlib.DebugInfoItem;
import org.jf.dexlib.DexFile;
import org.jf.dexlib.Item;
import org.jf.dexlib.StringIdItem;
import org.jf.dexlib.TypeIdItem;
import org.jf.dexlib.Util.ByteArrayOutput;
import org.jf.dexlib.Util.Output;

public class DebugInfoBuilder {
    private static final int LINE_BASE = -4;
    private static final int LINE_RANGE = 15;
    private static final int FIRST_SPECIAL = 10;
    private int lineStart = 0;
    private ArrayList<String> parameterNames = new ArrayList();
    private ArrayList<Event> events = new ArrayList();
    private int lastAddress = 0;
    private boolean hasData;
    private int currentAddress;
    private int currentLine;

    private void checkAddress(int address) {
        if (this.lastAddress > address) {
            throw new RuntimeException("Cannot add an event with an address before the address of the prior event");
        }
    }

    public void addParameterName(String parameterName) {
        if (parameterName != null) {
            this.hasData = true;
        }
        this.parameterNames.add(parameterName);
    }

    public void addLine(int address, int line) {
        this.hasData = true;
        this.checkAddress(address);
        if (this.lineStart == 0) {
            this.lineStart = line;
        }
        this.events.add(new LineEvent(address, line));
    }

    public void addLocal(int address, int registerNumber, String localName, String localType) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new StartLocalEvent(address, registerNumber, localName, localType));
    }

    public void addLocalExtended(int address, int registerNumber, String localName, String localType, String signature) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new StartLocalExtendedEvent(address, registerNumber, localName, localType, signature));
    }

    public void addEndLocal(int address, int registerNumber) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new EndLocalEvent(address, registerNumber));
    }

    public void addRestartLocal(int address, int registerNumber) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new RestartLocalEvent(address, registerNumber));
    }

    public void addPrologue(int address) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new PrologueEvent(address));
    }

    public void addEpilogue(int address) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new EpilogueEvent(address));
    }

    public void addSetFile(int address, String fileName) {
        this.hasData = true;
        this.checkAddress(address);
        this.events.add(new SetFileEvent(address, fileName));
    }

    public int getParameterNameCount() {
        return this.parameterNames.size();
    }

    public DebugInfoItem encodeDebugInfo(DexFile dexFile) {
        if (!this.hasData) {
            return null;
        }
        ByteArrayOutput out = new ByteArrayOutput();
        StringIdItem[] parameterNamesArray = new StringIdItem[this.parameterNames.size()];
        ArrayList<Item> referencedItems = new ArrayList<Item>();
        if (this.lineStart == 0) {
            this.lineStart = 1;
        }
        this.currentLine = this.lineStart;
        for (Event event : this.events) {
            event.emit(dexFile, out, referencedItems);
        }
        this.emitEndSequence(out);
        int index = 0;
        for (String parameterName : this.parameterNames) {
            if (parameterName == null) {
                parameterNamesArray[index++] = null;
                continue;
            }
            parameterNamesArray[index++] = StringIdItem.internStringIdItem(dexFile, parameterName);
        }
        Item[] referencedItemsArray = new Item[referencedItems.size()];
        referencedItems.toArray(referencedItemsArray);
        return DebugInfoItem.internDebugInfoItem(dexFile, this.lineStart, parameterNamesArray, out.toByteArray(), referencedItemsArray);
    }

    public static byte calculateSpecialOpcode(int lineDelta, int addressDelta) {
        return (byte)(10 + addressDelta * 15 + (lineDelta - -4));
    }

    private void emitEndSequence(Output out) {
        out.writeByte(0);
    }

    private void emitAdvancePC(Output out, int address) {
        int addressDelta = address - this.currentAddress;
        if (addressDelta > 0) {
            out.writeByte(1);
            out.writeUnsignedLeb128(addressDelta);
            this.currentAddress = address;
        }
    }

    private void emitAdvanceLine(Output out, int lineDelta) {
        out.writeByte(2);
        out.writeSignedLeb128(lineDelta);
    }

    private void emitStartLocal(Output out, int registerNum) {
        out.writeByte(3);
        out.writeUnsignedLeb128(registerNum);
        out.writeByte(1);
        out.writeByte(1);
    }

    private void emitStartLocalExtended(Output out, int registerNum) {
        out.writeByte(4);
        out.writeUnsignedLeb128(registerNum);
        out.writeByte(1);
        out.writeByte(1);
        out.writeByte(1);
    }

    private void emitEndLocal(Output out, int registerNum) {
        out.writeByte(5);
        out.writeUnsignedLeb128(registerNum);
    }

    private void emitRestartLocal(Output out, int registerNum) {
        out.writeByte(6);
        out.writeUnsignedLeb128(registerNum);
    }

    private void emitSetPrologueEnd(Output out) {
        out.writeByte(7);
    }

    private void emitSetEpilogueBegin(Output out) {
        out.writeByte(8);
    }

    private void emitSetFile(Output out) {
        out.writeByte(9);
        out.writeByte(1);
    }

    private void emitSpecialOpcode(Output out, byte opcode) {
        out.writeByte(opcode);
    }

    private class SetFileEvent
    implements Event {
        private final int address;
        private final String fileName;

        public SetFileEvent(int address, String fileName) {
            this.address = address;
            this.fileName = fileName;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitSetFile(out);
            if (this.fileName != null) {
                referencedItems.add(StringIdItem.internStringIdItem(dexFile, this.fileName));
            }
        }
    }

    private class EpilogueEvent
    implements Event {
        private final int address;

        public EpilogueEvent(int address) {
            this.address = address;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitSetEpilogueBegin(out);
        }
    }

    private class PrologueEvent
    implements Event {
        private final int address;

        public PrologueEvent(int address) {
            this.address = address;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitSetPrologueEnd(out);
        }
    }

    private class RestartLocalEvent
    implements Event {
        private final int address;
        private final int registerNum;

        public RestartLocalEvent(int address, int registerNum) {
            this.address = address;
            this.registerNum = registerNum;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitRestartLocal(out, this.registerNum);
        }
    }

    private class EndLocalEvent
    implements Event {
        private final int address;
        private final int registerNum;

        public EndLocalEvent(int address, int registerNum) {
            this.address = address;
            this.registerNum = registerNum;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitEndLocal(out, this.registerNum);
        }
    }

    private class StartLocalExtendedEvent
    implements Event {
        private final int address;
        private final int registerNum;
        private final String localName;
        private final String localType;
        private final String signature;

        public StartLocalExtendedEvent(int address, int registerNum, String localName, String localType, String signature) {
            this.address = address;
            this.registerNum = registerNum;
            this.localName = localName;
            this.localType = localType;
            this.signature = signature;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitStartLocalExtended(out, this.registerNum);
            if (this.localName != null) {
                referencedItems.add(StringIdItem.internStringIdItem(dexFile, this.localName));
            }
            if (this.localType != null) {
                referencedItems.add(TypeIdItem.internTypeIdItem(dexFile, StringIdItem.internStringIdItem(dexFile, this.localType)));
            }
            if (this.signature != null) {
                referencedItems.add(StringIdItem.internStringIdItem(dexFile, this.signature));
            }
        }
    }

    private class StartLocalEvent
    implements Event {
        private final int address;
        private final int registerNum;
        private final String localName;
        private final String localType;

        public StartLocalEvent(int address, int registerNum, String localName, String localType) {
            this.address = address;
            this.registerNum = registerNum;
            this.localName = localName;
            this.localType = localType;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            DebugInfoBuilder.this.emitAdvancePC(out, this.address);
            DebugInfoBuilder.this.emitStartLocal(out, this.registerNum);
            referencedItems.add(this.localName == null ? null : StringIdItem.internStringIdItem(dexFile, this.localName));
            referencedItems.add(this.localType == null ? null : TypeIdItem.internTypeIdItem(dexFile, StringIdItem.internStringIdItem(dexFile, this.localType)));
        }
    }

    private class LineEvent
    implements Event {
        private final int address;
        private final int line;

        public LineEvent(int address, int line) {
            this.address = address;
            this.line = line;
        }

        @Override
        public int getAddress() {
            return this.address;
        }

        @Override
        public void emit(DexFile dexFile, Output out, List<Item> referencedItems) {
            int lineDelta = this.line - DebugInfoBuilder.this.currentLine;
            int addressDelta = this.address - DebugInfoBuilder.this.currentAddress;
            if (lineDelta < -4 || lineDelta > 10) {
                DebugInfoBuilder.this.emitAdvanceLine(out, lineDelta);
                lineDelta = 0;
            }
            if (lineDelta < 2 && addressDelta > 16 || lineDelta > 1 && addressDelta > 15) {
                DebugInfoBuilder.this.emitAdvancePC(out, this.address);
                addressDelta = 0;
            }
            DebugInfoBuilder.this.emitSpecialOpcode(out, DebugInfoBuilder.calculateSpecialOpcode(lineDelta, addressDelta));
            DebugInfoBuilder.this.currentAddress = this.address;
            DebugInfoBuilder.this.currentLine = this.line;
        }
    }

    private static interface Event {
        public int getAddress();

        public void emit(DexFile var1, Output var2, List<Item> var3);
    }
}

