/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dalvik.dex.inject;

import ghidra.app.plugin.processors.sleigh.PcodeEmit;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.InjectContext;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.Varnode;

public class InjectPayloadDexRange
implements InjectPayload {
    public String getName() {
        return "dexrange";
    }

    public int getType() {
        return 2;
    }

    public String getSource() {
        return "dexrange";
    }

    public int getParamShift() {
        return 0;
    }

    public InjectPayload.InjectParameter[] getInput() {
        return null;
    }

    public InjectPayload.InjectParameter[] getOutput() {
        return null;
    }

    public void inject(InjectContext context, PcodeEmit emit) {
    }

    public PcodeOp[] getPcode(Program program, InjectContext con) {
        if (con.inputlist.size() != 2) {
            return null;
        }
        int numParams = (int)((Varnode)con.inputlist.get(0)).getOffset();
        long fromOffset = ((Varnode)con.inputlist.get(1)).getOffset();
        long toOffset = 256L;
        AddressSpace registerSpace = program.getAddressFactory().getAddressSpace("register");
        PcodeOp[] resOps = new PcodeOp[numParams];
        for (int i = 0; i < numParams; ++i) {
            Address fromAddr = registerSpace.getAddress(fromOffset);
            Address toAddr = registerSpace.getAddress(toOffset);
            fromOffset += 4L;
            toOffset += 4L;
            PcodeOp op = new PcodeOp(con.baseAddr, i, 1);
            op.setInput(new Varnode(fromAddr, 4), 0);
            op.setOutput(new Varnode(toAddr, 4));
            resOps[i] = op;
        }
        return resOps;
    }

    public boolean isFallThru() {
        return true;
    }
}

