/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.i2ptunnel.irc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.i2p.data.DataHelper;
import net.i2p.i2ptunnel.irc.DCCHelper;
import net.i2p.util.Log;

abstract class IRCFilter {
    private static final boolean ALLOW_ALL_DCC_IN = false;
    private static final boolean ALLOW_ALL_DCC_OUT = false;
    private static final boolean ALLOW_ALL_CTCP_IN = false;
    private static final boolean ALLOW_ALL_CTCP_OUT = false;
    private static final Set<String> _allowedInbound;
    private static final Set<String> _allowedOutbound;

    IRCFilter() {
    }

    public static String inboundFilter(String s, StringBuffer expectedPong, DCCHelper helper) {
        String command;
        String[] field = DataHelper.split(s, " ", 4);
        int idx = 0;
        try {
            if (field[0].charAt(0) == ':') {
                // empty if block
            }
            int n = ++idx;
            ++idx;
            command = field[n].toUpperCase(Locale.US);
        }
        catch (IndexOutOfBoundsException ioobe) {
            return null;
        }
        ++idx;
        try {
            Integer.parseInt(command);
            return s;
        }
        catch (NumberFormatException ioobe) {
            if ("PONG".equals(command)) {
                String pong = expectedPong.length() > 0 ? expectedPong.toString() : s;
                expectedPong.setLength(0);
                return pong;
            }
            if (_allowedInbound.contains(command)) {
                return s;
            }
            if ("PRIVMSG".equals(command) || "NOTICE".equals(command)) {
                String msg;
                if ((msg = field[idx++]).indexOf(1) >= 0) {
                    int count = 0;
                    for (int i = 0; i < msg.length(); ++i) {
                        if (msg.charAt(i) != '\u0001') continue;
                        ++count;
                    }
                    if (count != 2) {
                        return null;
                    }
                    if ((msg = msg.substring(2)).startsWith("ACTION ")) {
                        return s;
                    }
                    if (msg.startsWith("DCC ")) {
                        StringBuilder buf = new StringBuilder(128);
                        for (int i = 0; i <= idx - 2; ++i) {
                            buf.append(field[i]).append(' ');
                        }
                        buf.append(":\u0001DCC ");
                        return IRCFilter.filterDCCIn(buf.toString(), msg.substring(4), helper);
                    }
                    if (msg.toUpperCase(Locale.US).startsWith("XDCC ") && helper != null && helper.isEnabled()) {
                        return s;
                    }
                    return null;
                }
                return s;
            }
            return null;
        }
    }

    public static String outboundFilter(String s, StringBuffer expectedPong, DCCHelper helper) {
        String msg;
        String[] field = DataHelper.split(s, " ", 3);
        if (field[0].length() == 0) {
            return null;
        }
        if (field[0].charAt(0) == ':') {
            return null;
        }
        String command = field[0].toUpperCase(Locale.US);
        if ("PING".equals(command)) {
            String rv = null;
            expectedPong.setLength(0);
            if (field.length == 1) {
                rv = "PING";
            } else if (field.length == 2) {
                rv = "PING " + field[1];
            } else if (field.length == 3) {
                rv = "PING " + field[1];
                expectedPong.append("PONG ").append(field[2]).append(" :").append(field[1]);
            } else {
                rv = null;
            }
            return rv;
        }
        if (_allowedOutbound.contains(command)) {
            return s;
        }
        if ("NOTICE".equals(command)) {
            if (field.length < 3) {
                return s;
            }
            msg = field[2];
            if (msg.startsWith(":DCC ")) {
                return IRCFilter.filterDCCOut(field[0] + ' ' + field[1] + " :DCC ", msg.substring(5), helper);
            }
        }
        if ("PRIVMSG".equals(command) || "NOTICE".equals(command)) {
            if (field.length < 3) {
                return s;
            }
            msg = field[2];
            if (msg.indexOf(1) >= 0) {
                int count = 0;
                for (int i = 0; i < msg.length(); ++i) {
                    if (msg.charAt(i) != '\u0001') continue;
                    ++count;
                }
                if (count != 2) {
                    return null;
                }
                if ((msg = msg.substring(2)).startsWith("ACTION ")) {
                    return s;
                }
                if (msg.startsWith("DCC ")) {
                    return IRCFilter.filterDCCOut(field[0] + ' ' + field[1] + " :\u0001DCC ", msg.substring(4), helper);
                }
                if (msg.toUpperCase(Locale.US).startsWith("XDCC ") && helper != null && helper.isEnabled()) {
                    return s;
                }
                return null;
            }
            return s;
        }
        if ("USER".equals(command)) {
            if (field.length < 3) {
                return s;
            }
            int idx = field[2].lastIndexOf(58);
            if (idx < 0) {
                return "USER user hostname localhost :realname";
            }
            String realname = field[2].substring(idx + 1);
            String ret = "USER " + field[1] + " hostname localhost :" + realname;
            return ret;
        }
        if ("PART".equals(command)) {
            return "PART " + field[1] + " :leaving";
        }
        if ("QUIT".equals(command)) {
            return "QUIT :leaving";
        }
        return null;
    }

    private static String filterDCCIn(String pfx, String msg, DCCHelper helper) {
        int cPort;
        String[] args;
        int ctcp = msg.indexOf(1);
        if (ctcp > 0) {
            msg = msg.substring(0, ctcp);
        }
        if ((args = DataHelper.split(msg, " ", 5)).length <= 0) {
            return null;
        }
        String type = args[0];
        boolean haveIP = true;
        if (type == "RESUME" || type == "ACCEPT") {
            haveIP = false;
        } else if (!type.equals("CHAT") && !type.equals("SEND")) {
            return null;
        }
        if (helper == null || !helper.isEnabled()) {
            return null;
        }
        if (args.length < 3) {
            return null;
        }
        if (haveIP && args.length < 4) {
            return null;
        }
        String arg = args[1];
        int nextArg = 2;
        String b32 = null;
        if (haveIP) {
            b32 = args[nextArg++];
        }
        try {
            String cp = args[nextArg++];
            cPort = Integer.parseInt(cp);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (cPort < 0 || cPort > 65535) {
            return null;
        }
        int port = -1;
        if (haveIP) {
            port = cPort > 0 ? helper.newIncoming(b32, cPort, type) : cPort;
        } else if (type.equals("ACCEPT")) {
            port = helper.acceptIncoming(cPort);
        } else if (type.equals("RESUME")) {
            port = helper.resumeIncoming(cPort);
        }
        if (port < 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(pfx).append(type).append(' ').append(arg).append(' ');
        if (haveIP) {
            if (port > 0) {
                byte[] myIP = helper.getLocalAddress();
                buf.append(DataHelper.fromLong(myIP, 0, myIP.length)).append(' ');
            } else {
                buf.append("0 ");
            }
        }
        buf.append(port);
        while (args.length > nextArg) {
            buf.append(' ').append(args[nextArg++]);
        }
        if (pfx.indexOf(1) >= 0) {
            buf.append('\u0001');
        }
        return buf.toString();
    }

    private static String filterDCCOut(String pfx, String msg, DCCHelper helper) {
        int cPort;
        String[] args;
        int ctcp = msg.indexOf(1);
        if (ctcp > 0) {
            msg = msg.substring(0, ctcp);
        }
        if ((args = DataHelper.split(msg, " ", 5)).length <= 0) {
            return null;
        }
        String type = args[0];
        boolean haveIP = true;
        if (type == "RESUME" || type == "ACCEPT") {
            haveIP = false;
        } else if (type.equals("CHAT") || !type.equals("SEND")) {
            // empty if block
        }
        if (helper == null || !helper.isEnabled()) {
            return null;
        }
        if (args.length < 3) {
            return null;
        }
        if (haveIP && args.length < 4) {
            return null;
        }
        String arg = args[1];
        byte[] ip = null;
        int nextArg = 2;
        if (haveIP) {
            try {
                String ips = args[nextArg++];
                long ipl = Long.parseLong(ips);
                if (ipl < 0x1000000L) {
                    Log log = new Log(IRCFilter.class);
                    log.logAlways(30, "Reverse / Firewall DCC, IP = 0x" + Long.toHexString(ipl));
                }
                ip = DataHelper.toLong(4, ipl);
            }
            catch (NumberFormatException nfe) {
                return null;
            }
        }
        try {
            String cp = args[nextArg++];
            cPort = Integer.parseInt(cp);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        if (cPort < 0 || cPort > 65535) {
            return null;
        }
        int port = -1;
        if (haveIP) {
            if (cPort > 0) {
                if (ip[0] == 0) {
                    ip = new byte[]{127, 0, 0, 1};
                }
                port = helper.newOutgoing(ip, cPort, type);
            } else {
                Log log = new Log(IRCFilter.class);
                log.logAlways(30, "Reverse / Firewall DCC, port = 0");
                port = cPort;
            }
        } else if (type.equals("ACCEPT")) {
            port = helper.acceptOutgoing(cPort);
        } else if (type.equals("RESUME")) {
            port = helper.resumeOutgoing(cPort);
        }
        if (port < 0) {
            return null;
        }
        StringBuilder buf = new StringBuilder(256);
        buf.append(pfx).append(type).append(' ').append(arg).append(' ');
        if (haveIP) {
            if (port > 0) {
                buf.append(helper.getB32Hostname()).append(' ');
            } else {
                buf.append("0 ");
            }
        }
        buf.append(port);
        while (args.length > nextArg) {
            buf.append(' ').append(args[nextArg++]);
        }
        if (pfx.indexOf(1) >= 0) {
            buf.append('\u0001');
        }
        return buf.toString();
    }

    static {
        String[] allowedCommands = new String[]{"PING", "MODE", "JOIN", "NICK", "QUIT", "PART", "WALLOPS", "ERROR", "KICK", "H", "TOPIC", "AUTHENTICATE", "CAP", "PROTOCTL", "AWAY"};
        _allowedInbound = new HashSet<String>(Arrays.asList(allowedCommands));
        allowedCommands = new String[]{"ACCEPT", "ADMIN", "AUTHENTICATE", "AWAY", "CAP", "COMMANDS", "CYCLE", "DCCALLOW", "DEVOICE", "FPART", "HELPME", "HELPOP", "INVITE", "ISON", "JOIN", "KICK", "KNOCK", "LINKS", "LIST", "LUSERS", "MAP", "MODE", "MOTD", "NAMES", "NICK", "OPER", "PASS", "PONG", "PROTOCTL", "RULES", "SETNAME", "SILENCE", "SSLINFO", "STATS", "TBAN", "TITLE", "TOPIC", "UNINVITE", "USERHOST", "USERS", "VHOST", "VHOST", "WATCH", "WHO", "WHOIS", "WHOWAS", "BOTSERV", "BS", "CHANSERV", "CS", "HELPSERV", "HOSTSERV", "HS", "MEMOSERV", "MS", "NICKSERV", "NS", "OPERSERV", "OS", "STATSERV", "ADCHAT", "ADDMOTD", "ADDOMOTD", "CBAN", "CHATOPS", "CHECK", "CHGHOST", "CHGIDENT", "CHGNAME", "CLOSE", "DCCDENY", "DIE", "ELINE", "FILTER", "GLINE", "GLOBOPS", "GZLINE", "HTM", "JUMPSERVER", "KILL", "KLINE", "LOADMODULE", "LOCKSERV", "LOCOPS", "MKPASSWD", "NACHAT", "NICKLOCK", "NICKUNLOCK", "OLINE", "OPERMOTD", "REHASH", "RELOADMODULE", "RESTART", "RLINE", "SAJOIN", "SAKICK", "SAMODE", "SANICK", "SAPART", "SATOPIC", "SDESC", "SETHOST", "SETIDENT", "SHUN", "SPAMFILTER", "SQUIT", "TEMPSHUN", "TLINE", "UNDCCDENY", "UNLOCKSERV", "WALLOPS", "ZLINE"};
        _allowedOutbound = new HashSet<String>(Arrays.asList(allowedCommands));
    }
}

