/*
 * Decompiled with CFR 0.152.
 */
package training.commands.kotlin;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.util.DocumentUtil;
import java.awt.Component;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.commands.kotlin.PreviousTaskInfo;
import training.learn.lesson.kimpl.LearningDsl;
import training.learn.lesson.kimpl.LearningDslBase;
import training.learn.lesson.kimpl.LessonExecutor;
import training.learn.lesson.kimpl.LessonSample;
import training.learn.lesson.kimpl.LessonSamplePosition;

@LearningDsl
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003B1\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0002\u0010\rJ\u000e\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020)J\u0016\u0010'\u001a\u00020\n2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)J\u0016\u0010'\u001a\u00020\n2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/J\u000e\u0010'\u001a\u00020\n2\u0006\u00100\u001a\u000201J\u0010\u00102\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0017\u00103\u001a\u0004\u0018\u00010)2\u0006\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u00104J&\u0010.\u001a\u00020\n2\u0006\u00105\u001a\u00020)2\u0006\u00106\u001a\u00020)2\u0006\u00107\u001a\u00020)2\u0006\u00108\u001a\u00020)J\u0010\u00109\u001a\u00020\n2\u0006\u00100\u001a\u000201H\u0002J\u0010\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020-H\u0002J\u000e\u0010<\u001a\u00020\n2\u0006\u0010=\u001a\u00020>J\u0010\u0010?\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0019\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0018R\u0011\u0010#\u001a\u00020$8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010&\u00a8\u0006@"}, d2={"Ltraining/commands/kotlin/TaskRuntimeContext;", "Ltraining/learn/lesson/kimpl/LearningDslBase;", "base", "(Ltraining/commands/kotlin/TaskRuntimeContext;)V", "lessonExecutor", "Ltraining/learn/lesson/kimpl/LessonExecutor;", "taskDisposable", "Lcom/intellij/openapi/Disposable;", "restorePreviousTaskCallback", "Lkotlin/Function0;", "", "previousGetter", "Ltraining/commands/kotlin/PreviousTaskInfo;", "(Ltraining/learn/lesson/kimpl/LessonExecutor;Lcom/intellij/openapi/Disposable;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "focusOwner", "Ljava/awt/Component;", "getFocusOwner", "()Ljava/awt/Component;", "lessonDisposable", "getLessonDisposable", "()Lcom/intellij/openapi/Disposable;", "previous", "getPrevious", "()Ltraining/commands/kotlin/PreviousTaskInfo;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRestorePreviousTaskCallback", "()Lkotlin/jvm/functions/Function0;", "getTaskDisposable", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "caret", "offset", "", "line", "column", "text", "", "select", "", "position", "Ltraining/learn/lesson/kimpl/LessonSamplePosition;", "doUndoableAction", "getStartOffsetForText", "(Ljava/lang/String;)Ljava/lang/Integer;", "startLine", "startColumn", "endLine", "endColumn", "setCaret", "setDocumentCode", "code", "setSample", "sample", "Ltraining/learn/lesson/kimpl/LessonSample;", "updateGutter", "intellij.featuresTrainer"})
public class TaskRuntimeContext
implements LearningDslBase {
    private final LessonExecutor lessonExecutor;
    @NotNull
    private final Disposable taskDisposable;
    @NotNull
    private final Function0<Unit> restorePreviousTaskCallback;
    private final Function0<PreviousTaskInfo> previousGetter;

    @NotNull
    public final Editor getEditor() {
        return this.lessonExecutor.getEditor();
    }

    @NotNull
    public final Project getProject() {
        return this.lessonExecutor.getProject();
    }

    @NotNull
    public final Disposable getLessonDisposable() {
        return this.lessonExecutor;
    }

    @Nullable
    public final Component getFocusOwner() {
        IdeFocusManager ideFocusManager = IdeFocusManager.getInstance((Project)this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)ideFocusManager, (String)"IdeFocusManager.getInstance(project)");
        return ideFocusManager.getFocusOwner();
    }

    @NotNull
    public final PreviousTaskInfo getPrevious() {
        return (PreviousTaskInfo)this.previousGetter.invoke();
    }

    @NotNull
    public final VirtualFile getVirtualFile() {
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(this.getEditor().getDocument());
        if (virtualFile == null) {
            String string = "No virtual file for " + this.getEditor().getDocument();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        return virtualFile;
    }

    public final void setSample(@NotNull LessonSample sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        ModalityState modalityState$iv = ModalityState.NON_MODAL;
        boolean $i$f$invokeLater = false;
        Application application = ApplicationManager.getApplication();
        Runnable runnable2 = new Runnable(this, sample){
            final /* synthetic */ TaskRuntimeContext this$0;
            final /* synthetic */ LessonSample $sample$inlined;
            {
                this.this$0 = taskRuntimeContext;
                this.$sample$inlined = lessonSample;
            }

            public final void run() {
                boolean bl = false;
                Editor editor = this.this$0.getEditor();
                if (!(editor instanceof EditorEx)) {
                    editor = null;
                }
                EditorEx editorEx = (EditorEx)editor;
                if (editorEx != null) {
                    editorEx.setViewer(false);
                }
                TaskRuntimeContext.access$setDocumentCode(this.this$0, this.$sample$inlined.getText());
                TaskRuntimeContext.access$setCaret(this.this$0, this.$sample$inlined.getPosition(0));
            }
        };
        ModalityState modalityState = modalityState$iv;
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"ModalityState.defaultModalityState()");
        }
        application.invokeLater(runnable2, modalityState);
    }

    public final void select(int startLine, int startColumn, int endLine, int endColumn) {
        LogicalPosition blockStart = new LogicalPosition(startLine - 1, startColumn - 1);
        LogicalPosition blockEnd = new LogicalPosition(endLine - 1, endColumn - 1);
        int startPosition = this.getEditor().logicalPositionToOffset(blockStart);
        int endPosition = this.getEditor().logicalPositionToOffset(blockEnd);
        this.getEditor().getCaretModel().moveToOffset(startPosition);
        this.getEditor().getSelectionModel().setSelection(startPosition, endPosition);
    }

    public final void caret(@NotNull String text2, boolean select2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        Integer n = this.getStartOffsetForText(text2);
        if (n == null) {
            return;
        }
        int start = n;
        this.getEditor().getCaretModel().moveToOffset(start);
        if (select2) {
            this.getEditor().getSelectionModel().setSelection(start, start + text2.length());
        }
    }

    public final void caret(int line, int column) {
        new OpenFileDescriptor(this.getProject(), this.getVirtualFile(), line - 1, column - 1).navigateIn(this.getEditor());
    }

    public final void caret(int offset) {
        new OpenFileDescriptor(this.getProject(), this.getVirtualFile(), offset).navigateIn(this.getEditor());
    }

    public final void caret(@NotNull LessonSamplePosition position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        this.setCaret(position);
    }

    private final void setDocumentCode(String code) {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        DocumentUtil.writeInRunUndoTransparentAction((Runnable)new Runnable(this, document2, code){
            final /* synthetic */ TaskRuntimeContext this$0;
            final /* synthetic */ Document $document;
            final /* synthetic */ String $code;

            public final void run() {
                DocumentReference documentReference = DocumentReferenceManager.getInstance().create(this.$document);
                Intrinsics.checkNotNullExpressionValue((Object)documentReference, (String)"DocumentReferenceManager\u2026stance().create(document)");
                DocumentReference documentReference2 = documentReference;
                UndoManager.getInstance((Project)this.this$0.getProject()).nonundoableActionPerformed(documentReference2, false);
                this.$document.replaceString(0, this.$document.getTextLength(), (CharSequence)this.$code);
            }
            {
                this.this$0 = taskRuntimeContext;
                this.$document = document;
                this.$code = string;
            }
        });
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document2);
        this.doUndoableAction(this.getProject());
        this.updateGutter(this.getEditor());
    }

    private final void doUndoableAction(Project project) {
        CommandProcessor.getInstance().executeCommand(project, new Runnable(project){
            final /* synthetic */ Project $project;

            public final void run() {
                UndoManager.getInstance((Project)this.$project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(){

                    public void undo() {
                    }

                    public void redo() {
                    }
                });
            }
            {
                this.$project = project;
            }
        }, null, null);
    }

    private final void updateGutter(Editor editor) {
        EditorGutter editorGutter = editor.getGutter();
        if (editorGutter == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.EditorGutterComponentEx");
        }
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)editorGutter;
        editorGutterComponentEx.revalidateMarkup();
    }

    private final void setCaret(LessonSamplePosition position) {
        Pair<Integer, Integer> pair = position.getSelection();
        if (pair != null) {
            Pair<Integer, Integer> pair2 = pair;
            boolean bl = false;
            boolean bl2 = false;
            Pair<Integer, Integer> it = pair2;
            boolean bl3 = false;
            this.getEditor().getSelectionModel().setSelection(((Number)it.getFirst()).intValue(), ((Number)it.getSecond()).intValue());
        }
        this.getEditor().getCaretModel().moveToOffset(position.getStartOffset());
    }

    private final Integer getStartOffsetForText(String text2) {
        Document document = this.getEditor().getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        CharSequence charSequence = document2.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.charsSequence");
        int indexOf = StringsKt.indexOf$default((CharSequence)charSequence, (String)text2, (int)0, (boolean)false, (int)6, null);
        if (indexOf != -1) {
            return indexOf;
        }
        return null;
    }

    @NotNull
    public final Disposable getTaskDisposable() {
        return this.taskDisposable;
    }

    @NotNull
    public final Function0<Unit> getRestorePreviousTaskCallback() {
        return this.restorePreviousTaskCallback;
    }

    public TaskRuntimeContext(@NotNull LessonExecutor lessonExecutor, @NotNull Disposable taskDisposable, @NotNull Function0<Unit> restorePreviousTaskCallback, @NotNull Function0<? extends PreviousTaskInfo> previousGetter) {
        Intrinsics.checkNotNullParameter((Object)lessonExecutor, (String)"lessonExecutor");
        Intrinsics.checkNotNullParameter((Object)taskDisposable, (String)"taskDisposable");
        Intrinsics.checkNotNullParameter(restorePreviousTaskCallback, (String)"restorePreviousTaskCallback");
        Intrinsics.checkNotNullParameter(previousGetter, (String)"previousGetter");
        this.lessonExecutor = lessonExecutor;
        this.taskDisposable = taskDisposable;
        this.restorePreviousTaskCallback = restorePreviousTaskCallback;
        this.previousGetter = previousGetter;
    }

    public TaskRuntimeContext(@NotNull TaskRuntimeContext base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        this(base.lessonExecutor, base.taskDisposable, base.restorePreviousTaskCallback, base.previousGetter);
    }

    @Override
    @NotNull
    public String action(@NotNull String actionId) {
        Intrinsics.checkNotNullParameter((Object)actionId, (String)"actionId");
        return LearningDslBase.DefaultImpls.action(this, actionId);
    }

    @Override
    @NotNull
    public String code(@NotNull String sourceSample) {
        Intrinsics.checkNotNullParameter((Object)sourceSample, (String)"sourceSample");
        return LearningDslBase.DefaultImpls.code(this, sourceSample);
    }

    @Override
    @NotNull
    public String strong(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return LearningDslBase.DefaultImpls.strong(this, text2);
    }

    @Override
    @NotNull
    public String icon(@NotNull Icon icon) {
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        return LearningDslBase.DefaultImpls.icon(this, icon);
    }

    @Override
    @NotNull
    public String shortcut(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return LearningDslBase.DefaultImpls.shortcut(this, key);
    }

    public static final /* synthetic */ void access$setDocumentCode(TaskRuntimeContext $this, String code) {
        $this.setDocumentCode(code);
    }

    public static final /* synthetic */ void access$setCaret(TaskRuntimeContext $this, LessonSamplePosition position) {
        $this.setCaret(position);
    }
}

