/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.lang.LangManager;
import training.lang.LangSupport;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.ui.LearnToolWindow;
import training.ui.UISettings;
import training.ui.views.LanguageChoosePanelPlace;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 $2\u00020\u0001:\u0002$%B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u0004\u0018\u00010\u00112\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002J\b\u0010\u001a\u001a\u00020\u0017H\u0002J\u0006\u0010\u001b\u001a\u00020\u0013J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020!H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltraining/ui/views/LanguageChoosePanel;", "Ljavax/swing/JPanel;", "toolWindow", "Ltraining/ui/LearnToolWindow;", "opaque", "", "addButton", "(Ltraining/ui/LearnToolWindow;ZZ)V", "buttonGroup", "Ljavax/swing/ButtonGroup;", "caption", "Ljavax/swing/JLabel;", "description", "Ltraining/ui/views/LanguageChoosePanel$MyJTextPane;", "mainPanel", "myRadioButtonMap", "", "Ljavax/swing/JRadioButton;", "Lcom/intellij/lang/LanguageExtensionPoint;", "Ltraining/lang/LangSupport;", "place", "Ltraining/ui/views/LanguageChoosePanelPlace;", "createLearnButton", "Ljavax/swing/JButton;", "createRadioButton", "langSupportExt", "createResetResultsButton", "getActiveLangSupport", "getBackground", "Ljava/awt/Color;", "getPreferredSize", "Ljava/awt/Dimension;", "init", "", "initMainPanel", "initSouthPanel", "Companion", "MyJTextPane", "intellij.featuresTrainer"})
public final class LanguageChoosePanel
extends JPanel {
    private final LanguageChoosePanelPlace place;
    private final JLabel caption;
    private final MyJTextPane description;
    private final JPanel mainPanel;
    private final Map<JRadioButton, LanguageExtensionPoint<LangSupport>> myRadioButtonMap;
    private final ButtonGroup buttonGroup;
    private final LearnToolWindow toolWindow;
    private final boolean addButton;
    private static final Logger LOG;
    private static final SimpleAttributeSet REGULAR;
    private static final SimpleAttributeSet REGULAR_GRAY;
    private static final SimpleAttributeSet PARAGRAPH_STYLE;
    public static final Companion Companion;

    private final void init() {
        this.caption.setOpaque(false);
        this.caption.setFont(UISettings.Companion.getInstance().getModulesFont());
        this.description.setOpaque(false);
        this.description.setEditable(false);
        this.description.setAlignmentX(0.0f);
        this.description.setMargin((Insets)JBUI.emptyInsets());
        this.description.setBorder(new EmptyBorder(0, 0, 0, 0));
        StyleConstants.setFontFamily(REGULAR, UISettings.Companion.getInstance().getPlainFont().getFamily());
        StyleConstants.setFontSize(REGULAR, (int)UISettings.Companion.getInstance().getFontSize());
        StyleConstants.setForeground(REGULAR, (Color)UISettings.Companion.getInstance().getQuestionColor());
        StyleConstants.setFontFamily(REGULAR_GRAY, UISettings.Companion.getInstance().getPlainFont().getFamily());
        StyleConstants.setFontSize(REGULAR_GRAY, (int)UISettings.Companion.getInstance().getFontSize());
        StyleConstants.setForeground(REGULAR_GRAY, UISettings.Companion.getInstance().getDescriptionColor());
        StyleConstants.setLeftIndent(PARAGRAPH_STYLE, 0.0f);
        StyleConstants.setRightIndent(PARAGRAPH_STYLE, 0.0f);
        StyleConstants.setSpaceAbove(PARAGRAPH_STYLE, 0.0f);
        StyleConstants.setSpaceBelow(PARAGRAPH_STYLE, 0.0f);
        StyleConstants.setLineSpacing(PARAGRAPH_STYLE, 0.0f);
    }

    private final JButton createLearnButton() {
        JButton button2 = new JButton();
        button2.setOpaque(false);
        button2.setAction(new AbstractAction(this, LearnBundle.INSTANCE.messageInPlace("learn.choose.language.button", this.place, new Object[0])){
            final /* synthetic */ LanguageChoosePanel this$0;

            public void actionPerformed(@Nullable ActionEvent e) {
                block0: {
                    UtilsKt.resetPrimaryLanguage(this.this$0.getActiveLangSupport());
                    LearnToolWindow learnToolWindow = LanguageChoosePanel.access$getToolWindow$p(this.this$0);
                    if (learnToolWindow == null) break block0;
                    learnToolWindow.setModulesPanel();
                }
            }
            {
                this.this$0 = this$0;
                super($super_call_param$1);
            }
        });
        return button2;
    }

    private final JButton createResetResultsButton() {
        JButton button2 = new JButton();
        button2.setAction(new AbstractAction(button2){
            final /* synthetic */ JButton $button;

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$button.setEnabled(false);
            }
            {
                this.$button = $captured_local_variable$0;
            }
        });
        button2.setOpaque(false);
        button2.setAction(new AbstractAction(LearnBundle.INSTANCE.message("learn.choose.language.button.reset.tool.window", new Object[0])){

            public void actionPerformed(@Nullable ActionEvent e) {
                UtilsKt.clearTrainingProgress();
            }
        });
        return button2;
    }

    private final void initMainPanel() {
        JPanel jPanel = this.mainPanel;
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel;
        boolean bl3 = false;
        $this$apply.setLayout(new BoxLayout($this$apply, 3));
        $this$apply.setOpaque(false);
        $this$apply.setFocusable(false);
        $this$apply.add(this.caption);
        $this$apply.add(Box.createVerticalStrut(UISettings.Companion.getInstance().getAfterCaptionGap()));
        $this$apply.add(this.description);
        $this$apply.add(Box.createVerticalStrut(UISettings.Companion.getInstance().getGroupGap()));
        if (Intrinsics.areEqual((Object)this.place, (Object)LanguageChoosePanelPlace.TOOL_WINDOW.INSTANCE)) {
            $this$apply.setBorder(UISettings.Companion.getInstance().getCheckmarkShiftBorder());
        }
        try {
            this.initSouthPanel();
        }
        catch (BadLocationException e) {
            LOG.warn((Throwable)e);
        }
        this.caption.setText(LearnBundle.INSTANCE.messageInPlace("learn.choose.language.caption", this.place, new Object[0]));
        try {
            this.description.getDocument().insertString(0, LearnBundle.INSTANCE.messageInPlace("learn.choose.language.description", this.place, new Object[0]), REGULAR);
        }
        catch (BadLocationException e) {
            LOG.warn((Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initSouthPanel() throws BadLocationException {
        JPanel radioButtonPanel = new JPanel();
        radioButtonPanel.setOpaque(false);
        radioButtonPanel.setBorder(new EmptyBorder(0, 12, 0, 0));
        radioButtonPanel.setLayout(new BoxLayout(radioButtonPanel, 3));
        List<LanguageExtensionPoint<LangSupport>> supportedLanguagesExtensions = LangManager.Companion.getInstance().getSupportedLanguagesExtensions();
        if (supportedLanguagesExtensions.isEmpty()) {
            void $this$apply;
            String message = LearnBundle.INSTANCE.message("no.supported.languages.found", new Object[0]);
            LOG.error(message);
            JLabel jLabel = new JLabel();
            boolean bl = false;
            boolean bl2 = false;
            JLabel jLabel2 = jLabel;
            JPanel jPanel = this.mainPanel;
            boolean bl3 = false;
            $this$apply.setText(message);
            $this$apply.setFont(UISettings.Companion.getInstance().getBoldFont());
            Unit unit = Unit.INSTANCE;
            jPanel.add(jLabel);
            return;
        }
        for (LanguageExtensionPoint<LangSupport> langSupportExt : supportedLanguagesExtensions) {
            JRadioButton radioButton;
            if (this.createRadioButton(langSupportExt) == null) {
                continue;
            }
            this.buttonGroup.add(radioButton);
            this.myRadioButtonMap.put(radioButton, langSupportExt);
            radioButtonPanel.add((Component)radioButton, Float.valueOf(0.0f));
        }
        if (LangManager.Companion.getInstance().getLangSupport() != null) {
            Object v1;
            block10: {
                Iterable $this$firstOrNull$iv = this.myRadioButtonMap.keySet();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    JRadioButton it = (JRadioButton)element$iv;
                    boolean bl = false;
                    LanguageExtensionPoint<LangSupport> languageExtensionPoint = this.myRadioButtonMap.get(it);
                    if (!Intrinsics.areEqual((Object)(languageExtensionPoint != null ? (LangSupport)languageExtensionPoint.getInstance() : null), (Object)LangManager.Companion.getInstance().getLangSupport())) continue;
                    v1 = element$iv;
                    break block10;
                }
                v1 = null;
            }
            JRadioButton button2 = v1;
            if (button2 != null) {
                this.buttonGroup.setSelected(button2.getModel(), true);
            } else {
                AbstractButton abstractButton = this.buttonGroup.getElements().nextElement();
                Intrinsics.checkNotNullExpressionValue((Object)abstractButton, (String)"buttonGroup.elements.nextElement()");
                this.buttonGroup.setSelected(abstractButton.getModel(), true);
            }
        } else {
            AbstractButton abstractButton = this.buttonGroup.getElements().nextElement();
            Intrinsics.checkNotNullExpressionValue((Object)abstractButton, (String)"buttonGroup.elements.nextElement()");
            this.buttonGroup.setSelected(abstractButton.getModel(), true);
        }
        this.mainPanel.add(radioButtonPanel);
        this.mainPanel.add(Box.createVerticalStrut(UISettings.Companion.getInstance().getGroupGap()));
        if (this.addButton) {
            this.mainPanel.add(this.createLearnButton());
        }
        if (this.addButton && Intrinsics.areEqual((Object)this.place, (Object)LanguageChoosePanelPlace.TOOL_WINDOW.INSTANCE)) {
            this.mainPanel.add(Box.createVerticalStrut(UISettings.Companion.getInstance().getLanguagePanelButtonsGap()));
            this.mainPanel.add(this.createResetResultsButton());
        }
    }

    private final JRadioButton createRadioButton(LanguageExtensionPoint<LangSupport> langSupportExt) {
        CourseManager courseManager = CourseManager.Companion.getInstance();
        Object object = langSupportExt.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"langSupportExt.instance");
        int lessonsCount = courseManager.calcLessonsForLanguage((LangSupport)object);
        Language language = Language.findLanguageByID((String)langSupportExt.language);
        if (language == null) {
            return null;
        }
        Language lang = language;
        CourseManager courseManager2 = CourseManager.Companion.getInstance();
        Object object2 = langSupportExt.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"langSupportExt.instance");
        int passedLessons = courseManager2.calcPassedLessonsForLanguage((LangSupport)object2);
        String passedString = passedLessons > 0 ? LearnBundle.INSTANCE.message("language.specific.course.passed", passedLessons) : "";
        Object[] objectArray = new Object[4];
        String string = lang.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"lang.displayName");
        objectArray[0] = string;
        objectArray[1] = lessonsCount;
        objectArray[2] = lessonsCount;
        objectArray[3] = passedString;
        String buttonName = LearnBundle.INSTANCE.message("language.specific.course.description", objectArray);
        JRadioButton radioButton = new JRadioButton(buttonName);
        radioButton.setBorder(UISettings.Companion.getInstance().getRadioButtonBorder());
        radioButton.setOpaque(false);
        return radioButton;
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        return new Dimension((int)this.mainPanel.getMinimumSize().getWidth() + (UISettings.Companion.getInstance().getWestInset() + UISettings.Companion.getInstance().getEastInset()), (int)this.mainPanel.getMinimumSize().getHeight() + (UISettings.Companion.getInstance().getNorthInset() + UISettings.Companion.getInstance().getSouthInset()));
    }

    @Override
    @NotNull
    public Color getBackground() {
        Color color;
        if (!UIUtil.isUnderDarcula()) {
            color = UISettings.Companion.getInstance().getBackgroundColor();
        } else {
            Color color2 = UIUtil.getPanelBackground();
            color = color2;
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"UIUtil.getPanelBackground()");
        }
        return color;
    }

    @NotNull
    public final LangSupport getActiveLangSupport() {
        Object v3;
        boolean bl;
        boolean bl2;
        block5: {
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"buttonGroup.elements");
            Object object = enumeration;
            bl2 = false;
            ArrayList<AbstractButton> arrayList = Collections.list(object);
            Intrinsics.checkNotNullExpressionValue(arrayList, (String)"java.util.Collections.list(this)");
            object = arrayList;
            bl2 = false;
            Object object2 = object;
            bl = false;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                AbstractButton button2 = (AbstractButton)t;
                boolean bl3 = false;
                AbstractButton abstractButton = button2;
                Intrinsics.checkNotNullExpressionValue((Object)abstractButton, (String)"button");
                if (!abstractButton.isSelected()) continue;
                v3 = t;
                break block5;
            }
            v3 = null;
        }
        AbstractButton abstractButton = v3;
        if (abstractButton == null) {
            throw (Throwable)new Exception("Unable to get active language");
        }
        AbstractButton activeButton = abstractButton;
        boolean bl4 = activeButton instanceof JRadioButton;
        bl2 = false;
        boolean bl5 = false;
        if (_Assertions.ENABLED && !bl4) {
            bl = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map<JRadioButton, LanguageExtensionPoint<LangSupport>> map = this.myRadioButtonMap;
        bl2 = false;
        Map<JRadioButton, LanguageExtensionPoint<LangSupport>> map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
        }
        boolean bl6 = map2.containsKey(activeButton);
        bl2 = false;
        bl5 = false;
        if (_Assertions.ENABLED && !bl6) {
            bl = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Map<JRadioButton, LanguageExtensionPoint<LangSupport>> map3 = this.myRadioButtonMap;
        bl2 = false;
        LanguageExtensionPoint<LangSupport> languageExtensionPoint = map3.get(activeButton);
        Intrinsics.checkNotNull(languageExtensionPoint);
        Object object = languageExtensionPoint.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"myRadioButtonMap[activeButton]!!.instance");
        return (LangSupport)object;
    }

    public LanguageChoosePanel(@Nullable LearnToolWindow toolWindow, boolean opaque, boolean addButton) {
        this.toolWindow = toolWindow;
        this.addButton = addButton;
        this.place = this.toolWindow == null ? (LanguageChoosePanelPlace)LanguageChoosePanelPlace.WELCOME_SCREEN.INSTANCE : (LanguageChoosePanelPlace)LanguageChoosePanelPlace.TOOL_WINDOW.INSTANCE;
        this.caption = new JLabel();
        this.description = new MyJTextPane(UISettings.Companion.getInstance().getWidth());
        this.mainPanel = new JPanel();
        boolean bl = false;
        this.myRadioButtonMap = new LinkedHashMap();
        this.buttonGroup = new ButtonGroup();
        this.setLayout(new BoxLayout(this, 1));
        this.setFocusable(false);
        this.init();
        this.setOpaque(opaque);
        this.setBackground(this.getBackground());
        this.initMainPanel();
        this.add(this.mainPanel);
        this.setPreferredSize(new Dimension(UISettings.Companion.getInstance().getWidth(), 100));
        this.setBorder(UISettings.Companion.getInstance().getEmptyBorder());
        this.revalidate();
        this.repaint();
    }

    public /* synthetic */ LanguageChoosePanel(LearnToolWindow learnToolWindow, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(learnToolWindow, bl, bl2);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(LanguageChoosePanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Langu\u2026eChoosePanel::class.java)");
        LOG = logger;
        REGULAR = new SimpleAttributeSet();
        REGULAR_GRAY = new SimpleAttributeSet();
        PARAGRAPH_STYLE = new SimpleAttributeSet();
    }

    public static final /* synthetic */ LearnToolWindow access$getToolWindow$p(LanguageChoosePanel $this) {
        return $this.toolWindow;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ltraining/ui/views/LanguageChoosePanel$MyJTextPane;", "Ljavax/swing/JTextPane;", "widthOfText", "", "(Ltraining/ui/views/LanguageChoosePanel;I)V", "getMaximumSize", "Ljava/awt/Dimension;", "getPreferredSize", "intellij.featuresTrainer"})
    private final class MyJTextPane
    extends JTextPane {
        private final int widthOfText;

        @Override
        @NotNull
        public Dimension getPreferredSize() {
            return new Dimension(this.widthOfText, super.getPreferredSize().height);
        }

        @Override
        @NotNull
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public MyJTextPane(int widthOfText) {
            this.widthOfText = widthOfText;
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Ltraining/ui/views/LanguageChoosePanel$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "PARAGRAPH_STYLE", "Ljavax/swing/text/SimpleAttributeSet;", "REGULAR", "REGULAR_GRAY", "intellij.featuresTrainer"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

