/*
 * Decompiled with CFR 0.152.
 */
package training.ui.views;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import icons.FeaturesTrainerIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.learn.CourseManager;
import training.learn.LearnBundle;
import training.learn.interfaces.Lesson;
import training.learn.interfaces.Module;
import training.learn.lesson.LessonManager;
import training.ui.UISettings;
import training.ui.views.LearningItemsKt;
import training.util.UtilsKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\u00012\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0010\u001a\u00020\u0005H\u0002J\u0012\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Ltraining/ui/views/LearningItems;", "Ljavax/swing/JPanel;", "()V", "expanded", "", "Ltraining/learn/interfaces/Module;", "modules", "", "getModules", "()Ljava/util/List;", "setModules", "(Ljava/util/List;)V", "createLessonItem", "lesson", "Ltraining/learn/interfaces/Lesson;", "createModuleItem", "module", "createModuleProgressLabel", "Lcom/intellij/ui/components/JBLabel;", "updateItems", "", "showModule", "intellij.featuresTrainer"})
public final class LearningItems
extends JPanel {
    @NotNull
    private List<? extends Module> modules = CollectionsKt.emptyList();
    private final Set<Module> expanded;

    @NotNull
    public final List<Module> getModules() {
        return this.modules;
    }

    public final void setModules(@NotNull List<? extends Module> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.modules = list2;
    }

    public final void updateItems(@Nullable Module showModule) {
        if (showModule != null) {
            this.expanded.add(showModule);
        }
        this.setLayout((LayoutManager)new VerticalLayout(10));
        this.removeAll();
        for (Module module : this.modules) {
            if (module.getLessons().isEmpty()) continue;
            this.add(this.createModuleItem(module));
            if (!this.expanded.contains(module)) continue;
            for (Lesson lesson : module.getLessons()) {
                this.add(this.createLessonItem(lesson));
            }
        }
        this.revalidate();
        this.repaint();
    }

    public static /* synthetic */ void updateItems$default(LearningItems learningItems, Module module, int n, Object object) {
        if ((n & 1) != 0) {
            module = null;
        }
        learningItems.updateItems(module);
    }

    private final JPanel createLessonItem(Lesson lesson) {
        JPanel result2 = new JPanel();
        result2.setOpaque(false);
        result2.setLayout((LayoutManager)new HorizontalLayout(5));
        JLabel checkmarkIconLabel = new JLabel(lesson.getPassed() ? FeaturesTrainerIcons.Img.GreenCheckmark : EmptyIcon.ICON_16);
        result2.add(new JLabel(EmptyIcon.ICON_16));
        result2.add(checkmarkIconLabel);
        LinkLabel name = new LinkLabel(lesson.getName(), null);
        name.setListener((LinkListener)new LinkListener<Object>(this, lesson, name){
            final /* synthetic */ LearningItems this$0;
            final /* synthetic */ Lesson $lesson;
            final /* synthetic */ LinkLabel $name;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                boolean cantBeOpenedInDumb;
                Project project = ProjectUtil.guessCurrentProject((JComponent)this.this$0);
                DumbService dumbService = DumbService.getInstance((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(project)");
                boolean bl = cantBeOpenedInDumb = dumbService.isDumb() && !this.$lesson.getProperties().getCanStartInDumbMode();
                if (cantBeOpenedInDumb && !LessonManager.Companion.getInstance().lessonShouldBeOpenedCompleted(this.$lesson)) {
                    Balloon balloon = UtilsKt.createBalloon(LearnBundle.INSTANCE.message("indexing.message", new Object[0]));
                    balloon.showInCenterOf((JComponent)this.$name);
                    return;
                }
                CourseManager.Companion.getInstance().openLesson(project, this.$lesson);
            }
            {
                this.this$0 = learningItems;
                this.$lesson = lesson;
                this.$name = linkLabel2;
            }
        }, null);
        result2.add((Component)name);
        return result2;
    }

    private final JPanel createModuleItem(Module module) {
        JPanel modulePanel = new JPanel();
        modulePanel.setOpaque(false);
        modulePanel.setLayout((LayoutManager)new VerticalLayout(5));
        modulePanel.setBackground(new Color(0, 0, 0, 0));
        JPanel result2 = new JPanel();
        result2.setOpaque(true);
        result2.setBackground(UISettings.Companion.getInstance().getBackgroundColor());
        result2.setToolTipText(module.getDescription());
        result2.setLayout((LayoutManager)new HorizontalLayout(5));
        result2.setBorder((Border)JBUI.Borders.empty((int)5, (int)7));
        JPanel jPanel = new JPanel();
        boolean bl = false;
        boolean bl2 = false;
        JPanel it = jPanel;
        boolean bl3 = false;
        it.setLayout((LayoutManager)new VerticalLayout(5));
        it.setOpaque(false);
        it.setBackground(new Color(0, 0, 0, 0));
        Icon icon = IconUtil.toSize((Icon)(this.expanded.contains(module) ? UIUtil.getTreeExpandedIcon() : UIUtil.getTreeCollapsedIcon()), (int)JBUIScale.scale((int)16), (int)JBUIScale.scale((int)16));
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"IconUtil.toSize(if (expa\u202616), JBUIScale.scale(16))");
        Icon expandIcon = icon;
        JLabel expandIconLabel = new JLabel(expandIcon);
        it.add(expandIconLabel);
        JPanel expandPanel = jPanel;
        result2.add(expandPanel);
        JLabel name = new JLabel(module.getName());
        name.setFont(UISettings.Companion.getInstance().getModulesFont());
        modulePanel.add(name);
        JBLabel jBLabel = this.createModuleProgressLabel(module);
        if (jBLabel != null) {
            JBLabel jBLabel2 = jBLabel;
            bl2 = false;
            boolean bl4 = false;
            JBLabel it2 = jBLabel2;
            boolean bl5 = false;
            modulePanel.add((Component)it2);
        }
        result2.add(modulePanel);
        result2.addMouseListener(new MouseAdapter(this, result2, module){
            final /* synthetic */ LearningItems this$0;
            final /* synthetic */ JPanel $result;
            final /* synthetic */ Module $module;

            public void mouseReleased(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (!this.$result.getVisibleRect().contains(e.getPoint())) {
                    return;
                }
                if (LearningItems.access$getExpanded$p(this.this$0).contains(this.$module)) {
                    LearningItems.access$getExpanded$p(this.this$0).remove(this.$module);
                } else {
                    LearningItems.access$getExpanded$p(this.this$0).clear();
                    LearningItems.access$getExpanded$p(this.this$0).add(this.$module);
                }
                LearningItems.updateItems$default(this.this$0, null, 1, null);
            }

            public void mouseEntered(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$result.setBackground(LearningItemsKt.getHOVER_COLOR());
                this.$result.setCursor(Cursor.getPredefinedCursor(12));
                this.$result.revalidate();
                this.$result.repaint();
            }

            public void mouseExited(@NotNull MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$result.setBackground(UISettings.Companion.getInstance().getBackgroundColor());
                this.$result.setCursor(Cursor.getDefaultCursor());
                this.$result.revalidate();
                this.$result.repaint();
            }
            {
                this.this$0 = this$0;
                this.$result = $captured_local_variable$1;
                this.$module = $captured_local_variable$2;
            }
        });
        return result2;
    }

    private final JBLabel createModuleProgressLabel(Module module) {
        String string = module.calcProgress();
        if (string == null) {
            return null;
        }
        String progressStr = string;
        JBLabel progressLabel = new JBLabel(progressStr);
        progressLabel.setName("progressLabel");
        progressLabel.setForeground(module.hasNotPassedLesson() ? (Color)UISettings.Companion.getInstance().getModuleProgressColor() : (Color)UISettings.Companion.getInstance().getCompletedColor());
        return progressLabel;
    }

    public LearningItems() {
        boolean bl = false;
        this.expanded = new LinkedHashSet();
        this.setName("learningItems");
        this.setLayout((LayoutManager)new VerticalLayout(10));
        this.setBorder(UISettings.Companion.getInstance().getEastBorder());
        this.setOpaque(false);
        this.setFocusable(false);
    }

    public static final /* synthetic */ Set access$getExpanded$p(LearningItems $this) {
        return $this.expanded;
    }
}

