/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import gnu.trove.THashMap;
import java.io.File;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactNode;
import org.jetbrains.idea.maven.model.MavenArtifactState;
import org.jetbrains.idea.maven.model.MavenBuild;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.server.MavenModelConverter;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;

public class Maven30AetherModelConverter
extends MavenModelConverter {
    @NotNull
    public static MavenModel convertModelWithAetherDependencyTree(Model model, List<String> sources, List<String> testSources, Collection<? extends org.apache.maven.artifact.Artifact> dependencies, Collection<? extends DependencyNode> dependencyTree, Collection<? extends org.apache.maven.artifact.Artifact> extensions, File localRepository) throws RemoteException {
        MavenModel result = new MavenModel();
        result.setMavenId(new MavenId(model.getGroupId(), model.getArtifactId(), model.getVersion()));
        Parent parent = model.getParent();
        if (parent != null) {
            result.setParent(new MavenParent(new MavenId(parent.getGroupId(), parent.getArtifactId(), parent.getVersion()), parent.getRelativePath()));
        }
        result.setPackaging(model.getPackaging());
        result.setName(model.getName());
        result.setProperties(model.getProperties() == null ? new Properties() : model.getProperties());
        result.setPlugins(Maven30AetherModelConverter.convertPlugins((Model)model));
        THashMap convertedArtifacts = new THashMap();
        result.setExtensions(Maven30AetherModelConverter.convertArtifacts(extensions, (Map)convertedArtifacts, (File)localRepository));
        result.setDependencies(Maven30AetherModelConverter.convertArtifacts(dependencies, (Map)convertedArtifacts, (File)localRepository));
        result.setDependencyTree(Maven30AetherModelConverter.convertAetherDependencyNodes(null, dependencyTree, (Map<org.apache.maven.artifact.Artifact, MavenArtifact>)convertedArtifacts, localRepository));
        result.setRemoteRepositories(Maven30AetherModelConverter.convertRepositories((List)model.getRepositories()));
        result.setProfiles(Maven30AetherModelConverter.convertProfiles((Collection)model.getProfiles()));
        result.setModules(model.getModules());
        Maven30AetherModelConverter.convertBuild((MavenBuild)result.getBuild(), (Build)model.getBuild(), sources, testSources);
        MavenModel mavenModel = result;
        if (mavenModel == null) {
            Maven30AetherModelConverter.$$$reportNull$$$0(0);
        }
        return mavenModel;
    }

    public static List<MavenArtifactNode> convertAetherDependencyNodes(MavenArtifactNode parent, Collection<? extends DependencyNode> nodes, Map<org.apache.maven.artifact.Artifact, MavenArtifact> nativeToConvertedMap, File localRepository) {
        ArrayList<MavenArtifactNode> result = new ArrayList<MavenArtifactNode>(nodes.size());
        for (DependencyNode dependencyNode : nodes) {
            org.apache.maven.artifact.Artifact a = RepositoryUtils.toArtifact((Artifact)dependencyNode.getDependency().getArtifact());
            MavenArtifact ma = Maven30AetherModelConverter.convertArtifact((org.apache.maven.artifact.Artifact)a, nativeToConvertedMap, (File)localRepository);
            MavenArtifactNode newNode = new MavenArtifactNode(parent, ma, MavenArtifactState.ADDED, null, dependencyNode.getDependency().getScope(), dependencyNode.getPremanagedVersion(), dependencyNode.getPremanagedScope());
            newNode.setDependencies(Maven30AetherModelConverter.convertAetherDependencyNodes(newNode, dependencyNode.getChildren(), nativeToConvertedMap, localRepository));
            result.add(newNode);
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/Maven30AetherModelConverter", "convertModelWithAetherDependencyTree"));
    }
}

