/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.struct.gen.MethodDescriptor;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class ClasspathHelper {
    private static final Map<String, Method> METHOD_CACHE = Collections.synchronizedMap(new HashMap());

    public static Method findMethod(String classname, String methodName, MethodDescriptor descriptor) {
        Method method;
        String targetClass = classname.replace('/', '.');
        String methodSignature = ClasspathHelper.buildMethodSignature(targetClass + "." + methodName, descriptor);
        if (METHOD_CACHE.containsKey(methodSignature)) {
            method = METHOD_CACHE.get(methodSignature);
        } else {
            method = ClasspathHelper.findMethodOnClasspath(targetClass, methodSignature);
            METHOD_CACHE.put(methodSignature, method);
        }
        return method;
    }

    private static Method findMethodOnClasspath(String targetClass, String methodSignature) {
        try {
            Class<?> cls = new ClassLoader(null){}.loadClass(targetClass);
            for (Method mtd : cls.getMethods()) {
                if (!mtd.toString().contains(methodSignature)) continue;
                return mtd;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static String buildMethodSignature(String name, MethodDescriptor md) {
        StringBuilder sb = new StringBuilder();
        ClasspathHelper.appendType(sb, md.ret);
        sb.append(' ').append(name).append('(');
        for (VarType param : md.params) {
            ClasspathHelper.appendType(sb, param);
            sb.append(',');
        }
        if (sb.charAt(sb.length() - 1) == ',') {
            sb.setLength(sb.length() - 1);
        }
        sb.append(')');
        return sb.toString();
    }

    private static void appendType(StringBuilder sb, VarType type) {
        sb.append(type.value.replace('/', '.'));
        for (int i = 0; i < type.arrayDim; ++i) {
            sb.append("[]");
        }
    }
}

