/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import javax.annotation.Nonnull;
import org.fest.reflect.beanproperty.PropertyType;
import org.fest.reflect.beanproperty.PropertyTypeRef;
import org.fest.reflect.reference.TypeRef;
import org.fest.util.InternalApi;
import org.fest.util.Preconditions;

public final class PropertyName {
    private final String name;

    @InternalApi
    public PropertyName(@Nonnull String name) {
        this.name = Preconditions.checkNotNullOrEmpty((String)name);
    }

    @Nonnull
    public <T> PropertyType<T> ofType(@Nonnull Class<T> type) {
        return new PropertyType<T>(this.name, type);
    }

    @Nonnull
    public <T> PropertyTypeRef<T> ofType(@Nonnull TypeRef<T> type) {
        return new PropertyTypeRef<T>(this.name, type);
    }
}

