/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.method;

import javax.annotation.Nonnull;
import org.fest.reflect.method.MethodInvoker;
import org.fest.reflect.method.ParameterTypes;
import org.fest.util.Preconditions;

public class ReturnType<T> {
    private final String methodName;
    private final Class<T> value;

    ReturnType(@Nonnull String methodName, @Nonnull Class<T> returnType) {
        this.methodName = (String)Preconditions.checkNotNull((Object)methodName);
        this.value = (Class)Preconditions.checkNotNull(returnType);
    }

    @Nonnull
    public ParameterTypes<T> withParameterTypes(Class<?> ... parameterTypes) {
        return new ParameterTypes(Preconditions.checkNotNullOrEmpty((String)this.methodName), (Class)Preconditions.checkNotNull(this.value), parameterTypes);
    }

    @Nonnull
    public MethodInvoker<T> in(@Nonnull Object target) {
        return new MethodInvoker<T>(this.methodName, this.value, new Class[0], target);
    }
}

