/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.credentialStore.CredentialAttributesKt;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.awt.Component;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.authentication.GHAccountAuthData;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.GithubAuthenticationManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountManager;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelper$WhenMappings;
import org.jetbrains.plugins.github.util.GithubAccountsMigrationHelperKt;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.MigrationResult;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 %2\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000f\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0000\u00a2\u0006\u0002\b\u0016J\u001c\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0007J&\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\bH\u0002J&\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010\bH\u0002J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\bH\u0002J.\u0010\"\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\u00020\b*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00020\f*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u000eR\u0018\u0010\u0011\u001a\u00020\u0012*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006&"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "", "()V", "settings", "Lorg/jetbrains/plugins/github/util/GithubSettings;", "getSettings", "()Lorg/jetbrains/plugins/github/util/GithubSettings;", "authDetails", "", "getAuthDetails", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)Ljava/lang/String;", "hasAuthDetails", "", "getHasAuthDetails", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)Z", "hasOldAccount", "getHasOldAccount", "oldHost", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getOldHost", "(Lorg/jetbrains/plugins/github/util/GithubSettings;)Lorg/jetbrains/plugins/github/api/GithubServerPath;", "getOldServer", "getOldServer$intellij_vcs_github", "migrate", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "migrateBasicAuth", "Lorg/jetbrains/plugins/github/util/MigrationResult;", "password", "migrateTokenAuth", "token", "migrateWithExistingToken", "migrateWithNewToken", "error", "", "Companion", "intellij.vcs.github"})
public final class GithubAccountsMigrationHelper {
    public static final Companion Companion = new Companion(null);

    private final GithubSettings getSettings() {
        GithubSettings githubSettings = GithubSettings.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)githubSettings, (String)"GithubSettings.getInstance()");
        return githubSettings;
    }

    @Nullable
    public final GithubServerPath getOldServer$intellij_vcs_github() {
        GithubServerPath githubServerPath;
        if (this.getHasOldAccount(this.getSettings())) {
            Object object;
            GithubAccountsMigrationHelper githubAccountsMigrationHelper = this;
            boolean bl = false;
            try {
                object = Result.Companion;
                GithubAccountsMigrationHelper $this$runCatching = githubAccountsMigrationHelper;
                boolean bl2 = false;
                GithubServerPath githubServerPath2 = $this$runCatching.getOldHost($this$runCatching.getSettings());
                boolean bl3 = false;
                object = Result.constructor-impl((Object)githubServerPath2);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            githubAccountsMigrationHelper = object;
            bl = false;
            githubServerPath = (GithubServerPath)((Object)(Result.isFailure-impl((Object)githubAccountsMigrationHelper) ? null : githubAccountsMigrationHelper));
        } else {
            githubServerPath = null;
        }
        return githubServerPath;
    }

    private final boolean getHasOldAccount(GithubSettings $this$hasOldAccount) {
        return $this$hasOldAccount.getAuthType() == GithubAuthData.AuthType.BASIC && $this$hasOldAccount.getLogin() != null || $this$hasOldAccount.getAuthType() == GithubAuthData.AuthType.TOKEN;
    }

    private final GithubServerPath getOldHost(GithubSettings $this$oldHost) {
        Object object;
        block3: {
            block2: {
                object = $this$oldHost.getHost();
                if (object == null) break block2;
                String string = object;
                boolean bl = false;
                boolean bl2 = false;
                String it = string;
                boolean bl3 = false;
                object = GithubServerPath.from(it);
                if (object != null) break block3;
            }
            GithubServerPath githubServerPath = GithubServerPath.DEFAULT_SERVER;
            object = githubServerPath;
            Intrinsics.checkNotNullExpressionValue((Object)githubServerPath, (String)"GithubServerPath.DEFAULT_SERVER");
        }
        return object;
    }

    private final boolean getHasAuthDetails(GithubSettings $this$hasAuthDetails) {
        return $this$hasAuthDetails.getLogin() != null || $this$hasAuthDetails.getHost() != null || $this$hasAuthDetails.getAuthType() != null;
    }

    private final String getAuthDetails(GithubSettings $this$authDetails) {
        return "login: " + $this$authDetails.getLogin() + ", host: " + $this$authDetails.getHost() + ", authType: " + (Object)((Object)$this$authDetails.getAuthType());
    }

    /*
     * Unable to fully structure code
     */
    @RequiresEdt
    @JvmOverloads
    public final boolean migrate(@NotNull Project project, @Nullable Component parentComponent) {
        block6: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            GithubAccountsMigrationHelperKt.access$getLOG$p().debug("Migrating old auth");
            password = PasswordSafe.Companion.getInstance().getPassword(CredentialAttributesKt.CredentialAttributes(GithubSettings.class, (String)"GITHUB_SETTINGS_PASSWORD_KEY"));
            GithubAccountsMigrationHelperKt.access$getLOG$p().debug("Old auth data: { " + this.getAuthDetails(this.getSettings()) + ", password null: " + (password == null) + " }");
            if (!this.getHasAuthDetails(this.getSettings()) && password == null) {
                return true;
            }
            $i$f$service = false;
            v0 = ApplicationManager.getApplication().getService(GithubAccountManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            $i$f$service = ((GithubAccountManager)v0).getAccounts();
            var5_6 = false;
            if ($i$f$service.isEmpty() == false) {
                return true;
            }
            v1 = this.getSettings().getAuthType();
            if (v1 == null) ** GOTO lbl-1000
            switch (GithubAccountsMigrationHelper$WhenMappings.$EnumSwitchMapping$0[v1.ordinal()]) {
                case 1: {
                    v2 = this.migrateTokenAuth(project, parentComponent, password);
                    break;
                }
                case 2: {
                    v2 = this.migrateBasicAuth(project, parentComponent, password);
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    v2 = GithubAccountsMigrationHelperKt.access$getNO_ACCOUNT_MIGRATED$p();
                }
            }
            v3 = migrationResult = v2;
            if (v3 == null) break block6;
            GithubAccountsMigrationHelperKt.access$registerAccount(v3);
        }
        return migrationResult != null;
    }

    public static /* synthetic */ boolean migrate$default(GithubAccountsMigrationHelper githubAccountsMigrationHelper, Project project, Component component, int n, Object object) {
        if ((n & 2) != 0) {
            component = null;
        }
        return githubAccountsMigrationHelper.migrate(project, component);
    }

    @RequiresEdt
    @JvmOverloads
    public final boolean migrate(@NotNull Project project) {
        return GithubAccountsMigrationHelper.migrate$default(this, project, null, 2, null);
    }

    private final MigrationResult migrateTokenAuth(Project project, Component parentComponent, String token) {
        Object object;
        boolean bl;
        MigrationResult migrationResult;
        Object object2;
        GithubAccountsMigrationHelperKt.access$getLOG$p().debug("Migrating token auth");
        if (token == null) {
            return GithubAccountsMigrationHelperKt.access$getNO_ACCOUNT_MIGRATED$p();
        }
        GithubAccountsMigrationHelper githubAccountsMigrationHelper = this;
        boolean bl2 = false;
        try {
            object2 = Result.Companion;
            GithubAccountsMigrationHelper $this$runCatching = githubAccountsMigrationHelper;
            boolean bl3 = false;
            migrationResult = $this$runCatching.migrateWithExistingToken(project, token);
            bl3 = false;
            object2 = Result.constructor-impl((Object)migrationResult);
        }
        catch (Throwable throwable) {
            Result.Companion bl3 = Result.Companion;
            bl = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        githubAccountsMigrationHelper = object2;
        bl2 = false;
        boolean bl4 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)githubAccountsMigrationHelper);
        if (throwable == null) {
            object = githubAccountsMigrationHelper;
        } else {
            migrationResult = Result.Companion;
            Throwable it = throwable;
            boolean bl5 = false;
            MigrationResult migrationResult2 = this.migrateWithNewToken(project, parentComponent, token, it);
            bl = false;
            object = Result.constructor-impl((Object)migrationResult2);
        }
        githubAccountsMigrationHelper = object;
        bl2 = false;
        return (MigrationResult)((Object)(Result.isFailure-impl((Object)githubAccountsMigrationHelper) ? null : githubAccountsMigrationHelper));
    }

    private final MigrationResult migrateWithExistingToken(Project project, String token) {
        GithubAuthenticatedUser accountDetails2;
        GithubServerPath server = this.getOldHost(this.getSettings());
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"ProgressManager.getInstance()");
        ProgressManager progressManager2 = progressManager;
        GithubAuthenticatedUser githubAuthenticatedUser = accountDetails2 = (GithubAuthenticatedUser)progressManager2.runProcessWithProgressSynchronously((ThrowableComputable)new ThrowableComputable<GithubAuthenticatedUser, IOException>(token, progressManager2, server){
            final /* synthetic */ String $token;
            final /* synthetic */ ProgressManager $progressManager;
            final /* synthetic */ GithubServerPath $server;

            public final GithubAuthenticatedUser compute() {
                GithubApiRequestExecutor.WithTokenAuth withTokenAuth = GithubApiRequestExecutor.Factory.Companion.getInstance().create(this.$token);
                ProgressIndicator progressIndicator = this.$progressManager.getProgressIndicator();
                Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"progressManager.progressIndicator");
                return withTokenAuth.execute(progressIndicator, GithubApiRequests.CurrentUser.get(this.$server));
            }
            {
                this.$token = string;
                this.$progressManager = progressManager;
                this.$server = githubServerPath;
            }
        }, GithubBundle.message("accessing.github", new Object[0]), true, project);
        Intrinsics.checkNotNullExpressionValue((Object)githubAuthenticatedUser, (String)"accountDetails");
        String string = githubAuthenticatedUser.getLogin();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"accountDetails.login");
        return new MigrationResult(GithubAccountManager.Companion.createAccount(string, server), token);
    }

    private final MigrationResult migrateWithNewToken(Project project, Component parentComponent, String token, Throwable error) {
        GithubAccountsMigrationHelperKt.access$getLOG$p().debug("Failed to migrate old token-based auth. Showing dialog.", error);
        GHAccountAuthData gHAccountAuthData = GithubAuthenticationManager.Companion.getInstance().login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(null, error, this.getOldHost(this.getSettings()), false, null, false, false, null, token, 249, null));
        return gHAccountAuthData != null ? GithubAccountsMigrationHelperKt.access$getMigrationResult(gHAccountAuthData) : null;
    }

    private final MigrationResult migrateBasicAuth(Project project, Component parentComponent, String password) {
        GithubAccountsMigrationHelperKt.access$getLOG$p().debug("Migrating basic auth");
        GHAccountAuthData gHAccountAuthData = GithubAuthenticationManager.Companion.getInstance().login$intellij_vcs_github(project, parentComponent, new GHLoginRequest(GithubBundle.message("accounts.password.auth.not.supported", new Object[0]), null, this.getOldHost(this.getSettings()), false, this.getSettings().getLogin(), false, false, password, null, 362, null));
        return gHAccountAuthData != null ? GithubAccountsMigrationHelperKt.access$getMigrationResult(gHAccountAuthData) : null;
    }

    @JvmStatic
    @NotNull
    public static final GithubAccountsMigrationHelper getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper$Companion;", "", "()V", "getInstance", "Lorg/jetbrains/plugins/github/util/GithubAccountsMigrationHelper;", "intellij.vcs.github"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final GithubAccountsMigrationHelper getInstance() {
            boolean $i$f$service = false;
            Object object = ApplicationManager.getApplication().getService(GithubAccountsMigrationHelper.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026getService(T::class.java)");
            return (GithubAccountsMigrationHelper)object;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

