/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uiDesigner.editor;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.FileEditorStateLevel;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.uiDesigner.FormEditingUtil;
import com.intellij.uiDesigner.FormHighlightingPass;
import com.intellij.uiDesigner.GuiFormFileType;
import com.intellij.uiDesigner.UIDesignerBundle;
import com.intellij.uiDesigner.designSurface.GuiEditor;
import com.intellij.uiDesigner.editor.MyEditorState;
import com.intellij.uiDesigner.radComponents.RadComponent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public final class UIFormEditor
extends UserDataHolderBase
implements FileEditor,
PossiblyDumbAware {
    private final VirtualFile myFile;
    private final GuiEditor myEditor;
    private MyBackgroundEditorHighlighter myBackgroundEditorHighlighter;

    public UIFormEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            UIFormEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            UIFormEditor.$$$reportNull$$$0(1);
        }
        VirtualFile vf = file instanceof LightVirtualFile ? ((LightVirtualFile)file).getOriginalFile() : file;
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)vf, (Project)project);
        if (module == null) {
            throw new IllegalArgumentException("No module for file " + file + " in project " + project);
        }
        this.myFile = file;
        this.myEditor = new GuiEditor(this, project, module, file);
    }

    @NotNull
    public JComponent getComponent() {
        GuiEditor guiEditor = this.myEditor;
        if (guiEditor == null) {
            UIFormEditor.$$$reportNull$$$0(2);
        }
        return guiEditor;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myEditor);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myEditor.getPreferredFocusedComponent();
    }

    @NotNull
    public String getName() {
        String string = UIDesignerBundle.message("title.gui.designer", new Object[0]);
        if (string == null) {
            UIFormEditor.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public GuiEditor getEditor() {
        GuiEditor guiEditor = this.myEditor;
        if (guiEditor == null) {
            UIFormEditor.$$$reportNull$$$0(4);
        }
        return guiEditor;
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return FileDocumentManager.getInstance().getDocument(this.myFile) != null && FileTypeRegistry.getInstance().isFileOfType(this.myFile, (FileType)GuiFormFileType.INSTANCE);
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UIFormEditor.$$$reportNull$$$0(5);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        if (listener == null) {
            UIFormEditor.$$$reportNull$$$0(6);
        }
    }

    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundEditorHighlighter == null) {
            this.myBackgroundEditorHighlighter = new MyBackgroundEditorHighlighter(this.myEditor);
        }
        return this.myBackgroundEditorHighlighter;
    }

    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @NotNull
    public FileEditorState getState(@NotNull FileEditorStateLevel ignored) {
        Document document;
        if (ignored == null) {
            UIFormEditor.$$$reportNull$$$0(7);
        }
        long modificationStamp = (document = FileDocumentManager.getInstance().getCachedDocument(this.myFile)) != null ? document.getModificationStamp() : this.myFile.getModificationStamp();
        ArrayList<RadComponent> selection = FormEditingUtil.getSelectedComponents(this.myEditor);
        String[] ids = new String[selection.size()];
        for (int i = ids.length - 1; i >= 0; --i) {
            ids[i] = selection.get(i).getId();
        }
        return new MyEditorState(modificationStamp, ids);
    }

    public void setState(@NotNull FileEditorState state) {
        String[] ids;
        if (state == null) {
            UIFormEditor.$$$reportNull$$$0(8);
        }
        FormEditingUtil.clearSelection(this.myEditor.getRootContainer());
        for (String id : ids = ((MyEditorState)state).getSelectedComponentIds()) {
            RadComponent component = (RadComponent)FormEditingUtil.findComponent(this.myEditor.getRootContainer(), id);
            if (component == null) continue;
            component.setSelected(true);
        }
    }

    public void selectComponent(@NotNull String binding) {
        RadComponent component;
        if (binding == null) {
            UIFormEditor.$$$reportNull$$$0(9);
        }
        if ((component = (RadComponent)FormEditingUtil.findComponentWithBinding(this.myEditor.getRootContainer(), binding)) != null) {
            FormEditingUtil.selectSingleComponent(this.getEditor(), component);
        }
    }

    public void selectComponentById(@NotNull String id) {
        RadComponent component;
        if (id == null) {
            UIFormEditor.$$$reportNull$$$0(10);
        }
        if ((component = (RadComponent)FormEditingUtil.findComponent(this.myEditor.getRootContainer(), id)) != null) {
            FormEditingUtil.selectSingleComponent(this.getEditor(), component);
        }
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    public boolean isDumbAware() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/uiDesigner/editor/UIFormEditor";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/uiDesigner/editor/UIFormEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "selectComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectComponentById";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyBackgroundEditorHighlighter
    implements BackgroundEditorHighlighter {
        private final HighlightingPass[] myPasses;

        MyBackgroundEditorHighlighter(GuiEditor editor) {
            this.myPasses = new HighlightingPass[]{new FormHighlightingPass(editor)};
        }

        public HighlightingPass @NotNull [] createPassesForEditor() {
            if (this.myPasses == null) {
                MyBackgroundEditorHighlighter.$$$reportNull$$$0(0);
            }
            return this.myPasses;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/uiDesigner/editor/UIFormEditor$MyBackgroundEditorHighlighter", "createPassesForEditor"));
        }
    }
}

