/*
 * Decompiled with CFR 0.152.
 */
package org.fest.util;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.util.Arrays;
import org.fest.util.Preconditions;

public final class Strings {
    private Strings() {
    }

    public static boolean isNullOrEmpty(@Nullable String s) {
        return s == null || s.length() == 0;
    }

    @Nullable
    public static String quote(@Nullable String s) {
        return s != null ? String.format("'%s'", s) : null;
    }

    @Nullable
    public static Object quote(@Nullable Object o) {
        return o instanceof String ? Strings.quote(o.toString()) : o;
    }

    @Nonnull
    public static String concat(Object ... objects) {
        Preconditions.checkNotNull(objects);
        StringBuilder b = new StringBuilder();
        for (Object o : objects) {
            b.append(o);
        }
        return b.toString();
    }

    @Nonnull
    public static StringsToJoin join(String ... strings) {
        return new StringsToJoin(strings);
    }

    @Nonnull
    public static StringToAppend append(@Nonnull String toAppend) {
        return new StringToAppend(toAppend);
    }

    public static class StringToAppend {
        private final String toAppend;

        StringToAppend(@Nonnull String toAppend) {
            this.toAppend = toAppend;
        }

        @Nonnull
        public String to(@Nonnull String s) {
            if (!s.endsWith(this.toAppend)) {
                return Strings.concat(s, this.toAppend);
            }
            return s;
        }
    }

    public static class StringsToJoin {
        private final String[] strings;

        StringsToJoin(String ... strings) {
            this.strings = strings;
        }

        @Nonnull
        public String with(@Nonnull String delimeter) {
            Preconditions.checkNotNull(delimeter);
            if (Arrays.isNullOrEmpty(this.strings)) {
                return "";
            }
            StringBuilder b = new StringBuilder();
            int stringCount = this.strings.length;
            for (int i = 0; i < stringCount; ++i) {
                String s = this.strings[i];
                b.append(s != null ? s : "");
                if (i >= stringCount - 1) continue;
                b.append(delimeter);
            }
            return b.toString();
        }
    }
}

