/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.filePrediction;

import com.intellij.filePrediction.FilePredictionSession;
import com.intellij.filePrediction.FilePredictionSessionHistory;
import com.intellij.filePrediction.FileReferencesComputationResult;
import com.intellij.filePrediction.logger.FileUsagePredictionLogger;
import com.intellij.filePrediction.predictor.FilePredictionCandidate;
import com.intellij.filePrediction.predictor.FilePredictionCompressedCandidate;
import com.intellij.filePrediction.predictor.FilePredictionCompressedCandidatesHolder;
import com.intellij.filePrediction.predictor.FileUsagePredictor;
import com.intellij.filePrediction.predictor.FileUsagePredictorProvider;
import com.intellij.filePrediction.references.FilePredictionReferencesHelper;
import com.intellij.ide.PowerSaveMode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0015J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/filePrediction/FilePredictionSessionManager;", "", "candidatesLimit", "", "logTopLimit", "logTotalLimit", "threshold", "", "(IIID)V", "logger", "Lcom/intellij/filePrediction/logger/FileUsagePredictionLogger;", "predictor", "Lcom/intellij/filePrediction/predictor/FileUsagePredictor;", "session", "Lcom/intellij/filePrediction/FilePredictionSession;", "logSessionFinished", "", "project", "Lcom/intellij/openapi/project/Project;", "currentSession", "openedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "onSessionStarted", "file", "startSession", "intellij.filePrediction"})
public final class FilePredictionSessionManager {
    private final FileUsagePredictor predictor;
    private final FileUsagePredictionLogger logger;
    private FilePredictionSession session;
    private final int candidatesLimit;
    private final int logTotalLimit;
    private final double threshold;

    public final synchronized void onSessionStarted(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePredictionSession filePredictionSession = this.session;
        if (filePredictionSession != null) {
            FilePredictionSession filePredictionSession2 = filePredictionSession;
            boolean bl = false;
            boolean bl2 = false;
            FilePredictionSession it = filePredictionSession2;
            boolean bl3 = false;
            if (it.getShouldLog()) {
                this.logSessionFinished(project, it, file);
            }
        }
        this.startSession(project, file);
    }

    private final void startSession(Project project, VirtualFile file) {
        FilePredictionSession newSession = new FilePredictionSession(!PowerSaveMode.isEnabled(), this.threshold);
        if (newSession.getShouldLog()) {
            long start = System.currentTimeMillis();
            FileReferencesComputationResult refs = FilePredictionReferencesHelper.INSTANCE.calculateExternalReferences(project, file);
            int candidatesToCalculate = !this.predictor.isDummy() ? this.candidatesLimit : this.logTotalLimit;
            List<FilePredictionCandidate> candidates = this.predictor.predictNextFile$intellij_filePrediction(project, file, refs, candidatesToCalculate);
            FilePredictionCompressedCandidatesHolder holder = FilePredictionCompressedCandidatesHolder.Companion.create(candidates);
            long totalDuration = System.currentTimeMillis() - start;
            newSession.candidatesCalculated(holder, totalDuration, refs.getDuration());
        }
        this.session = newSession;
    }

    /*
     * WARNING - void declaration
     */
    private final void logSessionFinished(Project project, FilePredictionSession currentSession, VirtualFile openedFile) {
        Object object = currentSession.getCandidatesHolder();
        if (object == null || (object = object.getCandidates()) == null) {
            object = CollectionsKt.emptyList();
        }
        Object candidates = object;
        Collection collection = (Collection)candidates;
        boolean bl = false;
        if (!collection.isEmpty()) {
            void $this$filterTo$iv$iv;
            int sessionId = currentSession.getId();
            long refsDuration = currentSession.getRefsDuration();
            long totalDuration = currentSession.getTotalDuration();
            FilePredictionCompressedCandidate opened = currentSession.findOpenedCandidate(openedFile, (List<FilePredictionCompressedCandidate>)candidates);
            Iterable $this$filter$iv = (Iterable)candidates;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                FilePredictionCompressedCandidate it = (FilePredictionCompressedCandidate)element$iv$iv;
                boolean bl2 = false;
                if (!(Intrinsics.areEqual((Object)it, (Object)opened) ^ true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List notOpened = (List)destination$iv$iv;
            FilePredictionSessionHistory.Companion.getInstance(project).onCandidatesCalculated(notOpened);
            this.logger.logCandidates(project, sessionId, opened, notOpened, totalDuration, refsDuration);
        }
    }

    public FilePredictionSessionManager(int candidatesLimit, int logTopLimit, int logTotalLimit, double threshold) {
        this.candidatesLimit = candidatesLimit;
        this.logTotalLimit = logTotalLimit;
        this.threshold = threshold;
        this.predictor = FileUsagePredictorProvider.getFileUsagePredictor$default(FileUsagePredictorProvider.INSTANCE, null, 1, null);
        this.logger = new FileUsagePredictionLogger(logTopLimit, this.logTotalLimit);
    }
}

