/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.en;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.UserConfig;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.rules.Example;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.SuggestedReplacement;
import org.languagetool.rules.en.VariantInfo;
import org.languagetool.rules.en.translation.BeoLingusTranslator;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;
import org.languagetool.rules.translation.Translator;
import org.languagetool.tools.StringTools;

public abstract class AbstractEnglishSpellerRule
extends MorfologikSpellerRule {
    private final BeoLingusTranslator translator;
    protected final Map<String, List<String>> topSuggestions;
    protected final Map<String, List<String>> topSuggestionsIgnoreCase;

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language) throws IOException {
        this(messages, language, null, Collections.emptyList());
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, UserConfig userConfig, List<Language> altLanguages) throws IOException {
        this(messages, language, null, userConfig, altLanguages, null, null);
    }

    protected static Map<String, String> loadWordlist(String path, int column) {
        if (column != 0 && column != 1) {
            throw new IllegalArgumentException("Only column 0 and 1 are supported: " + column);
        }
        HashMap<String, String> words = new HashMap<String, String>();
        List lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String line : lines) {
            if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
            String[] parts = line.split(";");
            if (parts.length != 2) {
                throw new RuntimeException("Unexpected format in " + path + ": " + line + " - expected two parts delimited by ';'");
            }
            words.put(parts[column].toLowerCase(), parts[column == 1 ? 0 : 1]);
        }
        return words;
    }

    public AbstractEnglishSpellerRule(ResourceBundle messages, Language language, GlobalConfig globalConfig, UserConfig userConfig, List<Language> altLanguages, LanguageModel languageModel, Language motherTongue) throws IOException {
        super(messages, language, globalConfig, userConfig, altLanguages, languageModel, motherTongue);
        this.ignoreWordsWithLength = 1;
        this.setCheckCompound(true);
        this.addExamplePair(Example.wrong((String)"This <marker>sentenc</marker> contains a spelling mistake."), Example.fixed((String)"This <marker>sentence</marker> contains a spelling mistake."));
        String languageSpecificIgnoreFile = this.getSpellingFileName().replace(".txt", "_" + language.getShortCodeWithCountryAndVariant() + ".txt");
        for (String ignoreWord : this.wordListLoader.loadWords(languageSpecificIgnoreFile)) {
            this.addIgnoreWords(ignoreWord);
        }
        this.translator = BeoLingusTranslator.getInstance(globalConfig);
        this.topSuggestions = this.getTopSuggestions();
        this.topSuggestionsIgnoreCase = this.getTopSuggestionsIgnoreCase();
    }

    protected List<SuggestedReplacement> filterSuggestions(List<SuggestedReplacement> suggestions, AnalyzedSentence sentence, int i) {
        List result = super.filterSuggestions(suggestions, sentence, i);
        ArrayList<SuggestedReplacement> clean = new ArrayList<SuggestedReplacement>();
        for (SuggestedReplacement suggestion : result) {
            if (suggestion.getReplacement().matches(".* (b|c|d|e|f|g|h|j|k|l|m|n|o|p|q|r|s|t|v|w|y|z|ll|ve)")) continue;
            clean.add(suggestion);
        }
        return clean;
    }

    protected List<RuleMatch> getRuleMatches(String word, int startPos, AnalyzedSentence sentence, List<RuleMatch> ruleMatchesSoFar, int idx, AnalyzedTokenReadings[] tokens) throws IOException {
        List ruleMatches = super.getRuleMatches(word, startPos, sentence, ruleMatchesSoFar, idx, tokens);
        if (ruleMatches.size() > 0) {
            IrregularForms forms = this.getIrregularFormsOrNull(word);
            if (forms != null) {
                String message = "Possible spelling mistake. Did you mean <suggestion>" + forms.forms.get(0) + "</suggestion>, the " + forms.formName + " form of the " + forms.posName + " '" + forms.baseform + "'?";
                this.addFormsToFirstMatch(message, sentence, ruleMatches, forms.forms);
            } else {
                VariantInfo variantInfo = this.isValidInOtherVariant(word);
                if (variantInfo != null) {
                    String message = "Possible spelling mistake. '" + word + "' is " + variantInfo.getVariantName() + ".";
                    String suggestion = StringTools.startsWithUppercase((String)word) ? StringTools.uppercaseFirstChar((String)variantInfo.otherVariant()) : variantInfo.otherVariant();
                    this.replaceFormsOfFirstMatch(message, sentence, ruleMatches, suggestion);
                }
            }
        }
        for (RuleMatch ruleMatch : ruleMatches) {
            List cleaned = ruleMatch.getSuggestedReplacementObjects().stream().filter(k -> !k.getReplacement().startsWith("re ") && !k.getReplacement().startsWith("en ") && !k.getReplacement().startsWith("pre ") && !k.getReplacement().startsWith("inter ") && !k.getReplacement().startsWith("sub ") && !k.getReplacement().startsWith("auto ") && !k.getReplacement().startsWith("dis ") && !k.getReplacement().endsWith(" able") && !k.getReplacement().endsWith(" OO") && !k.getReplacement().endsWith(" HHH") && !k.getReplacement().endsWith(" ally") && !k.getReplacement().endsWith(" ize") && !k.getReplacement().endsWith(" en") && !k.getReplacement().endsWith(" ed")).collect(Collectors.toList());
            ruleMatch.setSuggestedReplacementObjects(cleaned);
        }
        return ruleMatches;
    }

    @Nullable
    protected VariantInfo isValidInOtherVariant(String word) {
        return null;
    }

    private void addFormsToFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, List<String> forms) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        ArrayList<String> allSuggestions = new ArrayList<String>(forms);
        for (String repl : oldMatch.getSuggestedReplacements()) {
            if (allSuggestions.contains(repl)) continue;
            allSuggestions.add(repl);
        }
        newMatch.setSuggestedReplacements(allSuggestions);
        ruleMatches.set(0, newMatch);
    }

    private void replaceFormsOfFirstMatch(String message, AnalyzedSentence sentence, List<RuleMatch> ruleMatches, String suggestion) {
        RuleMatch oldMatch = ruleMatches.get(0);
        RuleMatch newMatch = new RuleMatch((Rule)this, sentence, oldMatch.getFromPos(), oldMatch.getToPos(), message);
        SuggestedReplacement sugg = new SuggestedReplacement(suggestion);
        sugg.setShortDescription(this.language.getName());
        newMatch.setSuggestedReplacementObjects(Collections.singletonList(sugg));
        ruleMatches.set(0, newMatch);
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word) {
        IrregularForms irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("ed"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "ed", Arrays.asList("d"), "VBD", "verb", "past tense");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "s", Arrays.asList("s"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "es", Arrays.asList("es"), "NNS", "noun", "plural");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "er", Arrays.asList("er"), "JJR", "adjective", "comparative");
        if (irregularFormsOrNull != null) {
            return irregularFormsOrNull;
        }
        irregularFormsOrNull = this.getIrregularFormsOrNull(word, "est", Arrays.asList("est"), "JJS", "adjective", "superlative");
        return irregularFormsOrNull;
    }

    @Nullable
    private IrregularForms getIrregularFormsOrNull(String word, String wordSuffix, List<String> suffixes, String posTag, String posName, String formName) {
        try {
            for (String suffix : suffixes) {
                if (!word.endsWith(wordSuffix)) continue;
                String baseForm = word.substring(0, word.length() - suffix.length());
                String[] forms = Objects.requireNonNull(this.language.getSynthesizer()).synthesize(new AnalyzedToken(word, null, baseForm), posTag);
                ArrayList<String> result = new ArrayList<String>();
                for (String form : forms) {
                    if (this.speller1.isMisspelled(form)) continue;
                    result.add(form);
                }
                result.remove(word);
                result.remove("badder");
                result.remove("baddest");
                result.remove("spake");
                if (result.size() <= 0) continue;
                return new IrregularForms(baseForm, posName, formName, result);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, List<String>> getTopSuggestionsIgnoreCase() {
        HashMap<String, List<String>> s = new HashMap<String, List<String>>();
        s.put("xml", Arrays.asList("XML"));
        s.put("php", Arrays.asList("PHP"));
        s.put("asp", Arrays.asList("ASP"));
        s.put("rss", Arrays.asList("RSS"));
        s.put("ssd", Arrays.asList("SSD"));
        s.put("ssds", Arrays.asList("SSDs"));
        s.put("hdds", Arrays.asList("HDDs"));
        s.put("isp", Arrays.asList("ISP"));
        s.put("isps", Arrays.asList("ISPs"));
        s.put("suv", Arrays.asList("SUV"));
        s.put("suvs", Arrays.asList("SUVs"));
        s.put("gif", Arrays.asList("GIF"));
        s.put("gifs", Arrays.asList("GIFs"));
        s.put("atm", Arrays.asList("ATM"));
        s.put("atms", Arrays.asList("ATMs"));
        s.put("png", Arrays.asList("PNG"));
        s.put("pngs", Arrays.asList("PNGs"));
        s.put("csv", Arrays.asList("CSV"));
        s.put("csvs", Arrays.asList("CSVs"));
        s.put("pdf", Arrays.asList("PDF"));
        s.put("pdfs", Arrays.asList("PDFs"));
        s.put("jpeg", Arrays.asList("JPEG"));
        s.put("jpegs", Arrays.asList("JPEGs"));
        s.put("jpg", Arrays.asList("JPG"));
        s.put("jpgs", Arrays.asList("JPGs"));
        s.put("bmp", Arrays.asList("BMP"));
        s.put("bmps", Arrays.asList("BMPs"));
        s.put("docx", Arrays.asList("DOCX"));
        s.put("xlsx", Arrays.asList("XLSX"));
        s.put("btw", Arrays.asList("BTW"));
        s.put("idk", Arrays.asList("IDK"));
        s.put("ai", Arrays.asList("AI"));
        s.put("ip", Arrays.asList("IP"));
        s.put("rfc", Arrays.asList("RFC"));
        s.put("ppt", Arrays.asList("PPT"));
        s.put("ppts", Arrays.asList("PPTs"));
        s.put("pptx", Arrays.asList("PPTX"));
        s.put("vpn", Arrays.asList("VPN"));
        s.put("psn", Arrays.asList("PSN"));
        s.put("usd", Arrays.asList("USD"));
        s.put("tv", Arrays.asList("TV"));
        s.put("eur", Arrays.asList("EUR"));
        s.put("tbh", Arrays.asList("TBH"));
        s.put("tbd", Arrays.asList("TBD"));
        s.put("tba", Arrays.asList("TBA"));
        s.put("omg", Arrays.asList("OMG"));
        s.put("lol", Arrays.asList("LOL"));
        s.put("lmao", Arrays.asList("LMAO"));
        s.put("wtf", Arrays.asList("WTF"));
        s.put("fyi", Arrays.asList("FYI"));
        s.put("url", Arrays.asList("URL"));
        s.put("urls", Arrays.asList("URLs"));
        s.put("usb", Arrays.asList("USB"));
        s.put("bbq", Arrays.asList("BBQ"));
        s.put("bbqs", Arrays.asList("BBQs"));
        s.put("ngo", Arrays.asList("NGO"));
        s.put("ngos", Arrays.asList("NGOs"));
        s.put("js", Arrays.asList("JS"));
        s.put("css", Arrays.asList("CSS"));
        s.put("roi", Arrays.asList("ROI"));
        s.put("pov", Arrays.asList("POV"));
        s.put("ctrl", Arrays.asList("Ctrl"));
        s.put("vip", Arrays.asList("VIP"));
        s.put("vips", Arrays.asList("VIPs"));
        s.put("leds", Arrays.asList("LEDs"));
        s.put("hugo", Arrays.asList("Hugo"));
        s.put("lola", Arrays.asList("Lola"));
        s.put("imho", Arrays.asList("IMHO"));
        s.put("imo", Arrays.asList("IMO"));
        s.put("lte", Arrays.asList("LTE"));
        s.put("dc", Arrays.asList("DC"));
        s.put("ac", Arrays.asList("AC"));
        s.put("cdn", Arrays.asList("CDN"));
        s.put("italia", Arrays.asList("Italy"));
        s.put("macboook", Arrays.asList("MacBook"));
        s.put("macboooks", Arrays.asList("MacBooks"));
        s.put("paypal", Arrays.asList("PayPal"));
        s.put("copenhague", Arrays.asList("Copenhagen"));
        s.put("youtube", Arrays.asList("YouTube"));
        s.put("whatsapp", Arrays.asList("WhatsApp"));
        s.put("webex", Arrays.asList("WebEx"));
        s.put("jira", Arrays.asList("Jira"));
        s.put("applepay", Arrays.asList("Apple Pay"));
        s.put("&&", Arrays.asList("&"));
        s.put("wensday", Arrays.asList("Wednesday"));
        s.put("linkedin", Arrays.asList("LinkedIn"));
        s.put("ebay", Arrays.asList("eBay"));
        s.put("admob", Arrays.asList("AdMob"));
        s.put("interweb", Arrays.asList("internet"));
        s.put("interwebs", Arrays.asList("internet"));
        s.put("afro-american", Arrays.asList("Afro-American"));
        s.put("oconnor", Arrays.asList("O'Connor"));
        s.put("oconor", Arrays.asList("O'Conor"));
        s.put("obrien", Arrays.asList("O'Brien"));
        s.put("odonnell", Arrays.asList("O'Donnell"));
        s.put("oneill", Arrays.asList("O'Neill"));
        s.put("oneil", Arrays.asList("O'Neil"));
        s.put("oconnell", Arrays.asList("O'Connell"));
        s.put("todo", Arrays.asList("To-do", "To do"));
        s.put("todos", Arrays.asList("To-dos"));
        s.put("ecommerce", Arrays.asList("e-commerce"));
        s.put("elearning", Arrays.asList("e-learning"));
        s.put("esport", Arrays.asList("e-sport"));
        s.put("esports", Arrays.asList("e-sports"));
        s.put("g-mail", Arrays.asList("Gmail"));
        s.put("playstation", Arrays.asList("PlayStation"));
        s.put("wix", Arrays.asList("Wix"));
        return s;
    }

    protected Map<String, List<String>> getTopSuggestions() {
        HashMap<String, List<String>> s = new HashMap<String, List<String>>();
        s.put("on-prem", Arrays.asList("on-premise"));
        s.put("sin-off", Arrays.asList("sign-off"));
        s.put("sin-offs", Arrays.asList("sign-offs"));
        s.put("Sin-off", Arrays.asList("Sign-off"));
        s.put("Sin-offs", Arrays.asList("Sign-offs"));
        s.put("Alot", Arrays.asList("A lot"));
        s.put("alot", Arrays.asList("a lot"));
        s.put("DDOS", Arrays.asList("DDoS"));
        s.put("async", Arrays.asList("asynchronous", "asynchronously"));
        s.put("Async", Arrays.asList("Asynchronous", "Asynchronously"));
        s.put("endevours", Arrays.asList("endeavours"));
        s.put("endevors", Arrays.asList("endeavors"));
        s.put("endevour", Arrays.asList("endeavour"));
        s.put("endevor", Arrays.asList("endeavor"));
        s.put("countrys", Arrays.asList("countries", "country's", "country"));
        s.put("Countrys", Arrays.asList("Countries", "Country's", "Country"));
        s.put("familys", Arrays.asList("families", "family's", "family"));
        s.put("Familys", Arrays.asList("Families", "Family's", "Family"));
        s.put("infact", Arrays.asList("in fact"));
        s.put("Infact", Arrays.asList("In fact"));
        s.put("ad-hoc", Arrays.asList("ad hoc"));
        s.put("adhoc", Arrays.asList("ad hoc"));
        s.put("Ad-hoc", Arrays.asList("Ad hoc"));
        s.put("Adhoc", Arrays.asList("Ad hoc"));
        s.put("ad-on", Arrays.asList("add-on"));
        s.put("add-o", Arrays.asList("add-on"));
        s.put("acc", Arrays.asList("account", "accusative"));
        s.put("Acc", Arrays.asList("Account", "Accusative"));
        s.put("\u00baC", Arrays.asList("\u00b0C"));
        s.put("jus", Arrays.asList("just", "juice"));
        s.put("Jus", Arrays.asList("Just", "Juice"));
        s.put("sayed", Arrays.asList("said"));
        s.put("sess", Arrays.asList("says", "session", "cess"));
        s.put("Addon", Arrays.asList("Add-on"));
        s.put("Addons", Arrays.asList("Add-ons"));
        s.put("ios", Arrays.asList("iOS"));
        s.put("yrs", Arrays.asList("years"));
        s.put("standup", Arrays.asList("stand-up"));
        s.put("standups", Arrays.asList("stand-ups"));
        s.put("Standup", Arrays.asList("Stand-up"));
        s.put("Standups", Arrays.asList("Stand-ups"));
        s.put("Playdough", Arrays.asList("Play-Doh"));
        s.put("playdough", Arrays.asList("Play-Doh"));
        s.put("biggy", Arrays.asList("biggie"));
        s.put("lieing", Arrays.asList("lying"));
        s.put("preffered", Arrays.asList("preferred"));
        s.put("preffering", Arrays.asList("preferring"));
        s.put("reffered", Arrays.asList("referred"));
        s.put("reffering", Arrays.asList("referring"));
        s.put("passthrough", Arrays.asList("pass-through"));
        s.put("&&", Arrays.asList("&"));
        s.put("cmon", Arrays.asList("c'mon"));
        s.put("Cmon", Arrays.asList("C'mon"));
        s.put("da", Arrays.asList("the"));
        s.put("Da", Arrays.asList("The"));
        s.put("Vue", Arrays.asList("Vue.JS"));
        s.put("errornous", Arrays.asList("erroneous"));
        s.put("brang", Arrays.asList("brought"));
        s.put("brung", Arrays.asList("brought"));
        s.put("thru", Arrays.asList("through"));
        s.put("pitty", Arrays.asList("pity"));
        s.put("barbwire", Arrays.asList("barbed wire"));
        s.put("barbwires", Arrays.asList("barbed wires"));
        s.put("monkie", Arrays.asList("monkey"));
        s.put("Monkie", Arrays.asList("Monkey"));
        s.put("monkies", Arrays.asList("monkeys"));
        s.put("Monkies", Arrays.asList("Monkeys"));
        s.put("Daddys", Arrays.asList("Daddy's", "Daddies"));
        s.put("Mommys", Arrays.asList("Mommy's", "Mommies"));
        s.put("daddys", Arrays.asList("daddy's", "daddies"));
        s.put("mommys", Arrays.asList("mommy's", "mommies"));
        s.put("speach", Arrays.asList("speech"));
        s.put("icecreem", Arrays.asList("ice cream"));
        s.put("math", Arrays.asList("maths"));
        s.put("fora", Arrays.asList("for a"));
        s.put("fomr", Arrays.asList("form", "from"));
        s.put("lotsa", Arrays.asList("lots of"));
        s.put("tryna", Arrays.asList("trying to"));
        s.put("coulda", Arrays.asList("could have"));
        s.put("shoulda", Arrays.asList("should have"));
        s.put("woulda", Arrays.asList("would have"));
        s.put("tellem", Arrays.asList("tell them"));
        s.put("Tellem", Arrays.asList("Tell them"));
        s.put("Webex", Arrays.asList("WebEx"));
        s.put("didint", Arrays.asList("didn't"));
        s.put("Didint", Arrays.asList("Didn't"));
        s.put("wasint", Arrays.asList("wasn't"));
        s.put("hasint", Arrays.asList("hasn't"));
        s.put("doesint", Arrays.asList("doesn't"));
        s.put("ist", Arrays.asList("is"));
        s.put("Boing", Arrays.asList("Boeing"));
        s.put("te", Arrays.asList("the"));
        s.put("todays", Arrays.asList("today's"));
        s.put("Todays", Arrays.asList("Today's"));
        s.put("todo", Arrays.asList("to-do", "to do"));
        s.put("todos", Arrays.asList("to-dos", "to do"));
        s.put("heres", Arrays.asList("here's"));
        s.put("Heres", Arrays.asList("Here's"));
        s.put("aways", Arrays.asList("always"));
        s.put("McDonalds", Arrays.asList("McDonald's"));
        s.put("ux", Arrays.asList("UX"));
        s.put("ive", Arrays.asList("I've"));
        s.put("infos", Arrays.asList("informations"));
        s.put("Infos", Arrays.asList("Informations"));
        s.put("prios", Arrays.asList("priorities"));
        s.put("Prio", Arrays.asList("Priority"));
        s.put("prio", Arrays.asList("priority"));
        s.put("Ecommerce", Arrays.asList("E-Commerce"));
        s.put("ebook", Arrays.asList("e-book"));
        s.put("ebooks", Arrays.asList("e-books"));
        s.put("eBook", Arrays.asList("e-book"));
        s.put("eBooks", Arrays.asList("e-books"));
        s.put("Ebook", Arrays.asList("E-Book"));
        s.put("Ebooks", Arrays.asList("E-Books"));
        s.put("Esport", Arrays.asList("E-Sport"));
        s.put("Esports", Arrays.asList("E-Sports"));
        s.put("R&B", Arrays.asList("R & B", "R 'n' B"));
        s.put("ie", Arrays.asList("i.e."));
        s.put("eg", Arrays.asList("e.g."));
        s.put("ppl", Arrays.asList("people"));
        s.put("kiddin", Arrays.asList("kidding"));
        s.put("doin", Arrays.asList("doing"));
        s.put("nothin", Arrays.asList("nothing"));
        s.put("SPOC", Arrays.asList("SpOC"));
        s.put("Thx", Arrays.asList("Thanks"));
        s.put("thx", Arrays.asList("thanks"));
        s.put("ty", Arrays.asList("thank you", "thanks"));
        s.put("Sry", Arrays.asList("Sorry"));
        s.put("sry", Arrays.asList("sorry"));
        s.put("im", Arrays.asList("I'm"));
        s.put("spoilt", Arrays.asList("spoiled"));
        s.put("Lil", Arrays.asList("Little"));
        s.put("lil", Arrays.asList("little"));
        s.put("gmail", Arrays.asList("Gmail"));
        s.put("Sucka", Arrays.asList("Sucker"));
        s.put("sucka", Arrays.asList("sucker"));
        s.put("whaddya", Arrays.asList("what are you", "what do you"));
        s.put("Whaddya", Arrays.asList("What are you", "What do you"));
        s.put("sinc", Arrays.asList("sync"));
        s.put("sweety", Arrays.asList("sweetie"));
        s.put("sweetys", Arrays.asList("sweeties"));
        s.put("sowwy", Arrays.asList("sorry"));
        s.put("Sowwy", Arrays.asList("Sorry"));
        s.put("grandmum", Arrays.asList("grandma", "grandmother"));
        s.put("Grandmum", Arrays.asList("Grandma", "Grandmother"));
        s.put("Hongkong", Arrays.asList("Hong Kong"));
        s.put("center", Arrays.asList("centre"));
        s.put("ur", Arrays.asList("your", "you are"));
        s.put("Ur", Arrays.asList("Your", "You are"));
        s.put("ure", Arrays.asList("your", "you are"));
        s.put("Ure", Arrays.asList("Your", "You are"));
        s.put("mins", Arrays.asList("minutes", "min"));
        s.put("addon", Arrays.asList("add-on"));
        s.put("addons", Arrays.asList("add-ons"));
        s.put("afterparty", Arrays.asList("after-party"));
        s.put("Afterparty", Arrays.asList("After-party"));
        s.put("wellbeing", Arrays.asList("well-being"));
        s.put("cuz", Arrays.asList("because"));
        s.put("coz", Arrays.asList("because"));
        s.put("pls", Arrays.asList("please"));
        s.put("Pls", Arrays.asList("Please"));
        s.put("plz", Arrays.asList("please"));
        s.put("Plz", Arrays.asList("Please"));
        s.put("addendums", Arrays.asList("addenda"));
        s.put("algas", Arrays.asList("algae"));
        s.put("alumnas", Arrays.asList("alumnae"));
        s.put("alumnuses", Arrays.asList("alumni"));
        s.put("analysises", Arrays.asList("analyses"));
        s.put("appendixs", Arrays.asList("appendices"));
        s.put("axises", Arrays.asList("axes"));
        s.put("bacilluses", Arrays.asList("bacilli"));
        s.put("bacteriums", Arrays.asList("bacteria"));
        s.put("basises", Arrays.asList("bases"));
        s.put("beaus", Arrays.asList("beaux"));
        s.put("bisons", Arrays.asList("bison"));
        s.put("buffalos", Arrays.asList("buffaloes"));
        s.put("calfs", Arrays.asList("calves"));
        s.put("Childs", Arrays.asList("Children"));
        s.put("childs", Arrays.asList("children"));
        s.put("crisises", Arrays.asList("crises"));
        s.put("criterions", Arrays.asList("criteria"));
        s.put("curriculums", Arrays.asList("curricula"));
        s.put("datums", Arrays.asList("data"));
        s.put("deers", Arrays.asList("deer"));
        s.put("diagnosises", Arrays.asList("diagnoses"));
        s.put("echos", Arrays.asList("echoes"));
        s.put("elfs", Arrays.asList("elves"));
        s.put("ellipsises", Arrays.asList("ellipses"));
        s.put("embargos", Arrays.asList("embargoes"));
        s.put("erratums", Arrays.asList("errata"));
        s.put("firemans", Arrays.asList("firemen"));
        s.put("fishs", Arrays.asList("fishes", "fish"));
        s.put("genuses", Arrays.asList("genera"));
        s.put("gooses", Arrays.asList("geese"));
        s.put("halfs", Arrays.asList("halves"));
        s.put("heros", Arrays.asList("heroes"));
        s.put("indexs", Arrays.asList("indices", "indexes"));
        s.put("lifes", Arrays.asList("lives"));
        s.put("mans", Arrays.asList("men"));
        s.put("matrixs", Arrays.asList("matrices"));
        s.put("meanses", Arrays.asList("means"));
        s.put("mediums", Arrays.asList("media"));
        s.put("memorandums", Arrays.asList("memoranda"));
        s.put("mooses", Arrays.asList("moose"));
        s.put("mosquitos", Arrays.asList("mosquitoes"));
        s.put("neurosises", Arrays.asList("neuroses"));
        s.put("nucleuses", Arrays.asList("nuclei"));
        s.put("oasises", Arrays.asList("oases"));
        s.put("ovums", Arrays.asList("ova"));
        s.put("oxs", Arrays.asList("oxen"));
        s.put("oxes", Arrays.asList("oxen"));
        s.put("paralysises", Arrays.asList("paralyses"));
        s.put("potatos", Arrays.asList("potatoes"));
        s.put("radiuses", Arrays.asList("radii"));
        s.put("selfs", Arrays.asList("selves"));
        s.put("serieses", Arrays.asList("series"));
        s.put("sheeps", Arrays.asList("sheep"));
        s.put("shelfs", Arrays.asList("shelves"));
        s.put("scissorses", Arrays.asList("scissors"));
        s.put("specieses", Arrays.asList("species"));
        s.put("stimuluses", Arrays.asList("stimuli"));
        s.put("stratums", Arrays.asList("strata"));
        s.put("tableaus", Arrays.asList("tableaux"));
        s.put("thats", Arrays.asList("those"));
        s.put("thesises", Arrays.asList("theses"));
        s.put("thiefs", Arrays.asList("thieves"));
        s.put("thises", Arrays.asList("these"));
        s.put("tomatos", Arrays.asList("tomatoes"));
        s.put("tooths", Arrays.asList("teeth"));
        s.put("torpedos", Arrays.asList("torpedoes"));
        s.put("vertebras", Arrays.asList("vertebrae"));
        s.put("vetos", Arrays.asList("vetoes"));
        s.put("vitas", Arrays.asList("vitae"));
        s.put("watchs", Arrays.asList("watches"));
        s.put("wifes", Arrays.asList("wives", "wife's"));
        s.put("womans", Arrays.asList("women", "woman's"));
        s.put("womens", Arrays.asList("women's"));
        s.put("tippy-top", Arrays.asList("tip-top", "top most"));
        s.put("tippytop", Arrays.asList("tip-top", "top most"));
        s.put("imma", Arrays.asList("I'm going to", "I'm a"));
        s.put("Imma", Arrays.asList("I'm going to", "I'm a"));
        s.put("dontcha", Arrays.asList("don't you"));
        s.put("tobe", Arrays.asList("to be"));
        s.put("Gi", Arrays.asList("Hi"));
        s.put("Ji", Arrays.asList("Hi"));
        s.put("Dontcha", Arrays.asList("don't you"));
        s.put("greatfruit", Arrays.asList("grapefruit", "great fruit"));
        s.put("Insta", Arrays.asList("Instagram"));
        s.put("IO", Arrays.asList("I/O"));
        s.put("wierd", Arrays.asList("weird"));
        s.put("Wierd", Arrays.asList("Weird"));
        s.put("hiphop", Arrays.asList("hip-hop"));
        s.put("HipHop", Arrays.asList("Hip-Hop"));
        s.put("gove", Arrays.asList("love", "give", "gave", "move"));
        s.put("birdseye", Arrays.asList("bird's-eye"));
        s.put("Birdseye", Arrays.asList("Bird's-eye"));
        s.put("al", Arrays.asList("all", "Al"));
        s.put("publically", Arrays.asList("publicly"));
        return s;
    }

    protected List<SuggestedReplacement> getAdditionalTopSuggestions(List<SuggestedReplacement> suggestions, String word) throws IOException {
        String suggestion;
        ArrayList curatedSuggestions = new ArrayList();
        curatedSuggestions.addAll(this.topSuggestions.getOrDefault(word, Collections.emptyList()));
        curatedSuggestions.addAll(this.topSuggestionsIgnoreCase.getOrDefault(word.toLowerCase(), Collections.emptyList()));
        if (!curatedSuggestions.isEmpty()) {
            return SuggestedReplacement.convert(curatedSuggestions);
        }
        if (word.endsWith("ys") && !this.speller1.isMisspelled(suggestion = word.replaceFirst("ys$", "ies"))) {
            return SuggestedReplacement.convert(Arrays.asList(suggestion));
        }
        return super.getAdditionalTopSuggestions(suggestions, word);
    }

    protected Translator getTranslator(GlobalConfig globalConfig) {
        return this.translator;
    }

    private static class IrregularForms {
        final String baseform;
        final String posName;
        final String formName;
        final List<String> forms;

        private IrregularForms(String baseform, String posName, String formName, List<String> forms) {
            this.baseform = baseform;
            this.posName = posName;
            this.formName = formName;
            this.forms = forms;
        }
    }
}

