/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.language.markdown;

import com.intellij.grazie.utils.PsiUtilsKt;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u001c\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/grazie/ide/language/markdown/MarkdownPsiUtils;", "", "()V", "codeTypes", "", "Lcom/intellij/psi/tree/IElementType;", "kotlin.jvm.PlatformType", "inlineTypes", "linkTypes", "isHeaderContent", "", "element", "Lcom/intellij/psi/PsiElement;", "isInOuterListItem", "isInline", "isOuterListItem", "isParagraph", "intellij.grazie"})
public final class MarkdownPsiUtils {
    private static final Set<IElementType> linkTypes;
    private static final Set<IElementType> codeTypes;
    private static final Set<IElementType> inlineTypes;
    public static final MarkdownPsiUtils INSTANCE;

    public final boolean isParagraph(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode();
        if (aSTNode != null) {
            IElementType[] iElementTypeArray = new IElementType[1];
            IElementType iElementType = MarkdownElementTypes.PARAGRAPH;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownElementTypes.PARAGRAPH");
            iElementTypeArray[0] = iElementType;
            bl = PsiUtilsKt.hasType(aSTNode, iElementTypeArray);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isHeaderContent(@NotNull PsiElement element) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode();
        if (aSTNode != null) {
            IElementType[] iElementTypeArray = new IElementType[2];
            IElementType iElementType = MarkdownTokenTypes.ATX_CONTENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownTokenTypes.ATX_CONTENT");
            iElementTypeArray[0] = iElementType;
            IElementType iElementType2 = MarkdownTokenTypes.SETEXT_CONTENT;
            Intrinsics.checkNotNullExpressionValue((Object)iElementType2, (String)"MarkdownTokenTypes.SETEXT_CONTENT");
            iElementTypeArray[1] = iElementType2;
            bl = PsiUtilsKt.hasType(aSTNode, iElementTypeArray);
        } else {
            bl = false;
        }
        return bl;
    }

    public final boolean isInline(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode();
        return aSTNode != null ? PsiUtilsKt.hasType(aSTNode, inlineTypes) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isOuterListItem(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode();
        if (aSTNode == null) return false;
        IElementType[] iElementTypeArray = new IElementType[1];
        IElementType iElementType = MarkdownElementTypes.LIST_ITEM;
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"MarkdownElementTypes.LIST_ITEM");
        iElementTypeArray[0] = iElementType;
        boolean bl = PsiUtilsKt.hasType(aSTNode, iElementTypeArray);
        if (!bl) return false;
        ASTNode aSTNode2 = element.getNode();
        if (aSTNode2 == null) return false;
        TokenSet tokenSet = TokenSet.create((IElementType[])new IElementType[]{MarkdownElementTypes.LIST_ITEM});
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"TokenSet.create(MarkdownElementTypes.LIST_ITEM)");
        boolean bl2 = PsiUtilsKt.noParentOfTypes(aSTNode2, tokenSet);
        if (!bl2) return false;
        return true;
    }

    public final boolean isInOuterListItem(@NotNull PsiElement element) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Sequence<PsiElement> $this$any$iv = PsiUtilsKt.parents(element);
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.isOuterListItem(it)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    private MarkdownPsiUtils() {
    }

    static {
        MarkdownPsiUtils markdownPsiUtils;
        INSTANCE = markdownPsiUtils = new MarkdownPsiUtils();
        linkTypes = SetsKt.setOf((Object[])new IElementType[]{MarkdownElementTypes.LINK_DEFINITION, MarkdownElementTypes.LINK_LABEL, MarkdownElementTypes.LINK_DESTINATION, MarkdownElementTypes.LINK_TITLE, MarkdownElementTypes.LINK_TEXT, MarkdownElementTypes.LINK_COMMENT, MarkdownElementTypes.FULL_REFERENCE_LINK, MarkdownElementTypes.SHORT_REFERENCE_LINK, MarkdownElementTypes.AUTOLINK, MarkdownElementTypes.INLINE_LINK});
        codeTypes = SetsKt.setOf((Object[])new IElementType[]{MarkdownElementTypes.CODE_FENCE, MarkdownElementTypes.CODE_BLOCK, MarkdownElementTypes.CODE_SPAN});
        inlineTypes = SetsKt.plus(linkTypes, (Iterable)codeTypes);
    }
}

