/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.util.containers.ContainerUtil;
import icons.JetgroovyIcons;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.GroovyBundle;
import org.jetbrains.plugins.groovy.GroovyEnabledFileType;
import org.jetbrains.plugins.groovy.GroovyLanguage;

public final class GroovyFileType
extends LanguageFileType {
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.1")
    public static final List<FileType> GROOVY_FILE_TYPES = new ArrayList<FileType>();
    @NotNull
    public static final GroovyFileType GROOVY_FILE_TYPE = new GroovyFileType();
    @NonNls
    public static final String DEFAULT_EXTENSION = "groovy";

    private GroovyFileType() {
        super((Language)GroovyLanguage.INSTANCE);
    }

    @NotNull
    @NonNls
    public String getName() {
        return "Groovy";
    }

    @NotNull
    public String getDescription() {
        String string = GroovyBundle.message("language.groovy", new Object[0]);
        if (string == null) {
            GroovyFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    public Icon getIcon() {
        return JetgroovyIcons.Groovy.Groovy_16x16;
    }

    public boolean isJVMDebuggingSupported() {
        return true;
    }

    @NotNull
    public static @NotNull FileType @NotNull [] getGroovyEnabledFileTypes() {
        LinkedHashSet<FileType> result2 = new LinkedHashSet<FileType>(GROOVY_FILE_TYPES);
        result2.addAll(ContainerUtil.filter((Object[])FileTypeManager.getInstance().getRegisteredFileTypes(), GroovyFileType::isGroovyEnabledFileType));
        FileType[] fileTypeArray = result2.toArray(FileType.EMPTY_ARRAY);
        if (fileTypeArray == null) {
            GroovyFileType.$$$reportNull$$$0(1);
        }
        return fileTypeArray;
    }

    private static boolean isGroovyEnabledFileType(FileType ft) {
        return ft instanceof GroovyEnabledFileType || ft instanceof LanguageFileType && ((LanguageFileType)ft).getLanguage() == GroovyLanguage.INSTANCE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/plugins/groovy/GroovyFileType";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroovyEnabledFileTypes";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

