/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.highlighter;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GroovyStringLexerBase
extends LexerBase {
    private static final Logger LOG = Logger.getInstance(GroovyStringLexerBase.class);
    private final IElementType myContentElementType;
    private CharSequence myBuffer;
    private int myBufferEnd;
    private int myStart;
    private int myEnd;
    private IElementType myTokenType;

    public GroovyStringLexerBase(IElementType contentElementType) {
        this.myContentElementType = contentElementType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            GroovyStringLexerBase.$$$reportNull$$$0(0);
        }
        if (buffer.length() < endOffset) {
            LOG.error("buffer Length: " + buffer.length() + ", endOffset: " + endOffset, new Attachment[]{new Attachment("", buffer.toString())});
        }
        this.myBuffer = buffer;
        this.myEnd = startOffset;
        this.myBufferEnd = endOffset;
        this.myTokenType = this.locateToken();
    }

    @Nullable
    private IElementType locateToken() {
        if (this.myEnd >= this.myBufferEnd) {
            return null;
        }
        this.myStart = this.myEnd;
        if (this.checkForSimpleValidEscape(this.myStart)) {
            this.myEnd = this.myStart + 2;
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (this.checkForHexCodeStart(this.myStart)) {
            this.myEnd = this.myStart + 2;
            while (this.myEnd < this.myStart + 6) {
                if (this.myEnd >= this.myBufferEnd || !StringUtil.isHexDigit((char)this.myBuffer.charAt(this.myEnd))) {
                    return StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                }
                ++this.myEnd;
            }
            return StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
        }
        if (this.checkForInvalidSimpleEscape(this.myStart)) {
            this.myEnd = this.myStart + 2;
            return StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
        }
        while (this.myEnd < this.myBufferEnd && !this.checkForSimpleValidEscape(this.myEnd) && !this.checkForHexCodeStart(this.myEnd)) {
            ++this.myEnd;
        }
        return this.myContentElementType;
    }

    protected abstract boolean checkForSimpleValidEscape(int var1);

    protected abstract boolean checkForInvalidSimpleEscape(int var1);

    protected abstract boolean checkForHexCodeStart(int var1);

    public int getState() {
        return 0;
    }

    public IElementType getTokenType() {
        return this.myTokenType;
    }

    public int getTokenStart() {
        return this.myStart;
    }

    public int getTokenEnd() {
        return this.myEnd;
    }

    public void advance() {
        this.myTokenType = this.locateToken();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            GroovyStringLexerBase.$$$reportNull$$$0(1);
        }
        return charSequence;
    }

    public int getBufferEnd() {
        return this.myBufferEnd;
    }

    protected char charAt(int i) {
        return this.myBuffer.charAt(i);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/highlighter/GroovyStringLexerBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/highlighter/GroovyStringLexerBase";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

