/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.typeEnhancers;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.ConversionResult;
import org.jetbrains.plugins.groovy.lang.psi.typeEnhancers.GrTypeConverter;

public class GrClassConverter
extends GrTypeConverter {
    @Override
    public boolean isApplicableTo(@NotNull GrTypeConverter.Position position) {
        if (position == null) {
            GrClassConverter.$$$reportNull$$$0(0);
        }
        switch (position) {
            case ASSIGNMENT: 
            case RETURN_VALUE: {
                return true;
            }
        }
        return false;
    }

    @Override
    @Nullable
    public ConversionResult isConvertible(@NotNull PsiType targetType, @NotNull PsiType actualType, @NotNull GrTypeConverter.Position position, @NotNull GroovyPsiElement context) {
        if (targetType == null) {
            GrClassConverter.$$$reportNull$$$0(1);
        }
        if (actualType == null) {
            GrClassConverter.$$$reportNull$$$0(2);
        }
        if (position == null) {
            GrClassConverter.$$$reportNull$$$0(3);
        }
        if (context == null) {
            GrClassConverter.$$$reportNull$$$0(4);
        }
        if (!(targetType instanceof PsiClassType) || !((PsiClassType)targetType).rawType().equalsToText("java.lang.Class")) {
            return null;
        }
        if (actualType instanceof PsiClassType && ((PsiClassType)actualType).rawType().equalsToText("java.lang.Class")) {
            return null;
        }
        if (actualType == PsiType.NULL) {
            return ConversionResult.OK;
        }
        GrLiteral literal = GrClassConverter.getLiteral(context);
        Object value = literal == null ? null : literal.getValue();
        String fqn = value == null ? null : value.toString();
        PsiClass psiClass = fqn == null ? null : JavaPsiFacade.getInstance((Project)context.getProject()).findClass(fqn, context.getResolveScope());
        return psiClass == null ? ConversionResult.WARNING : ConversionResult.OK;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actualType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/typeEnhancers/GrClassConverter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableTo";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isConvertible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

