/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GrFunctionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyReference;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrIndexProperty;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyMethodCallReference;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ConstructorCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ExpectedType;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.FunctionalExpressionConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.ListConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.MethodCallConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.SafeCastConstraint;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.TypePositionConstraint;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0006\b\u0000\u0012\u00020\r0\fH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpressionConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "expectedType", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpectedType;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;", "(Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ExpectedType;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrExpression;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "toString", "", "intellij.groovy.psi"})
public final class ExpressionConstraint
extends GrConstraintFormula {
    private final ExpectedType expectedType;
    private final GrExpression expression;

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<? super ConstraintFormula> constraints) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        if (!session.checkPredicates(this.expression)) {
            return true;
        }
        ExpectedType expectedType = this.expectedType;
        PsiType leftType = expectedType != null ? expectedType.getType() : null;
        GrExpression grExpression = this.expression;
        if (grExpression instanceof GrMethodCall) {
            GroovyResolveResult groovyResolveResult = ((GrMethodCall)this.expression).advancedResolve();
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return true;
            }
            GroovyMethodResult result2 = groovyMethodResult;
            constraints.add(new MethodCallConstraint(this.expectedType, result2, this.expression));
        } else if (grExpression instanceof GrNewExpression) {
            constraints.add(new ConstructorCallConstraint(leftType, (GrNewExpression)this.expression));
        } else if (grExpression instanceof GrFunctionalExpression) {
            if (leftType != null) {
                constraints.add(new FunctionalExpressionConstraint((GrFunctionalExpression)this.expression, leftType));
            }
        } else if (grExpression instanceof GrSafeCastExpression) {
            if (leftType != null) {
                constraints.add(new SafeCastConstraint(leftType, (GrSafeCastExpression)this.expression));
            }
        } else if (grExpression instanceof GrListOrMap) {
            constraints.add(new ListConstraint(leftType, (GrListOrMap)this.expression));
        } else if (grExpression instanceof GrReferenceExpression) {
            GroovyResolveResult result3;
            GroovyReference groovyReference = ((GrReferenceExpression)this.expression).getRValueReference();
            GroovyResolveResult groovyResolveResult = result3 = groovyReference != null ? groovyReference.advancedResolve() : null;
            if (result3 instanceof GroovyMethodResult) {
                Collection collection = constraints;
                MethodCallConstraint methodCallConstraint = new MethodCallConstraint(this.expectedType, (GroovyMethodResult)result3, this.expression);
                boolean bl = false;
                collection.add(methodCallConstraint);
            } else if (this.expectedType != null) {
                Collection collection = constraints;
                TypePositionConstraint typePositionConstraint = new TypePositionConstraint(this.expectedType, ((GrReferenceExpression)this.expression).getType(), this.expression);
                boolean bl = false;
                collection.add(typePositionConstraint);
            }
        } else if (grExpression instanceof GrIndexProperty) {
            GroovyResolveResult result4;
            GroovyMethodCallReference groovyMethodCallReference = ((GrIndexProperty)this.expression).getRValueReference();
            GroovyResolveResult groovyResolveResult = result4 = groovyMethodCallReference != null ? groovyMethodCallReference.advancedResolve() : null;
            if (result4 instanceof GroovyMethodResult) {
                Collection collection = constraints;
                MethodCallConstraint methodCallConstraint = new MethodCallConstraint(this.expectedType, (GroovyMethodResult)result4, this.expression);
                boolean bl = false;
                collection.add(methodCallConstraint);
            } else if (this.expectedType != null) {
                Collection collection = constraints;
                TypePositionConstraint typePositionConstraint = new TypePositionConstraint(this.expectedType, ((GrIndexProperty)this.expression).getType(), this.expression);
                boolean bl = false;
                collection.add(typePositionConstraint);
            }
        } else if (grExpression instanceof GrAssignmentExpression) {
            GroovyReference lValueReference;
            GroovyReference groovyReference;
            GrExpression grExpression2 = ((GrAssignmentExpression)this.expression).getLValue();
            Intrinsics.checkNotNullExpressionValue((Object)grExpression2, (String)"expression.lValue");
            GrExpression lValue = grExpression2;
            if (lValue instanceof GrReferenceExpression) {
                groovyReference = ((GrReferenceExpression)lValue).getLValueReference();
            } else if (lValue instanceof GrIndexProperty) {
                groovyReference = ((GrIndexProperty)lValue).getLValueReference();
            } else {
                return true;
            }
            GroovyReference groovyReference2 = lValueReference = groovyReference;
            GroovyResolveResult groovyResolveResult = groovyReference2 != null ? groovyReference2.advancedResolve() : null;
            if (!(groovyResolveResult instanceof GroovyMethodResult)) {
                groovyResolveResult = null;
            }
            GroovyMethodResult groovyMethodResult = (GroovyMethodResult)groovyResolveResult;
            if (groovyMethodResult == null) {
                return true;
            }
            GroovyMethodResult result5 = groovyMethodResult;
            constraints.add(new MethodCallConstraint(null, result5, this.expression));
        } else if (this.expectedType != null) {
            constraints.add(new TypePositionConstraint(this.expectedType, this.expression.getType(), this.expression));
        }
        return true;
    }

    @Override
    @NotNull
    public String toString() {
        ExpectedType expectedType;
        ExpectedType expectedType2 = this.expectedType;
        return this.expression.getText() + " -> " + ((expectedType = this.expectedType) != null && (expectedType = expectedType.getType()) != null ? expectedType.getPresentableText() : null) + " in " + (Object)((Object)(expectedType2 != null ? expectedType2.getPosition() : null));
    }

    public ExpressionConstraint(@Nullable ExpectedType expectedType, @NotNull GrExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.expectedType = expectedType;
        this.expression = expression;
    }
}

