/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.references;

import com.intellij.lang.jvm.JvmModifier;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrNamedArgument;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrSafeCastExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrGdkMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrClassTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.resolve.api.Argument;
import org.jetbrains.plugins.groovy.lang.resolve.api.ExpressionArgument;
import org.jetbrains.plugins.groovy.lang.resolve.api.GroovyPropertyWriteReference;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ArgumentsKt;
import org.jetbrains.plugins.groovy.lang.resolve.impl.ConstructorsKt;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSessionBuilderKt;
import org.jetbrains.plugins.groovy.lang.typing.TypeUtils;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0018\u00010\fj\u0004\u0018\u0001`\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\b\u001a\u00020\tH\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"ignoredFqnsInSafeCast", "", "", "ignoredFqnsInTransformation", "fallsBackToConstructor", "", "clazz", "Lcom/intellij/psi/PsiClass;", "literal", "Lorg/jetbrains/plugins/groovy/lang/psi/api/auxiliary/GrListOrMap;", "fallsBackToConstructorCS", "getArguments", "", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Argument;", "Lorg/jetbrains/plugins/groovy/lang/resolve/api/Arguments;", "getExpectedType", "Lcom/intellij/psi/PsiType;", "cs", "getExpectedTypeFromAssignmentOrReturn", "getExpectedTypeFromCoercion", "getExpectedTypeFromNamedArgument", "resolvesToDGM", "safeCast", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrSafeCastExpression;", "safeCastFallsBackToCast", "classResult", "Lorg/jetbrains/plugins/groovy/lang/psi/api/GroovyResolveResult;", "intellij.groovy.psi"})
public final class GrLiteralConstructorReferenceKt {
    private static final Set<String> ignoredFqnsInSafeCast = SetsKt.setOf((Object[])new String[]{"java.util.List", "java.util.Set", "java.util.SortedSet", "java.util.Queue", "java.util.Stack", "java.util.LinkedList", "java.lang.String"});
    private static final Set<String> ignoredFqnsInTransformation = SetsKt.setOf((Object[])new String[]{"java.lang.Object", "java.lang.Class", "java.lang.String", "java.lang.Boolean", "java.lang.Character"});

    private static final PsiType getExpectedType(GrListOrMap literal, boolean cs) {
        PsiType psiType;
        PsiType psiType2 = GrLiteralConstructorReferenceKt.getExpectedTypeFromAssignmentOrReturn(literal, cs);
        if (psiType2 == null) {
            psiType2 = psiType = GrLiteralConstructorReferenceKt.getExpectedTypeFromNamedArgument(literal);
        }
        if (psiType2 == null) {
            psiType = GrLiteralConstructorReferenceKt.getExpectedTypeFromCoercion(literal);
        }
        return psiType;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final PsiType getExpectedTypeFromAssignmentOrReturn(GrListOrMap literal, boolean cs) {
        PsiType psiType;
        if (cs) {
            void var2_2;
            PsiType type2 = GroovyInferenceSessionBuilderKt.getAssignmentExpectedType(literal);
            if (literal.isMap() || !literal.isEmpty()) {
                PsiType psiType2 = type2;
                if (psiType2 == null) return null;
                psiType = TypeUtils.box(psiType2, literal);
                return psiType;
            }
            if (type2 instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)type2).resolve();
                if (psiClass != null) {
                    if (psiClass.isInterface()) {
                        return null;
                    }
                }
            }
            psiType = var2_2;
            return psiType;
        }
        psiType = GroovyInferenceSessionBuilderKt.getAssignmentOrReturnExpectedType(literal);
        return psiType;
    }

    private static final PsiType getExpectedTypeFromNamedArgument(GrListOrMap literal) {
        PsiElement psiElement = literal.getParent();
        if (!(psiElement instanceof GrNamedArgument)) {
            psiElement = null;
        }
        GrNamedArgument grNamedArgument = (GrNamedArgument)psiElement;
        if (grNamedArgument == null) {
            return null;
        }
        GrNamedArgument namedArgument = grNamedArgument;
        GrArgumentLabel grArgumentLabel = namedArgument.getLabel();
        if (grArgumentLabel == null) {
            return null;
        }
        GrArgumentLabel label = grArgumentLabel;
        GroovyPropertyWriteReference groovyPropertyWriteReference = label.getConstructorPropertyReference();
        if (groovyPropertyWriteReference == null) {
            return null;
        }
        GroovyPropertyWriteReference propertyReference = groovyPropertyWriteReference;
        GroovyResolveResult groovyResolveResult = propertyReference.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"propertyReference.advancedResolve()");
        return TypeUtils.getWritePropertyType(groovyResolveResult);
    }

    private static final PsiType getExpectedTypeFromCoercion(GrListOrMap literal) {
        PsiElement psiElement = literal.getParent();
        if (!(psiElement instanceof GrSafeCastExpression)) {
            psiElement = null;
        }
        GrSafeCastExpression grSafeCastExpression = (GrSafeCastExpression)psiElement;
        if (grSafeCastExpression == null) {
            return null;
        }
        GrSafeCastExpression safeCast = grSafeCastExpression;
        if (!GrLiteralConstructorReferenceKt.resolvesToDGM(safeCast)) {
            return null;
        }
        GrTypeElement grTypeElement = safeCast.getCastTypeElement();
        if (!(grTypeElement instanceof GrClassTypeElement)) {
            grTypeElement = null;
        }
        GrClassTypeElement grClassTypeElement = (GrClassTypeElement)grTypeElement;
        if (grClassTypeElement == null) {
            return null;
        }
        GrClassTypeElement typeElement = grClassTypeElement;
        Collection collection = typeElement.getReferenceElement().resolve(false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"typeElement.referenceElement.resolve(false)");
        GroovyResolveResult groovyResolveResult = (GroovyResolveResult)CollectionsKt.singleOrNull((Iterable)collection);
        if (groovyResolveResult == null) {
            return null;
        }
        GroovyResolveResult typeResult = groovyResolveResult;
        if (GrLiteralConstructorReferenceKt.safeCastFallsBackToCast(literal, typeResult)) {
            return typeElement.getType();
        }
        return null;
    }

    private static final boolean resolvesToDGM(GrSafeCastExpression safeCast) {
        GrGdkMethod grGdkMethod;
        PsiClass containingClass;
        PsiElement psiElement = safeCast.getReference().resolve();
        if (!(psiElement instanceof PsiMethod)) {
            psiElement = null;
        }
        PsiMethod psiMethod = (PsiMethod)psiElement;
        if (psiMethod == null) {
            return false;
        }
        PsiMethod method = psiMethod;
        PsiMethod psiMethod2 = method;
        if (!(psiMethod2 instanceof GrGdkMethod)) {
            psiMethod2 = null;
        }
        PsiClass psiClass = containingClass = (grGdkMethod = (GrGdkMethod)psiMethod2) != null && (grGdkMethod = grGdkMethod.getStaticMethod()) != null ? grGdkMethod.getContainingClass() : null;
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"org.codehaus.groovy.runtime.DefaultGroovyMethods");
    }

    private static final boolean safeCastFallsBackToCast(GrListOrMap literal, GroovyResolveResult classResult) {
        Collection<GroovyResolveResult> constructors;
        PsiElement psiElement = classResult.getElement();
        if (!(psiElement instanceof PsiClass)) {
            psiElement = null;
        }
        PsiClass psiClass = (PsiClass)psiElement;
        if (psiClass == null) {
            return false;
        }
        PsiClass clazz = psiClass;
        if (literal.isMap()) {
            return !clazz.isInterface();
        }
        if (CollectionsKt.contains((Iterable)ignoredFqnsInSafeCast, (Object)clazz.getQualifiedName())) {
            return false;
        }
        PsiSubstitutor psiSubstitutor = PsiSubstitutor.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"PsiSubstitutor.EMPTY");
        Collection<GroovyResolveResult> collection = constructors = ConstructorsKt.resolveConstructor(clazz, psiSubstitutor, CollectionsKt.listOf((Object)new ExpressionArgument(literal)), literal);
        boolean bl = false;
        if (!collection.isEmpty()) {
            boolean bl2;
            block15: {
                Iterable $this$all$iv = constructors;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        GroovyResolveResult it = (GroovyResolveResult)element$iv;
                        boolean bl3 = false;
                        if (it.isApplicable()) continue;
                        bl2 = false;
                        break block15;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return false;
            }
        }
        if (InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.util.Collection")) {
            Collection<GroovyResolveResult> noArgConstructors;
            PsiSubstitutor psiSubstitutor2 = PsiSubstitutor.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor2, (String)"PsiSubstitutor.EMPTY");
            Collection<GroovyResolveResult> $i$f$all = noArgConstructors = ConstructorsKt.resolveConstructor(clazz, psiSubstitutor2, CollectionsKt.emptyList(), literal);
            boolean bl4 = false;
            if (!$i$f$all.isEmpty()) {
                boolean bl5;
                block16: {
                    Iterable $this$all$iv = noArgConstructors;
                    boolean $i$f$all2 = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl5 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            GroovyResolveResult it = (GroovyResolveResult)element$iv;
                            boolean bl6 = false;
                            if (it.isApplicable()) continue;
                            bl5 = false;
                            break block16;
                        }
                        bl5 = true;
                    }
                }
                if (bl5) {
                    return false;
                }
            }
        }
        return true;
    }

    private static final boolean fallsBackToConstructorCS(PsiClass clazz, GrListOrMap literal) {
        if (Intrinsics.areEqual((Object)clazz.getQualifiedName(), (Object)"java.lang.Class")) {
            return false;
        }
        PsiType psiType = literal.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        PsiClass literalClass = psiClassType != null ? psiClassType.resolve() : null;
        return !InheritanceUtil.isInheritorOrSelf((PsiClass)literalClass, (PsiClass)clazz, (boolean)true);
    }

    private static final boolean fallsBackToConstructor(PsiClass clazz, GrListOrMap literal) {
        PsiClass literalClass;
        if (clazz.isEnum()) {
            return false;
        }
        String string = clazz.getQualifiedName();
        if (string == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.qualifiedName ?: return false");
        String qualifiedName = string;
        if (ignoredFqnsInTransformation.contains(qualifiedName)) {
            return false;
        }
        if (InheritanceUtil.isInheritor((PsiClass)clazz, (String)"java.lang.Number")) {
            return false;
        }
        PsiType psiType = literal.getType();
        if (!(psiType instanceof PsiClassType)) {
            psiType = null;
        }
        PsiClassType psiClassType = (PsiClassType)psiType;
        Object object = literalClass = psiClassType != null ? psiClassType.resolve() : null;
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)literalClass, (PsiClass)clazz, (boolean)true)) {
            return false;
        }
        if (!literal.isMap()) {
            PsiClass lhs;
            if (Intrinsics.areEqual((Object)qualifiedName, (Object)"java.util.LinkedHashSet")) {
                return false;
            }
            if (clazz.hasModifier(JvmModifier.ABSTRACT) && InheritanceUtil.isInheritor((PsiClass)(lhs = JavaPsiFacade.getInstance((Project)literal.getProject()).findClass("java.util.LinkedHashSet", literal.getResolveScope())), (String)qualifiedName)) {
                return false;
            }
        }
        return true;
    }

    private static final List<Argument> getArguments(GrListOrMap literal) {
        if (literal.isMap()) {
            return CollectionsKt.listOf((Object)new ExpressionArgument(literal));
        }
        GrExpression[] grExpressionArray = literal.getInitializers();
        Intrinsics.checkNotNullExpressionValue((Object)grExpressionArray, (String)"literal.initializers");
        return ArgumentsKt.getExpressionArguments(grExpressionArray);
    }

    public static final /* synthetic */ PsiType access$getExpectedType(GrListOrMap literal, boolean cs) {
        return GrLiteralConstructorReferenceKt.getExpectedType(literal, cs);
    }

    public static final /* synthetic */ boolean access$fallsBackToConstructorCS(PsiClass clazz, GrListOrMap literal) {
        return GrLiteralConstructorReferenceKt.fallsBackToConstructorCS(clazz, literal);
    }

    public static final /* synthetic */ boolean access$fallsBackToConstructor(PsiClass clazz, GrListOrMap literal) {
        return GrLiteralConstructorReferenceKt.fallsBackToConstructor(clazz, literal);
    }

    public static final /* synthetic */ List access$getArguments(GrListOrMap literal) {
        return GrLiteralConstructorReferenceKt.getArguments(literal);
    }
}

