/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.xpath.psi;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.intellij.lang.xpath.psi.XPath2SequenceType;
import org.intellij.lang.xpath.psi.XPathType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XPath2Type
extends XPathType {
    public static final String XMLSCHEMA_NS = "http://www.w3.org/2001/XMLSchema";
    private static final Map<QName, XPath2Type> ourMap = new HashMap<QName, XPath2Type>();
    public static final XPath2Type ITEM = XPath2Type.createItemType("item()", ANY);
    public static final XPath2Type NODE = XPath2Type.createItemType("node()", ITEM);
    public static final XPath2Type TEXT = XPath2Type.createItemType("text()", ITEM);
    public static final XPath2Type ELEMENT = XPath2Type.createItemType("element()", NODE);
    public static final XPath2Type ATTRIBUTE = XPath2Type.createItemType("attribute()", NODE);
    public static final XPath2Type PROCESSING_INSTRUCTION = XPath2Type.createItemType("processing-instruction()", NODE);
    public static final XPath2Type NODE_SEQUENCE = XPath2SequenceType.create(NODE, XPath2SequenceType.Cardinality.ZERO_OR_MORE);
    public static final XPath2Type SEQUENCE = XPath2SequenceType.create(ITEM, XPath2SequenceType.Cardinality.ZERO_OR_MORE);
    public static final XPath2Type ANYATOMICTYPE = XPath2Type.createSchemaType("anyAtomicType", ITEM);
    public static final XPath2Type UNTYPEDATOMIC = XPath2Type.createSchemaType("untypedAtomic", ANYATOMICTYPE);
    public static final XPath2Type STRING = XPath2Type.createSchemaType("string", ANYATOMICTYPE);
    public static final XPath2Type NORMALIZEDSTRING = XPath2Type.createSchemaType("normalizedString", STRING);
    public static final XPath2Type TOKEN = XPath2Type.createSchemaType("token", NORMALIZEDSTRING);
    public static final XPath2Type LANGUAGE = XPath2Type.createSchemaType("language", TOKEN);
    public static final XPath2Type NMTOKEN = XPath2Type.createSchemaType("NMTOKEN", TOKEN);
    public static final XPath2Type NAME = XPath2Type.createSchemaType("Name", TOKEN);
    public static final XPath2Type NCNAME = XPath2Type.createSchemaType("NCName", NAME);
    public static final XPath2Type ID = XPath2Type.createSchemaType("ID", NCNAME);
    public static final XPath2Type IDREF = XPath2Type.createSchemaType("IDREF", NCNAME);
    public static final XPath2Type ENTITY = XPath2Type.createSchemaType("ENTITY", NCNAME);
    public static final XPath2Type BOOLEAN = XPath2Type.createSchemaType("boolean", ANYATOMICTYPE);
    public static final XPath2Type BOOLEAN_STRICT = new SchemaType("boolean", BOOLEAN);
    public static final XPath2Type NUMERIC = XPath2Type.createSchemaType("numeric", ANYATOMICTYPE);
    public static final XPath2Type FLOAT = XPath2Type.createSchemaType("float", NUMERIC);
    public static final XPath2Type DOUBLE = XPath2Type.createSchemaType("double", NUMERIC);
    public static final XPath2Type DECIMAL = XPath2Type.createSchemaType("decimal", NUMERIC);
    public static final XPath2Type INTEGER = XPath2Type.createSchemaType("integer", DECIMAL);
    public static final XPath2Type QNAME = XPath2Type.createSchemaType("QName", ANYATOMICTYPE);
    public static final XPath2Type ANYURI = XPath2Type.createSchemaType("anyURI", ANYATOMICTYPE);
    public static final XPath2Type BASE64BINARY = XPath2Type.createSchemaType("base64Binary", ANYATOMICTYPE);
    public static final XPath2Type HEXBINARY = XPath2Type.createSchemaType("hexBinary", ANYATOMICTYPE);
    public static final XPath2Type DATE = XPath2Type.createSchemaType("date", ANYATOMICTYPE);
    public static final XPath2Type TIME = XPath2Type.createSchemaType("time", ANYATOMICTYPE);
    public static final XPath2Type DATETIME = XPath2Type.createSchemaType("dateTime", ANYATOMICTYPE);
    public static final XPath2Type DURATION = XPath2Type.createSchemaType("duration", ANYATOMICTYPE);
    public static final XPath2Type DAYTIMEDURATION = XPath2Type.createSchemaType("dayTimeDuration", DURATION);
    public static final XPath2Type YEARMONTHDURATION = XPath2Type.createSchemaType("yearMonthDuration", DURATION);
    public static final XPath2Type GYEARMONTH = XPath2Type.createSchemaType("gYearMonth", ANYATOMICTYPE);
    public static final XPath2Type GYEAR = XPath2Type.createSchemaType("gYear", ANYATOMICTYPE);
    public static final XPath2Type GMONTHDAY = XPath2Type.createSchemaType("gMonthDay", ANYATOMICTYPE);
    public static final XPath2Type GDAY = XPath2Type.createSchemaType("gDay", ANYATOMICTYPE);
    public static final XPath2Type GMONTH = XPath2Type.createSchemaType("gMonth", ANYATOMICTYPE);
    private final XPathType mySuperType;

    protected XPath2Type(String s, XPathType superType) {
        super(s, false);
        this.mySuperType = superType;
    }

    protected static XPath2Type createSchemaType(String s, XPathType superType) {
        SchemaType type = new SchemaType(s, superType);
        ourMap.put(new QName(XMLSCHEMA_NS, s), type);
        return type;
    }

    protected static XPath2Type createItemType(String s, XPathType superType) {
        ItemType type = new ItemType(s, superType);
        ourMap.put(new QName("", s), type);
        return type;
    }

    public XPathType getSuperType() {
        return this.mySuperType;
    }

    @Override
    public boolean isAssignableFrom(@NotNull XPathType type) {
        if (type == null) {
            XPath2Type.$$$reportNull$$$0(0);
        }
        if (type instanceof XPath2SequenceType) {
            type = ((XPath2SequenceType)type).getType();
        }
        if (type instanceof XPath2Type) {
            if (this.equals(type)) {
                return true;
            }
            XPathType t = ((XPath2Type)type).getSuperType();
            while (t != null) {
                if (t.equals(this)) {
                    return true;
                }
                if (!(t instanceof XPath2Type)) break;
                t = ((XPath2Type)t).getSuperType();
            }
        }
        return false;
    }

    @Override
    public boolean canBePromotedTo(XPathType type) {
        while (type instanceof XPath2SequenceType) {
            type = ((XPath2SequenceType)type).getType();
        }
        if (this == ITEM || NODE.isAssignableFrom(this) || this == ANYATOMICTYPE && ANYATOMICTYPE.isAssignableFrom(type)) {
            return true;
        }
        if (FLOAT.isAssignableFrom(this) && type == DOUBLE) {
            return true;
        }
        if (DECIMAL.isAssignableFrom(this) && (type == DOUBLE || type == FLOAT)) {
            return true;
        }
        if (INTEGER.isAssignableFrom(this) && (type == DOUBLE || type == FLOAT || type == INTEGER || type == DECIMAL)) {
            return true;
        }
        if (ANYURI.isAssignableFrom(this) && type == STRING) {
            return true;
        }
        if (ANYURI.isAssignableFrom(this) && type == BOOLEAN) {
            return true;
        }
        if (STRING.isAssignableFrom(this) && type == BOOLEAN) {
            return true;
        }
        if (NUMERIC.isAssignableFrom(this) && type == BOOLEAN) {
            return true;
        }
        if (this == UNTYPEDATOMIC && type == BOOLEAN) {
            return true;
        }
        return this == BOOLEAN && type == BOOLEAN_STRICT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XPath2Type type = (XPath2Type)o;
        if (!this.mySuperType.equals(type.mySuperType)) {
            return false;
        }
        return Comparing.equal((Object)this.getQName(), (Object)type.getQName());
    }

    public int hashCode() {
        return this.getName().hashCode() + this.mySuperType.hashCode() * 5;
    }

    @Nullable
    public static XPath2Type schemaType(String name) {
        return ourMap.get(new QName(XMLSCHEMA_NS, name));
    }

    @Nullable
    public static XPath2Type fromName(QName name) {
        String local = name.getLocalPart();
        if (local.endsWith("*")) {
            return XPath2SequenceType.create(XPath2Type.lookupSequenceType(name, local), XPath2SequenceType.Cardinality.ZERO_OR_MORE);
        }
        if (local.endsWith("+")) {
            return XPath2SequenceType.create(XPath2Type.lookupSequenceType(name, local), XPath2SequenceType.Cardinality.ONE_OR_MORE);
        }
        if (local.endsWith("?")) {
            return XPath2SequenceType.create(XPath2Type.lookupSequenceType(name, local), XPath2SequenceType.Cardinality.OPTIONAL);
        }
        return ourMap.get(name);
    }

    public QName getQName() {
        return new QName(null, this.type);
    }

    private static XPathType lookupSequenceType(QName name, String local) {
        XPath2Type type = ourMap.get(new QName(name.getNamespaceURI(), local.substring(0, local.length() - 1)));
        return type != null ? type : UNKNOWN;
    }

    public static XPathType mapType(XPathType type) {
        if (type == XPathType.STRING) {
            type = STRING;
        } else if (type == XPathType.BOOLEAN) {
            type = BOOLEAN;
        } else if (type == XPathType.NUMBER) {
            type = NUMERIC;
        } else if (type == XPathType.NODESET) {
            type = XPath2SequenceType.create(NODE, XPath2SequenceType.Cardinality.ZERO_OR_MORE);
        }
        return type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/lang/xpath/psi/XPath2Type", "isAssignableFrom"));
    }

    public static class SchemaType
    extends XPath2Type {
        SchemaType(String name, XPathType superType) {
            super(name, superType);
        }

        @Override
        public String getName() {
            return "xs:" + super.getName();
        }

        @Override
        public QName getQName() {
            return new QName(XPath2Type.XMLSCHEMA_NS, this.type);
        }

        @Override
        public boolean isAbstract() {
            return this == NUMERIC;
        }

        public static List<XPath2Type> listSchemaTypes() {
            return ContainerUtil.filter(ourMap.values(), type1 -> type1.getQName().getNamespaceURI().equals(XPath2Type.XMLSCHEMA_NS) && !type1.isAbstract());
        }
    }

    public static class ItemType
    extends XPath2Type {
        ItemType(String name, XPathType superType) {
            super(name, superType);
        }

        @Override
        public boolean isAssignableFrom(@NotNull XPathType type) {
            if (type == null) {
                ItemType.$$$reportNull$$$0(0);
            }
            return super.isAssignableFrom(type) || type == NODESET || this == ITEM;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/intellij/lang/xpath/psi/XPath2Type$ItemType", "isAssignableFrom"));
        }
    }
}

