/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse.config;

import com.intellij.workspaceModel.ide.impl.jps.serialization.CustomModuleComponentSerializer;
import com.intellij.workspaceModel.ide.impl.jps.serialization.ErrorReporter;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentReader;
import com.intellij.workspaceModel.ide.impl.jps.serialization.JpsFileContentWriter;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageBuilder;
import com.intellij.workspaceModel.storage.WorkspaceEntityStorageDiffBuilder;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleCustomImlDataEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ModuleEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.eclipse.config.EclipseEntitiesKt;
import org.jetbrains.idea.eclipse.config.EclipseProjectPropertiesEntity;
import org.jetbrains.idea.eclipse.config.ModifiableEclipseProjectPropertiesEntity;
import org.jetbrains.jps.model.serialization.JDomSerializationUtil;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J8\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/idea/eclipse/config/EclipseModuleManagerSerializer;", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/CustomModuleComponentSerializer;", "()V", "loadComponent", "", "builder", "Lcom/intellij/workspaceModel/storage/WorkspaceEntityStorageBuilder;", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/ModuleEntity;", "reader", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentReader;", "imlFileUrl", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "errorReporter", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/ErrorReporter;", "virtualFileManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "saveComponent", "writer", "Lcom/intellij/workspaceModel/ide/impl/jps/serialization/JpsFileContentWriter;", "intellij.eclipse"})
public final class EclipseModuleManagerSerializer
implements CustomModuleComponentSerializer {
    public void loadComponent(@NotNull WorkspaceEntityStorageBuilder builder, @NotNull ModuleEntity moduleEntity, @NotNull JpsFileContentReader reader, @NotNull VirtualFileUrl imlFileUrl, @NotNull ErrorReporter errorReporter, @NotNull VirtualFileUrlManager virtualFileManager) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)virtualFileManager, (String)"virtualFileManager");
        Element element = JpsFileContentReader.DefaultImpls.loadComponent$default((JpsFileContentReader)reader, (String)imlFileUrl.getUrl(), (String)"EclipseModuleManager", null, (int)4, null);
        if (element == null) {
            return;
        }
        Element componentTag = element;
        EclipseProjectPropertiesEntity entity = EclipseEntitiesKt.addEclipseProjectPropertiesEntity((WorkspaceEntityStorageDiffBuilder)builder, moduleEntity, moduleEntity.getEntitySource());
        builder.modifyEntity(ModifiableEclipseProjectPropertiesEntity.class, (WorkspaceEntity)entity, (Function1)new Function1<ModifiableEclipseProjectPropertiesEntity, Unit>(componentTag, virtualFileManager){
            final /* synthetic */ Element $componentTag;
            final /* synthetic */ VirtualFileUrlManager $virtualFileManager;

            public final void invoke(@NotNull ModifiableEclipseProjectPropertiesEntity $this$modifyEntity) {
                boolean bl;
                Element it;
                T element$iv;
                Intrinsics.checkNotNullParameter((Object)((Object)$this$modifyEntity), (String)"$receiver");
                List list = this.$componentTag.getChildren("libelement");
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"componentTag.getChildren(LIBELEMENT)");
                Object $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it = (Element)element$iv;
                    boolean bl2 = false;
                    Set<VirtualFileUrl> set = $this$modifyEntity.getEclipseUrls();
                    String string = it.getAttributeValue("value");
                    Intrinsics.checkNotNull((Object)string);
                    set.add(this.$virtualFileManager.fromUrl(string));
                }
                List list2 = this.$componentTag.getChildren("varelement");
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"componentTag.getChildren(VARELEMENT)");
                $this$forEach$iv = list2;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it = (Element)element$iv;
                    boolean bl3 = false;
                    Map<String, String> map = $this$modifyEntity.getVariablePaths();
                    String string = it.getAttributeValue("var");
                    Intrinsics.checkNotNull((Object)string);
                    map.put(string, it.getAttributeValue("kind", "") + it.getAttributeValue("value"));
                }
                List list3 = this.$componentTag.getChildren("conelement");
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"componentTag.getChildren(CONELEMENT)");
                $this$forEach$iv = list3;
                $i$f$forEach = false;
                iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    element$iv = iterator.next();
                    it = (Element)element$iv;
                    boolean bl4 = false;
                    Set<String> set = $this$modifyEntity.getUnknownCons();
                    String string = it.getAttributeValue("value");
                    Intrinsics.checkNotNull((Object)string);
                    set.add(string);
                }
                String string = this.$componentTag.getAttributeValue("forced_jdk");
                if (string != null) {
                    $this$forEach$iv = string;
                    $i$f$forEach = false;
                    bl = Boolean.parseBoolean((String)$this$forEach$iv);
                } else {
                    bl = false;
                }
                $this$modifyEntity.setForceConfigureJdk(bl);
                Element srcDescriptionTag = this.$componentTag.getChild("src_description");
                if (srcDescriptionTag != null) {
                    int n;
                    String string2 = srcDescriptionTag.getAttributeValue("expected_position");
                    if (string2 != null) {
                        String $i$f$forEach2 = string2;
                        boolean bl5 = false;
                        n = Integer.parseInt($i$f$forEach2);
                    } else {
                        n = 0;
                    }
                    $this$modifyEntity.setExpectedModuleSourcePlace(n);
                    List list4 = srcDescriptionTag.getChildren("src_folder");
                    Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"srcDescriptionTag.getChildren(SRC_FOLDER)");
                    Iterable $this$forEach$iv2 = list4;
                    boolean $i$f$forEach3 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String string3;
                        Element it2 = (Element)element$iv2;
                        boolean bl6 = false;
                        Map<String, Integer> map = $this$modifyEntity.getSrcPlace();
                        String string4 = it2.getAttributeValue("value");
                        Intrinsics.checkNotNull((Object)string4);
                        Intrinsics.checkNotNull((Object)it2.getAttributeValue("expected_position"));
                        boolean bl7 = false;
                        map.put(string4, Integer.parseInt(string3));
                    }
                }
            }
            {
                this.$componentTag = element;
                this.$virtualFileManager = virtualFileUrlManager;
                super(1);
            }
        });
    }

    public void saveComponent(@NotNull ModuleEntity moduleEntity, @NotNull VirtualFileUrl imlFileUrl, @NotNull JpsFileContentWriter writer) {
        Object it;
        Map moduleOptions;
        Intrinsics.checkNotNullParameter((Object)moduleEntity, (String)"moduleEntity");
        Intrinsics.checkNotNullParameter((Object)imlFileUrl, (String)"imlFileUrl");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ModuleCustomImlDataEntity moduleCustomImlDataEntity = moduleEntity.getCustomImlData();
        Map map = moduleOptions = moduleCustomImlDataEntity != null ? moduleCustomImlDataEntity.getCustomModuleOptions() : null;
        if (moduleOptions != null && Intrinsics.areEqual((Object)((String)moduleOptions.get("classpath")), (Object)"eclipse")) {
            return;
        }
        EclipseProjectPropertiesEntity eclipseProperties = EclipseEntitiesKt.getEclipseProperties(moduleEntity);
        if (eclipseProperties == null || eclipseProperties.getEclipseUrls().isEmpty() && eclipseProperties.getVariablePaths().isEmpty() && !eclipseProperties.getForceConfigureJdk() && eclipseProperties.getUnknownCons().isEmpty()) {
            return;
        }
        Element componentTag = JDomSerializationUtil.createComponentElement((String)"EclipseModuleManager");
        Iterable $this$forEach$iv = eclipseProperties.getEclipseUrls();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (VirtualFileUrl)element$iv;
            boolean bl = false;
            componentTag.addContent(new Element("libelement").setAttribute("value", it.getUrl()));
        }
        eclipseProperties.getVariablePaths().forEach(new BiConsumer<String, String>(componentTag){
            final /* synthetic */ Element $componentTag;

            public final void accept(@NotNull String name, @NotNull String path) {
                String string;
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                    Intrinsics.checkNotNullParameter((Object)path, (String)"path");
                    Iterable $this$firstOrNull$iv = CollectionsKt.listOf((Object[])new String[]{"src:", "linksrc:", "link:"});
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        String it = (String)element$iv;
                        boolean bl = false;
                        if (!StringsKt.startsWith$default((String)name, (String)it, (boolean)false, (int)2, null)) continue;
                        v0 = element$iv;
                        break block3;
                    }
                    v0 = null;
                }
                if ((string = (String)v0) == null) {
                    string = "";
                }
                String prefix = string;
                Element varTag = new Element("varelement");
                varTag.setAttribute("var", StringsKt.removePrefix((String)name, (CharSequence)prefix));
                if (Intrinsics.areEqual((Object)prefix, (Object)"") ^ true) {
                    varTag.setAttribute("kind", prefix);
                }
                varTag.setAttribute("value", path);
                this.$componentTag.addContent(varTag);
            }
            {
                this.$componentTag = element;
            }
        });
        $this$forEach$iv = eclipseProperties.getUnknownCons();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            componentTag.addContent(new Element("conelement").setAttribute("value", (String)it));
        }
        if (eclipseProperties.getForceConfigureJdk()) {
            componentTag.setAttribute("forced_jdk", String.valueOf(true));
        }
        Element srcDescriptionTag = new Element("src_description");
        srcDescriptionTag.setAttribute("expected_position", String.valueOf(eclipseProperties.getExpectedModuleSourcePlace()));
        eclipseProperties.getSrcPlace().forEach(new BiConsumer<String, Integer>(srcDescriptionTag){
            final /* synthetic */ Element $srcDescriptionTag;

            public final void accept(@NotNull String url, @NotNull Integer position) {
                Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                Intrinsics.checkNotNullParameter((Object)position, (String)"position");
                this.$srcDescriptionTag.addContent(new Element("src_folder").setAttribute("value", url).setAttribute("expected_position", String.valueOf(position)));
            }
            {
                this.$srcDescriptionTag = element;
            }
        });
        componentTag.addContent(srcDescriptionTag);
        writer.saveComponent(imlFileUrl.getUrl(), "EclipseModuleManager", componentTag);
    }
}

