/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.annotation.Nonnull;
import org.fest.assertions.Description;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.edt.GuiLazyLoadingDescription;
import org.fest.swing.format.Formatting;
import org.fest.swing.query.ComponentEnabledQuery;
import org.fest.swing.timing.Condition;
import org.fest.util.Preconditions;
import org.fest.util.Strings;

class ComponentEnabledCondition
extends Condition {
    private Component c;

    @Nonnull
    static ComponentEnabledCondition untilIsEnabled(@Nonnull Component c) {
        return new ComponentEnabledCondition(c);
    }

    private ComponentEnabledCondition(@Nonnull Component c) {
        super(ComponentEnabledCondition.description(c));
        this.c = c;
    }

    @Nonnull
    private static Description description(final @Nonnull Component c) {
        return new GuiLazyLoadingDescription(){

            @Override
            @Nonnull
            protected String loadDescription() {
                return Strings.concat((Object[])new Object[]{Formatting.format(c), " to be enabled"});
            }
        };
    }

    @Override
    @RunsInEDT
    public boolean test() {
        return ComponentEnabledQuery.isEnabled((Component)Preconditions.checkNotNull((Object)this.c));
    }

    @Override
    protected void done() {
        this.c = null;
    }
}

