/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.query.ComponentVisibleQuery;
import org.fest.swing.timing.Pause;
import org.fest.swing.util.TimeoutWatch;

public final class ComponentShownWaiter
extends ComponentAdapter {
    private static final int DEFAULT_TIMEOUT = 5000;
    private static final int DEFAULT_SLEEP_TIME = 10;
    private Component toWaitFor;
    private volatile boolean shown;

    public static void waitTillShown(@Nonnull Component toWaitFor) {
        new ComponentShownWaiter(toWaitFor).startWaiting(5000L);
    }

    public static void waitTillShown(@Nonnull Component toWaitFor, long timeout) {
        new ComponentShownWaiter(toWaitFor).startWaiting(timeout);
    }

    private ComponentShownWaiter(@Nonnull Component toWaitFor) {
        this.toWaitFor = toWaitFor;
        toWaitFor.addComponentListener(this);
    }

    private void startWaiting(long timeout) {
        if (this.alreadyVisible()) {
            return;
        }
        TimeoutWatch watch = TimeoutWatch.startWatchWithTimeoutOf(timeout);
        while (!this.shown) {
            Pause.pause(10L);
            if (!watch.isTimeOut()) continue;
            this.done();
            throw new WaitTimedOutError("Timed out waiting for component to be visible");
        }
    }

    private boolean alreadyVisible() {
        if (!ComponentVisibleQuery.isVisible(this.toWaitFor)) {
            return false;
        }
        this.done();
        return true;
    }

    @Override
    @RunsInEDT
    public void componentShown(@Nullable ComponentEvent e) {
        this.shown = true;
        this.done();
    }

    private void done() {
        this.toWaitFor.removeComponentListener(this);
        this.toWaitFor = null;
    }
}

