/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComboBox;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.cell.JComboBoxCellReader;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.util.TextMatcher;
import org.fest.util.Preconditions;

final class JComboBoxMatchingItemQuery {
    @RunsInEDT
    static int matchingItemIndex(final @Nonnull JComboBox comboBox, final @Nonnull TextMatcher matcher, final @Nonnull JComboBoxCellReader cellReader) {
        Integer result = GuiActionRunner.execute(new GuiQuery<Integer>(){

            @Override
            @Nullable
            protected Integer executeInEDT() {
                int itemCount = comboBox.getItemCount();
                for (int i = 0; i < itemCount; ++i) {
                    String value = cellReader.valueAt(comboBox, i);
                    if (value == null || !matcher.isMatching(value)) continue;
                    return i;
                }
                return -1;
            }
        });
        return (Integer)Preconditions.checkNotNull((Object)result);
    }

    private JComboBoxMatchingItemQuery() {
    }
}

