/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.inspections.internal;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.uast.UastHintedVisitorAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;
import org.jetbrains.idea.devkit.inspections.DevKitUastInspectionBase;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.visitor.AbstractUastNonRecursiveVisitor;

public class UsePrimitiveTypesInspection
extends DevKitUastInspectionBase {
    @Override
    public PsiElementVisitor buildInternalVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UsePrimitiveTypesInspection.$$$reportNull$$$0(0);
        }
        if (JavaPsiFacade.getInstance((Project)holder.getProject()).findClass(PsiType.class.getName(), holder.getFile().getResolveScope()) == null) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        return UastHintedVisitorAdapter.create((Language)holder.getFile().getLanguage(), (AbstractUastNonRecursiveVisitor)new AbstractUastNonRecursiveVisitor(){

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                UsePrimitiveTypesInspection.inspectBinaryExpression(node, holder);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/idea/devkit/inspections/internal/UsePrimitiveTypesInspection$1", "visitBinaryExpression"));
            }
        }, (Class[])new Class[]{UBinaryExpression.class});
    }

    private static void inspectBinaryExpression(UBinaryExpression uBinaryExpression, ProblemsHolder holder) {
        UastBinaryOperator operator = uBinaryExpression.getOperator();
        if (operator != UastBinaryOperator.IDENTITY_EQUALS && operator != UastBinaryOperator.IDENTITY_NOT_EQUALS) {
            return;
        }
        UExpression lhs = uBinaryExpression.getLeftOperand();
        UExpression rhs = uBinaryExpression.getRightOperand();
        if (lhs instanceof ULiteralExpression || rhs instanceof ULiteralExpression || lhs instanceof UThisExpression || rhs instanceof UThisExpression) {
            return;
        }
        if (UsePrimitiveTypesInspection.isPrimitivePsiTypeReference(lhs) || UsePrimitiveTypesInspection.isPrimitivePsiTypeReference(rhs)) {
            PsiElement sourcePsi = uBinaryExpression.getSourcePsi();
            if (sourcePsi == null) {
                return;
            }
            holder.registerProblem(sourcePsi, DevKitBundle.message("inspections.use.primitive.types", new Object[0]), new LocalQuickFix[0]);
        }
    }

    private static boolean isPrimitivePsiTypeReference(UExpression uExpression) {
        if (!(uExpression instanceof UReferenceExpression)) {
            return false;
        }
        UReferenceExpression uReferenceExpression = (UReferenceExpression)uExpression;
        PsiElement resolve = uReferenceExpression.resolve();
        if (resolve instanceof PsiField) {
            PsiField psiField = (PsiField)resolve;
            if (!psiField.hasModifierProperty("static") || !psiField.hasModifierProperty("final")) {
                return false;
            }
            PsiClass containingClass = psiField.getContainingClass();
            return containingClass != null && PsiType.class.getName().equals(containingClass.getQualifiedName()) && !"NULL".equals(psiField.getName());
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/idea/devkit/inspections/internal/UsePrimitiveTypesInspection", "buildInternalVisitor"));
    }
}

