/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.internal;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.ExpectedHighlightingData;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.devkit.DevKitBundle;

public class DumpCleanHighlightingTestdataAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance(DumpCleanHighlightingTestdataAction.class);

    public void actionPerformed(@NotNull AnActionEvent e) {
        VirtualFile virtualFile;
        if (e == null) {
            DumpCleanHighlightingTestdataAction.$$$reportNull$$$0(0);
        }
        Project project = e.getProject();
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile != null && (virtualFile = psiFile.getVirtualFile()) != null) {
            Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
            if (document != null) {
                ExpectedHighlightingData data = new ExpectedHighlightingData(document, true, true);
                data.init();
            }
            return;
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        descriptor.setTitle(DevKitBundle.message("action.DumpCleanTestData.file.chooser.title", new Object[0]));
        descriptor.setDescription(DevKitBundle.message("action.DumpCleanTestData.file.chooser.source.description", new Object[0]));
        VirtualFile dirToProcess = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (dirToProcess != null) {
            LOG.assertTrue(project != null);
            FileChooserDescriptor targetDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            targetDescriptor.setTitle(DevKitBundle.message("action.DumpCleanTestData.file.chooser.title", new Object[0]));
            targetDescriptor.setDescription(DevKitBundle.message("action.DumpCleanTestData.file.chooser.destination.description", new Object[0]));
            VirtualFile destinationFolder = FileChooser.chooseFile((FileChooserDescriptor)targetDescriptor, (Project)project, null);
            if (dirToProcess.equals(destinationFolder)) {
                Messages.showErrorDialog((Project)project, (String)DevKitBundle.message("action.DumpCleanTestData.error.source.destination.must.differ", new Object[0]), (String)CommonBundle.getErrorTitle());
                return;
            }
            if (destinationFolder != null) {
                VirtualFile[] files;
                File destination = VfsUtilCore.virtualToIoFile((VirtualFile)destinationFolder);
                for (VirtualFile virtualFile2 : files = dirToProcess.getChildren()) {
                    Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
                    if (document == null) continue;
                    ExpectedHighlightingData data = new ExpectedHighlightingData(document, true, true);
                    data.init();
                    File file = new File(destination, virtualFile2.getName());
                    try {
                        FileUtil.writeToFile((File)file, (String)document.getText());
                    }
                    catch (IOException ex) {
                        LOG.error((Throwable)ex);
                    }
                }
            }
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            DumpCleanHighlightingTestdataAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "e";
        objectArray2[1] = "org/jetbrains/idea/devkit/internal/DumpCleanHighlightingTestdataAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

