/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.navigation;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ProjectExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlTag;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.dom.ExtensionPoint;
import org.jetbrains.idea.devkit.dom.index.ExtensionPointIndex;
import org.jetbrains.idea.devkit.navigation.DevkitRelatedLineMarkerProviderBase;
import org.jetbrains.idea.devkit.navigation.LineMarkerInfoHelper;
import org.jetbrains.idea.devkit.util.ExtensionPointCandidate;
import org.jetbrains.idea.devkit.util.PluginRelatedLocatorsUtils;

public class ExtensionPointDeclarationRelatedItemLineMarkerProvider
extends DevkitRelatedLineMarkerProviderBase {
    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (element == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiField) {
            ExtensionPointDeclarationRelatedItemLineMarkerProvider.process((PsiField)element, result);
        }
    }

    private static void process(PsiField psiField, Collection<? super RelatedItemLineMarkerInfo<?>> result) {
        if (!ExtensionPointDeclarationRelatedItemLineMarkerProvider.isExtensionPointNameDeclarationField(psiField)) {
            return;
        }
        String epFqn = ExtensionPointDeclarationRelatedItemLineMarkerProvider.resolveEpFqn(psiField);
        if (epFqn == null) {
            return;
        }
        Project project = psiField.getProject();
        ExtensionPoint point = ExtensionPointIndex.findExtensionPoint(project, PluginRelatedLocatorsUtils.getCandidatesScope(project), epFqn);
        if (point == null) {
            return;
        }
        ExtensionPointCandidate candidate = new ExtensionPointCandidate((SmartPsiElementPointer<XmlTag>)SmartPointerManager.createPointer((PsiElement)point.getXmlTag()), epFqn);
        RelatedItemLineMarkerInfo<PsiElement> info = LineMarkerInfoHelper.createExtensionPointLineMarkerInfo(Collections.singletonList(candidate), (PsiElement)psiField.getNameIdentifier());
        result.add(info);
    }

    @Nullable
    private static String resolveEpFqn(PsiField psiField) {
        PsiExpression initializer = psiField.getInitializer();
        PsiExpressionList expressionList = null;
        if (initializer instanceof PsiMethodCallExpression) {
            expressionList = ((PsiMethodCallExpression)initializer).getArgumentList();
        } else if (initializer instanceof PsiNewExpression) {
            expressionList = ((PsiNewExpression)initializer).getArgumentList();
        }
        if (expressionList == null) {
            return null;
        }
        PsiExpression[] expressions = expressionList.getExpressions();
        if (expressions.length != 1) {
            return null;
        }
        PsiExpression epNameExpression = expressions[0];
        PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)psiField.getProject()).getConstantEvaluationHelper();
        Object o = helper.computeConstantExpression((PsiElement)epNameExpression);
        return o instanceof String ? (String)o : null;
    }

    private static boolean isExtensionPointNameDeclarationField(PsiField psiField) {
        if (!psiField.hasModifierProperty("final") || !psiField.hasModifierProperty("static") || psiField.hasModifierProperty("abstract")) {
            return false;
        }
        if (!psiField.hasInitializer()) {
            return false;
        }
        PsiExpression initializer = psiField.getInitializer();
        if (!(initializer instanceof PsiMethodCallExpression) && !(initializer instanceof PsiNewExpression)) {
            return false;
        }
        PsiClass fieldClass = PsiTypesUtil.getPsiClass((PsiType)psiField.getType());
        if (fieldClass == null) {
            return false;
        }
        String qualifiedClassName = fieldClass.getQualifiedName();
        return ExtensionPointName.class.getName().equals(qualifiedClassName) || ProjectExtensionPointName.class.getName().equals(qualifiedClassName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "element";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/devkit/navigation/ExtensionPointDeclarationRelatedItemLineMarkerProvider";
        objectArray[2] = "collectNavigationMarkers";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

