/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.testAssistant;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.testFramework.PlatformTestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.devkit.testAssistant.TestDataFile;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByExistingFilesUtil;
import org.jetbrains.idea.devkit.testAssistant.TestDataGuessByTestDiscoveryUtil;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.evaluation.SimpleEvaluatorExtension;
import org.jetbrains.uast.evaluation.UEvaluationContextKt;
import org.jetbrains.uast.evaluation.UEvaluatorExtension;
import org.jetbrains.uast.values.UBooleanConstant;
import org.jetbrains.uast.values.UConstant;
import org.jetbrains.uast.values.UStringConstant;
import org.jetbrains.uast.values.UValue;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public class TestDataReferenceCollector {
    private static final String TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME = "com.intellij.testFramework.TestDataFile";
    private final String myTestDataPath;
    private final String myTestName;
    private final List<String> myLogMessages = new ArrayList<String>();
    private PsiClass myContainingClass;
    private boolean myFoundTestDataParameters = false;

    public TestDataReferenceCollector(@Nullable String testDataPath, String testName) {
        if (StringUtil.isNotEmpty((String)testDataPath) && !StringUtil.endsWithChar((CharSequence)testDataPath, (char)'/')) {
            testDataPath = (String)testDataPath + "/";
        }
        this.myTestDataPath = testDataPath;
        this.myTestName = testName;
    }

    @NotNull
    List<TestDataFile> collectTestDataReferences(@NotNull PsiMethod method) {
        if (method == null) {
            TestDataReferenceCollector.$$$reportNull$$$0(0);
        }
        List<TestDataFile> list = this.collectTestDataReferences(method, true);
        if (list == null) {
            TestDataReferenceCollector.$$$reportNull$$$0(1);
        }
        return list;
    }

    @NotNull
    List<TestDataFile> collectTestDataReferences(@NotNull PsiMethod method, boolean collectByExistingFiles) {
        if (method == null) {
            TestDataReferenceCollector.$$$reportNull$$$0(2);
        }
        this.myContainingClass = (PsiClass)ReadAction.compute(() -> method.getContainingClass());
        List<TestDataFile> result = this.collectTestDataReferences(method, new HashMap<String, Computable<UValue>>(), new HashSet<Pair<PsiMethod, Set<UExpression>>>());
        if (!this.myFoundTestDataParameters) {
            this.myLogMessages.add("Found no parameters annotated with @TestDataFile");
        }
        if (collectByExistingFiles && result.isEmpty()) {
            result = new ArrayList<TestDataFile>();
            result.addAll(TestDataGuessByExistingFilesUtil.collectTestDataByExistingFiles(method, this.myTestDataPath));
            result.addAll(TestDataGuessByTestDiscoveryUtil.collectTestDataByExistingFiles(method));
        }
        List<TestDataFile> list = result;
        if (list == null) {
            TestDataReferenceCollector.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    private List<TestDataFile> collectTestDataReferences(PsiMethod method, final Map<String, Computable<UValue>> argumentMap, final HashSet<Pair<PsiMethod, Set<UExpression>>> proceed) {
        final ArrayList<TestDataFile> result = new ArrayList<TestDataFile>();
        if (this.myTestDataPath == null) {
            ArrayList<TestDataFile> arrayList = result;
            if (arrayList == null) {
                TestDataReferenceCollector.$$$reportNull$$$0(4);
            }
            return arrayList;
        }
        List list = (List)ReadAction.compute(() -> {
            UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method);
            if (uMethod == null) {
                return result;
            }
            uMethod.accept((UastVisitor)new AbstractUastVisitor(){

                public boolean visitCallExpression(@NotNull UCallExpression expression) {
                    UMethod implementation;
                    PsiClass calleeContainingClass;
                    String callText;
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((callText = expression.getMethodName()) == null) {
                        return true;
                    }
                    UMethod callee = (UMethod)UastContextKt.toUElement((PsiElement)expression.resolve(), UMethod.class);
                    if (callee != null && callee.hasModifierProperty("abstract") && (calleeContainingClass = callee.getContainingClass()) != null && TestDataReferenceCollector.this.myContainingClass.isInheritor(calleeContainingClass, true) && (implementation = (UMethod)UastContextKt.toUElement((PsiElement)TestDataReferenceCollector.this.myContainingClass.findMethodBySignature((PsiMethod)callee, true), UMethod.class)) != null) {
                        callee = implementation;
                    }
                    Pair methodWithArguments = new Pair((Object)callee, new HashSet(expression.getValueArguments()));
                    if (callee != null && proceed.add(methodWithArguments)) {
                        boolean haveAnnotatedParameters = false;
                        PsiParameter[] psiParameters = callee.getParameterList().getParameters();
                        int psiParametersLength = psiParameters.length;
                        for (int i = 0; i < psiParametersLength; ++i) {
                            PsiParameter psiParameter = psiParameters[i];
                            PsiModifierList modifierList = psiParameter.getModifierList();
                            if (modifierList == null || !modifierList.hasAnnotation(TestDataReferenceCollector.TEST_DATA_FILE_ANNOTATION_QUALIFIED_NAME)) continue;
                            TestDataReferenceCollector.this.myFoundTestDataParameters = true;
                            if (psiParameter.isVarArgs()) {
                                this.processVarargCallArgument(expression, argumentMap, result);
                            } else {
                                this.processCallArgument(expression, argumentMap, result, i);
                            }
                            haveAnnotatedParameters = true;
                        }
                        if (expression.getReceiver() == null && !haveAnnotatedParameters) {
                            result.addAll(TestDataReferenceCollector.this.collectTestDataReferences((PsiMethod)callee, TestDataReferenceCollector.this.buildArgumentMap(expression, (PsiMethod)callee), proceed));
                        }
                    }
                    return true;
                }

                private void processCallArgument(UCallExpression expression, Map<String, Computable<UValue>> argumentMap2, Collection<TestDataFile> result2, int index) {
                    List arguments = expression.getValueArguments();
                    if (arguments.size() > index) {
                        this.handleArgument((UExpression)arguments.get(index), argumentMap2, result2);
                    }
                }

                private void processVarargCallArgument(UCallExpression expression, Map<String, Computable<UValue>> argumentMap2, Collection<TestDataFile> result2) {
                    List arguments = expression.getValueArguments();
                    for (UExpression argument : arguments) {
                        this.handleArgument(argument, argumentMap2, result2);
                    }
                }

                private void handleArgument(UExpression argument, Map<String, Computable<UValue>> argumentMap2, Collection<TestDataFile> result2) {
                    UValue testDataFileValue = UEvaluationContextKt.uValueOf((UExpression)argument, (UEvaluatorExtension[])new UEvaluatorExtension[]{new TestDataEvaluatorExtension(argumentMap2)});
                    if (testDataFileValue instanceof UStringConstant) {
                        result2.add(new TestDataFile.LazyResolved(TestDataReferenceCollector.this.myTestDataPath + ((UStringConstant)testDataFileValue).getValue()));
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector$1", "visitCallExpression"));
                }
            });
            return result;
        });
        if (list == null) {
            TestDataReferenceCollector.$$$reportNull$$$0(5);
        }
        return list;
    }

    private Map<String, Computable<UValue>> buildArgumentMap(UCallExpression expression, PsiMethod method) {
        HashMap<String, Computable<UValue>> result = new HashMap<String, Computable<UValue>>();
        PsiParameter[] parameters = method.getParameterList().getParameters();
        List arguments = expression.getValueArguments();
        for (int i = 0; i < arguments.size() && i < parameters.length; ++i) {
            int finalI = i;
            result.put(parameters[i].getName(), (Computable<UValue>)((NullableComputable)() -> UEvaluationContextKt.uValueOf((UExpression)((UExpression)arguments.get(finalI)), (UEvaluatorExtension[])new UEvaluatorExtension[]{new TestDataEvaluatorExtension(Collections.emptyMap())})));
        }
        return result;
    }

    public String getLog() {
        return StringUtil.join(this.myLogMessages, (String)"\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTestDataReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTestDataReferences";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class TestDataEvaluatorExtension
    extends SimpleEvaluatorExtension {
        private final Map<String, Computable<UValue>> myArguments;

        private TestDataEvaluatorExtension(Map<String, Computable<UValue>> arguments) {
            this.myArguments = arguments;
        }

        public Object evaluateMethodCall(@NotNull PsiMethod target, @NotNull List<? extends UValue> argumentValues) {
            if (target == null) {
                TestDataEvaluatorExtension.$$$reportNull$$$0(0);
            }
            if (argumentValues == null) {
                TestDataEvaluatorExtension.$$$reportNull$$$0(1);
            }
            if (target.getName().equals("getTestName") && argumentValues.size() == 1) {
                boolean lowercaseArgValue;
                UValue lowercaseArg = argumentValues.get(0);
                boolean bl = lowercaseArgValue = lowercaseArg instanceof UBooleanConstant && ((UBooleanConstant)lowercaseArg).getValue() != false;
                if (lowercaseArgValue && !StringUtil.isEmpty((String)TestDataReferenceCollector.this.myTestName)) {
                    return PlatformTestUtil.lowercaseFirstLetter((String)TestDataReferenceCollector.this.myTestName, (boolean)true);
                }
                return TestDataReferenceCollector.this.myTestName;
            }
            return super.evaluateMethodCall(target, argumentValues);
        }

        public Object evaluateVariable(@NotNull UVariable variable) {
            Computable<UValue> value;
            if (variable == null) {
                TestDataEvaluatorExtension.$$$reportNull$$$0(2);
            }
            if (variable instanceof UParameter && (value = this.myArguments.get(variable.getName())) != null) {
                UValue computedValue = (UValue)value.compute();
                UConstant constant = computedValue.toConstant();
                return constant != null ? constant.getValue() : super.evaluateVariable(variable);
            }
            return super.evaluateVariable(variable);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "argumentValues";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/devkit/testAssistant/TestDataReferenceCollector$TestDataEvaluatorExtension";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateMethodCall";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "evaluateVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

