/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.devkit.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.ui.components.JBList;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.devkit.util.DescriptorUtil;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UResolvable;
import org.jetbrains.uast.UResolvableKt;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.UastContextKt;

public final class PsiUtil {
    private static final Key<Boolean> IDEA_PROJECT = Key.create((String)"idea.internal.inspections.enabled");
    @NonNls
    private static final String IDE_PROJECT_MARKER_CLASS = JBList.class.getName();
    @NonNls
    private static final String[] IDEA_PROJECT_MARKER_FILES = new String[]{"idea.iml", "community-main.iml", "intellij.idea.community.main.iml", "intellij.idea.ultimate.main.iml"};

    private PsiUtil() {
    }

    public static boolean isInstantiable(@NotNull PsiClass cls) {
        PsiModifierList modList;
        if (cls == null) {
            PsiUtil.$$$reportNull$$$0(0);
        }
        if ((modList = cls.getModifierList()) == null || cls.isInterface() || modList.hasModifierProperty("abstract") || !PsiUtil.isPublicOrStaticInnerClass(cls)) {
            return false;
        }
        PsiMethod[] constructors = cls.getConstructors();
        if (constructors.length == 0) {
            return true;
        }
        for (PsiMethod constructor : constructors) {
            if (!constructor.getParameterList().isEmpty() || !constructor.hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    public static boolean isPublicOrStaticInnerClass(@NotNull PsiClass cls) {
        PsiModifierList modifiers;
        if (cls == null) {
            PsiUtil.$$$reportNull$$$0(1);
        }
        if ((modifiers = cls.getModifierList()) == null) {
            return false;
        }
        return modifiers.hasModifierProperty("public") && (cls.getContainingClass() == null || modifiers.hasModifierProperty("static"));
    }

    @Nullable
    public static PsiMethod findNearestMethod(String name, @Nullable PsiClass cls) {
        if (cls == null) {
            return null;
        }
        for (PsiMethod method : cls.findMethodsByName(name, false)) {
            if (!method.getParameterList().isEmpty()) continue;
            return method.getModifierList().hasModifierProperty("abstract") ? null : method;
        }
        return PsiUtil.findNearestMethod(name, cls.getSuperClass());
    }

    @Nullable
    public static PsiAnnotation findAnnotation(Class<?> annotationClass, PsiMember ... members) {
        for (PsiMember member : members) {
            PsiAnnotation annotation;
            if (member == null || (annotation = member.getAnnotation(annotationClass.getName())) == null) continue;
            return annotation;
        }
        return null;
    }

    @Nullable
    public static String getAnnotationStringAttribute(PsiAnnotation annotation, String name, String defaultValueIfEmpty) {
        String value = AnnotationUtil.getDeclaredStringAttributeValue((PsiAnnotation)annotation, (String)name);
        return StringUtil.defaultIfEmpty((String)value, (String)defaultValueIfEmpty);
    }

    public static boolean getAnnotationBooleanAttribute(PsiAnnotation annotation, String name) {
        return (Boolean)ObjectUtils.notNull((Object)AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)annotation, (String)name), (Object)Boolean.FALSE);
    }

    public static boolean isIdeaProject(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        Boolean flag = (Boolean)project.getUserData(IDEA_PROJECT);
        if (flag == null) {
            flag = PsiUtil.checkIdeaProject(project);
            project.putUserData(IDEA_PROJECT, (Object)flag);
        }
        return flag;
    }

    @Nullable
    public static UExpression getReturnedExpression(PsiMethod method) {
        UMethod uMethod = (UMethod)UastContextKt.toUElement((PsiElement)method, UMethod.class);
        if (uMethod == null) {
            return null;
        }
        UExpression uBody = uMethod.getUastBody();
        if (!(uBody instanceof UBlockExpression)) {
            return null;
        }
        List expressions = ((UBlockExpression)uBody).getExpressions();
        UExpression singleExpression = (UExpression)ContainerUtil.getOnlyItem((Collection)expressions);
        if (singleExpression == null) {
            return null;
        }
        if (!(singleExpression instanceof UReturnExpression)) {
            return null;
        }
        UReturnExpression uReturnExpression = (UReturnExpression)singleExpression;
        UExpression returnValue = uReturnExpression.getReturnExpression();
        if (returnValue == null) {
            return null;
        }
        if (returnValue instanceof UReferenceExpression) {
            UReferenceExpression referenceExpression = (UReferenceExpression)returnValue;
            UElement uElement = UResolvableKt.resolveToUElement((UResolvable)referenceExpression);
            UField uField = (UField)ObjectUtils.tryCast((Object)uElement, UField.class);
            if (uField != null && uField.isFinal()) {
                return uField.getUastInitializer();
            }
            return (UExpression)ObjectUtils.tryCast((Object)uElement, UExpression.class);
        }
        if (returnValue instanceof UCallExpression) {
            UCallExpression uCallExpression = (UCallExpression)returnValue;
            PsiMethod psiMethod = uCallExpression.resolve();
            if (psiMethod == null) {
                return null;
            }
            return PsiUtil.getReturnedExpression(psiMethod);
        }
        return returnValue;
    }

    public static boolean isPluginProject(@NotNull Project project) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(2);
        }
        return (Boolean)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.allScope((Project)project)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)project));
        });
    }

    public static boolean isPluginModule(@NotNull Module module) {
        if (module == null) {
            PsiUtil.$$$reportNull$$$0(3);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            boolean foundMarkerClass = JavaPsiFacade.getInstance((Project)module.getProject()).findClass(IDE_PROJECT_MARKER_CLASS, GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)false)) != null;
            return CachedValueProvider.Result.createSingleDependency((Object)foundMarkerClass, (Object)ProjectRootManager.getInstance((Project)module.getProject()));
        });
    }

    private static boolean isIntelliJBasedDir(VirtualFile baseDir) {
        if (baseDir == null) {
            return false;
        }
        for (VirtualFile dir : new VirtualFile[]{baseDir, baseDir.findChild("community"), baseDir.findChild("ultimate")}) {
            if (dir == null || !dir.isDirectory()) continue;
            for (String fileName : IDEA_PROJECT_MARKER_FILES) {
                if (dir.findChild(fileName) == null) continue;
                return true;
            }
        }
        return false;
    }

    @TestOnly
    public static void markAsIdeaProject(@NotNull Project project, boolean value) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(4);
        }
        project.putUserData(IDEA_PROJECT, (Object)value);
    }

    private static boolean checkIdeaProject(@NotNull Project project) {
        if (project == null) {
            PsiUtil.$$$reportNull$$$0(5);
        }
        if (!PsiUtil.isIntelliJBasedDir(project.getBaseDir())) {
            return false;
        }
        return (Boolean)DumbService.getInstance((Project)project).computeWithAlternativeResolveEnabled(() -> {
            GlobalSearchScope scope = GlobalSearchScopesCore.projectProductionScope((Project)project);
            return JavaPsiFacade.getInstance((Project)project).findClass(IDE_PROJECT_MARKER_CLASS, scope) != null;
        });
    }

    public static boolean isPluginXmlPsiElement(@NotNull PsiElement element) {
        if (element == null) {
            PsiUtil.$$$reportNull$$$0(6);
        }
        return PsiUtil.isPluginProject(element.getProject()) && DescriptorUtil.isPluginXml(element.getContainingFile());
    }

    public static boolean isPathToIntelliJIdeaSources(String path) {
        for (String file : IDEA_PROJECT_MARKER_FILES) {
            if (!new File(path, file).isFile()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cls";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/devkit/util/PsiUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isInstantiable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isPublicOrStaticInnerClass";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPluginProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isPluginModule";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "markAsIdeaProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIdeaProject";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isPluginXmlPsiElement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

