/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.checkers.utils;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingContextUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.WritableSlice;

public class DebugInfoUtil {
    private static final TokenSet MAY_BE_UNRESOLVED = TokenSet.create((IElementType[])new IElementType[]{KtTokens.IN_KEYWORD, KtTokens.NOT_IN});
    private static final TokenSet EXCLUDED = TokenSet.create((IElementType[])new IElementType[]{KtTokens.COLON, KtTokens.AS_KEYWORD, KtTokens.AS_SAFE, KtTokens.IS_KEYWORD, KtTokens.NOT_IS, KtTokens.OROR, KtTokens.ANDAND, KtTokens.EQ, KtTokens.EQEQEQ, KtTokens.EXCLEQEQEQ, KtTokens.ELVIS, KtTokens.EXCLEXCL});

    public static void markDebugAnnotations(@NotNull PsiElement root2, final @NotNull BindingContext bindingContext, final @NotNull DebugInfoReporter debugInfoReporter) {
        if (root2 == null) {
            DebugInfoUtil.$$$reportNull$$$0(0);
        }
        if (bindingContext == null) {
            DebugInfoUtil.$$$reportNull$$$0(1);
        }
        if (debugInfoReporter == null) {
            DebugInfoUtil.$$$reportNull$$$0(2);
        }
        final HashMap markedWithErrorElements = new HashMap();
        for (Diagnostic diagnostic : bindingContext.getDiagnostics()) {
            DiagnosticFactory<?> factory2 = diagnostic.getFactory();
            if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains(diagnostic.getFactory())) {
                markedWithErrorElements.put((KtReferenceExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 == Errors.SUPER_IS_NOT_AN_EXPRESSION || factory2 == Errors.SUPER_NOT_AVAILABLE) {
                KtSuperExpression superExpression = (KtSuperExpression)diagnostic.getPsiElement();
                markedWithErrorElements.put(superExpression.getInstanceReference(), factory2);
                continue;
            }
            if (factory2 == Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                markedWithErrorElements.put((KtSimpleNameExpression)diagnostic.getPsiElement(), factory2);
                continue;
            }
            if (factory2 != Errors.UNSUPPORTED) continue;
            for (KtReferenceExpression reference : PsiTreeUtil.findChildrenOfType((PsiElement)diagnostic.getPsiElement(), KtReferenceExpression.class)) {
                markedWithErrorElements.put(reference, factory2);
            }
        }
        root2.acceptChildren((PsiElementVisitor)new KtTreeVisitorVoid(){

            @Override
            public void visitForExpression(@NotNull KtForExpression expression2) {
                if (expression2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                KtExpression range = expression2.getLoopRange();
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_ITERATOR_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_HAS_NEXT_RESOLVED_CALL);
                this.reportIfDynamicCall(range, range, BindingContext.LOOP_RANGE_NEXT_RESOLVED_CALL);
                super.visitForExpression(expression2);
            }

            @Override
            public void visitDestructuringDeclaration(@NotNull KtDestructuringDeclaration destructuringDeclaration) {
                if (destructuringDeclaration == null) {
                    1.$$$reportNull$$$0(1);
                }
                for (KtDestructuringDeclarationEntry entry : destructuringDeclaration.getEntries()) {
                    this.reportIfDynamicCall(entry, entry, BindingContext.COMPONENT_RESOLVED_CALL);
                }
                super.visitDestructuringDeclaration(destructuringDeclaration);
            }

            @Override
            public void visitProperty(@NotNull KtProperty property2) {
                VariableDescriptor descriptor2;
                if (property2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((descriptor2 = bindingContext.get(BindingContext.VARIABLE, property2)) instanceof PropertyDescriptor && property2.getDelegate() != null) {
                    PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor2;
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor, BindingContext.PROVIDE_DELEGATE_RESOLVED_CALL);
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor.getGetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                    this.reportIfDynamicCall(property2.getDelegate(), propertyDescriptor.getSetter(), BindingContext.DELEGATED_PROPERTY_RESOLVED_CALL);
                }
                super.visitProperty(property2);
            }

            @Override
            public void visitThisExpression(@NotNull KtThisExpression expression2) {
                ResolvedCall<? extends CallableDescriptor> resolvedCall2;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if ((resolvedCall2 = CallUtilKt.getResolvedCall(expression2, bindingContext)) != null) {
                    DebugInfoUtil.reportIfDynamic(expression2, resolvedCall2.getResultingDescriptor(), debugInfoReporter);
                }
                super.visitThisExpression(expression2);
            }

            @Override
            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Collection<? extends PsiElement> labelTargets;
                Collection<? extends DeclarationDescriptor> declarationDescriptors;
                PsiElement labelTarget;
                if (expression2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                super.visitReferenceExpression(expression2);
                if (!BindingContextUtils.isExpressionWithValidReference(expression2, bindingContext)) {
                    return;
                }
                IElementType referencedNameElementType = null;
                if (expression2 instanceof KtSimpleNameExpression) {
                    KtSimpleNameExpression nameExpression = (KtSimpleNameExpression)expression2;
                    IElementType elementType = expression2.getNode().getElementType();
                    if (elementType == KtNodeTypes.OPERATION_REFERENCE) {
                        referencedNameElementType = nameExpression.getReferencedNameElementType();
                        if (EXCLUDED.contains(referencedNameElementType)) {
                            return;
                        }
                    }
                    if (elementType == KtNodeTypes.LABEL || nameExpression.getReferencedNameElementType() == KtTokens.THIS_KEYWORD) {
                        return;
                    }
                }
                debugInfoReporter.preProcessReference(expression2);
                String target = null;
                DeclarationDescriptor declarationDescriptor = bindingContext.get(BindingContext.REFERENCE_TARGET, expression2);
                if (declarationDescriptor != null) {
                    target = declarationDescriptor.toString();
                    DebugInfoUtil.reportIfDynamic(expression2, declarationDescriptor, debugInfoReporter);
                }
                if (target == null && (labelTarget = bindingContext.get(BindingContext.LABEL_TARGET, expression2)) != null) {
                    target = labelTarget.getText();
                }
                if (target == null && (declarationDescriptors = bindingContext.get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2)) != null) {
                    target = "[" + declarationDescriptors.size() + " descriptors]";
                }
                if (target == null && (labelTargets = bindingContext.get(BindingContext.AMBIGUOUS_LABEL_TARGET, expression2)) != null) {
                    target = "[" + labelTargets.size() + " elements]";
                }
                if (MAY_BE_UNRESOLVED.contains(referencedNameElementType)) {
                    return;
                }
                boolean resolved = target != null;
                boolean markedWithError = markedWithErrorElements.containsKey(expression2);
                if (expression2 instanceof KtArrayAccessExpression && markedWithErrorElements.containsKey(((KtArrayAccessExpression)expression2).getArrayExpression())) {
                    markedWithError = true;
                }
                KotlinType expressionType = bindingContext.getType(expression2);
                DiagnosticFactory factory2 = (DiagnosticFactory)markedWithErrorElements.get(expression2);
                if (declarationDescriptor != null && (ErrorUtils.isError(declarationDescriptor) || ErrorUtils.containsErrorType(expressionType)) && factory2 != Errors.EXPRESSION_EXPECTED_PACKAGE_FOUND) {
                    debugInfoReporter.reportElementWithErrorType(expression2);
                }
                if (resolved && markedWithError) {
                    if (Errors.UNRESOLVED_REFERENCE_DIAGNOSTICS.contains((Object)factory2)) {
                        debugInfoReporter.reportUnresolvedWithTarget(expression2, target);
                    }
                } else if (!resolved && !markedWithError) {
                    debugInfoReporter.reportMissingUnresolved(expression2);
                }
            }

            private <E extends KtElement, K, D extends CallableDescriptor> boolean reportIfDynamicCall(E element, K key, WritableSlice<K, ResolvedCall<D>> slice) {
                ResolvedCall<D> resolvedCall2 = bindingContext.get(slice, key);
                if (resolvedCall2 != null) {
                    return DebugInfoUtil.reportIfDynamic(element, resolvedCall2.getResultingDescriptor(), debugInfoReporter);
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "expression";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "destructuringDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "property";
                        break;
                    }
                }
                objectArray2[1] = "org/jetbrains/kotlin/checkers/utils/DebugInfoUtil$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitForExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitDestructuringDeclaration";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitProperty";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitThisExpression";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitReferenceExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static boolean reportIfDynamic(KtElement element, DeclarationDescriptor declarationDescriptor, DebugInfoReporter debugInfoReporter) {
        if (declarationDescriptor != null && DynamicCallsKt.isDynamic(declarationDescriptor)) {
            debugInfoReporter.reportDynamicCall(element, declarationDescriptor);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "root";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "bindingContext";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "debugInfoReporter";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/checkers/utils/DebugInfoUtil";
        objectArray[2] = "markDebugAnnotations";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class DebugInfoReporter {
        public void preProcessReference(@NotNull KtReferenceExpression expression2) {
            if (expression2 == null) {
                DebugInfoReporter.$$$reportNull$$$0(0);
            }
        }

        public abstract void reportElementWithErrorType(@NotNull KtReferenceExpression var1);

        public abstract void reportMissingUnresolved(@NotNull KtReferenceExpression var1);

        public abstract void reportUnresolvedWithTarget(@NotNull KtReferenceExpression var1, @NotNull String var2);

        public void reportDynamicCall(@NotNull KtElement element, DeclarationDescriptor declarationDescriptor) {
            if (element == null) {
                DebugInfoReporter.$$$reportNull$$$0(1);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/kotlin/checkers/utils/DebugInfoUtil$DebugInfoReporter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "preProcessReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "reportDynamicCall";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

