/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import java.util.LinkedHashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSymbolOwner;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.CallableId;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000H\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0001*\u00020\u0002\u001a\u001c\u0010\u0003\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u001c\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\t2\u0006\u0010\n\u001a\u00020\u0002\u001a \u0010\u000b\u001a\u0004\u0018\u0001H\f\"\n\b\u0000\u0010\f\u0018\u0001*\u00020\r*\u00020\u000eH\u0086\b\u00a2\u0006\u0002\u0010\u000f\u001a\u001a\u0010\u0010\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u00012\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0001\u001a\u001a\u0010\u0013\u001a\u00020\u0011*\u0006\u0012\u0002\b\u00030\u00012\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u0001\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00162\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0019"}, d2={"findClosestClassOrObject", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "followAlias", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "followAllAlias", "getContainingClass", "Lorg/jetbrains/kotlin/fir/FirSymbolOwner;", "context", "getDeclaration", "T", "", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;)Ljava/lang/Object;", "isSuperclassOf", "", "other", "isSupertypeOf", "toRegularClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers"})
public final class FirHelpersKt {
    public static final boolean isSuperclassOf(@NotNull FirClass<?> $this$isSuperclassOf, @NotNull FirClass<?> other) {
        Intrinsics.checkNotNullParameter($this$isSuperclassOf, (String)"$this$isSuperclassOf");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        isSuperclassOf.1 $fun$isSuperclassOf$1 = isSuperclassOf.1.INSTANCE;
        boolean bl = false;
        return $fun$isSuperclassOf$1.invoke($this$isSuperclassOf, other, new LinkedHashSet());
    }

    public static final boolean isSupertypeOf(@NotNull FirClass<?> $this$isSupertypeOf, @NotNull FirClass<?> other) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, (String)"$this$isSupertypeOf");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        isSupertypeOf.1 $fun$isSupertypeOf$1 = isSupertypeOf.1.INSTANCE;
        boolean bl = false;
        return $fun$isSupertypeOf$1.invoke($this$isSupertypeOf, other, new LinkedHashSet());
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeClassLikeType $this$toRegularClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"$this$toRegularClass");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirClassLikeSymbol<?> $this$safeAs$iv = ResolveUtilsKt.toSymbol($this$toRegularClass.getLookupTag(), session);
        boolean $i$f$safeAs = false;
        FirClassLikeSymbol<?> firClassLikeSymbol = $this$safeAs$iv;
        if (!(firClassLikeSymbol instanceof FirRegularClassSymbol)) {
            firClassLikeSymbol = null;
        }
        FirRegularClassSymbol firRegularClassSymbol = (FirRegularClassSymbol)firClassLikeSymbol;
        return firRegularClassSymbol != null ? (FirRegularClass)firRegularClassSymbol.getFir() : null;
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull ConeKotlinType $this$toRegularClass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"$this$toRegularClass");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        ConeKotlinType $this$safeAs$iv = $this$toRegularClass;
        boolean $i$f$safeAs = false;
        ConeKotlinType coneKotlinType = $this$safeAs$iv;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)coneKotlinType;
        return coneClassLikeType != null ? FirHelpersKt.toRegularClass(coneClassLikeType, session) : null;
    }

    @Nullable
    public static final FirRegularClass toRegularClass(@NotNull FirTypeRef $this$toRegularClass, @NotNull FirSession session) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClass, (String)"$this$toRegularClass");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirTypeRef $this$safeAs$iv = $this$toRegularClass;
        boolean $i$f$safeAs = false;
        FirTypeRef firTypeRef = $this$safeAs$iv;
        if (!(firTypeRef instanceof FirResolvedTypeRef)) {
            firTypeRef = null;
        }
        return (object = (FirResolvedTypeRef)firTypeRef) != null && (object = ((FirResolvedTypeRef)object).getType()) != null ? FirHelpersKt.toRegularClass((ConeKotlinType)object, session) : null;
    }

    @Nullable
    public static final /* synthetic */ <T> T getDeclaration(@NotNull FirQualifiedAccessExpression $this$getDeclaration) {
        Object object;
        int $i$f$getDeclaration = 0;
        Intrinsics.checkNotNullParameter((Object)$this$getDeclaration, (String)"$this$getDeclaration");
        FirReference $this$safeAs$iv = $this$getDeclaration.getCalleeReference();
        boolean $i$f$safeAs = false;
        FirReference firReference = $this$safeAs$iv;
        if (!(firReference instanceof FirResolvedNamedReference)) {
            firReference = null;
        }
        $this$safeAs$iv = (object = (FirResolvedNamedReference)firReference) != null && (object = ((FirResolvedNamedReference)object).getResolvedSymbol()) != null ? ((AbstractFirBasedSymbol)object).getFir() : null;
        $i$f$safeAs = false;
        Intrinsics.reifiedOperationMarker((int)2, (String)"T");
        return (T)$this$safeAs$iv;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> getContainingClass(@NotNull FirSymbolOwner<?> $this$getContainingClass, @NotNull CheckerContext context2) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getContainingClass, (String)"$this$getContainingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AbstractFirBasedSymbol<?> $this$safeAs$iv = $this$getContainingClass.getSymbol();
        boolean $i$f$safeAs = false;
        AbstractFirBasedSymbol<?> abstractFirBasedSymbol = $this$safeAs$iv;
        if (!(abstractFirBasedSymbol instanceof FirCallableSymbol)) {
            abstractFirBasedSymbol = null;
        }
        if ((object = (FirCallableSymbol)abstractFirBasedSymbol) == null || (object = ((FirCallableSymbol)object).getCallableId()) == null || (object = ((CallableId)object).getClassId()) == null) {
            return null;
        }
        Object classId = object;
        if (!((ClassId)classId).isLocal()) {
            FirClassLikeSymbol<?> firClassLikeSymbol = ResolveUtilsKt.getFirSymbolProvider(context2.getSession()).getClassLikeSymbolByFqName((ClassId)classId);
            return firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        }
        return null;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> followAlias(@NotNull FirClassLikeDeclaration<?> $this$followAlias, @NotNull FirSession session) {
        FirAnnotationContainer firAnnotationContainer;
        Intrinsics.checkNotNullParameter($this$followAlias, (String)"$this$followAlias");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirClassLikeDeclaration<?> $this$safeAs$iv = $this$followAlias;
        boolean $i$f$safeAs = false;
        FirClassLikeDeclaration<?> firClassLikeDeclaration = $this$safeAs$iv;
        if (!(firClassLikeDeclaration instanceof FirTypeAlias)) {
            firClassLikeDeclaration = null;
        }
        if ((firAnnotationContainer = (FirTypeAlias)firClassLikeDeclaration) == null || (firAnnotationContainer = firAnnotationContainer.getExpandedTypeRef()) == null || (firAnnotationContainer = FirSupertypesResolutionKt.firClassLike((FirTypeRef)firAnnotationContainer, session)) == null) {
            return $this$followAlias;
        }
        return firAnnotationContainer;
    }

    @Nullable
    public static final FirClassLikeDeclaration<?> followAllAlias(@NotNull FirClassLikeDeclaration<?> $this$followAllAlias, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$followAllAlias, (String)"$this$followAllAlias");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        FirClassLikeDeclaration<?> it = $this$followAllAlias;
        while (it instanceof FirTypeAlias) {
            it = FirSupertypesResolutionKt.firClassLike(((FirTypeAlias)it).getExpandedTypeRef(), session);
        }
        return it;
    }

    @Nullable
    public static final FirClass<?> findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)$this$findClosestClassOrObject, (String)"$this$findClosestClassOrObject");
        for (FirDeclaration it : CollectionsKt.reversed((Iterable)$this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }
}

