/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental;

import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.build.GeneratedFile;
import org.jetbrains.kotlin.build.GeneratedFilesKt;
import org.jetbrains.kotlin.build.GeneratedJvmClass;
import org.jetbrains.kotlin.build.JvmSourceRoot;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.ChangeInfo;
import org.jetbrains.kotlin.incremental.ChangesCollector;
import org.jetbrains.kotlin.incremental.DirtyData;
import org.jetbrains.kotlin.incremental.FileUtilsKt;
import org.jetbrains.kotlin.incremental.ICReporter;
import org.jetbrains.kotlin.incremental.IncrementalCacheCommon;
import org.jetbrains.kotlin.incremental.IncrementalCompilationComponentsImpl;
import org.jetbrains.kotlin.incremental.IncrementalJvmCache;
import org.jetbrains.kotlin.incremental.JavaClassesTrackerImpl;
import org.jetbrains.kotlin.incremental.LookupStorage;
import org.jetbrains.kotlin.incremental.LookupSymbol;
import org.jetbrains.kotlin.incremental.LookupTrackerImpl;
import org.jetbrains.kotlin.incremental.SerializedJavaClass;
import org.jetbrains.kotlin.incremental.SerializedJavaClassWithSource;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCache;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.KotlinModuleXmlBuilder;
import org.jetbrains.kotlin.modules.TargetId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.CompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000\u0098\u0001\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a,\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u001ad\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00132\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\r0\u0013\u001a@\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00132\u0006\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001a\u001a:\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\u001a2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020&0\u00132\u0006\u0010\u001f\u001a\u00020 2\u000e\b\u0002\u0010!\u001a\b\u0012\u0004\u0012\u00020\r0\u001a\u001a\u0010\u0010'\u001a\u00020\u00012\u0006\u0010(\u001a\u00020\u0001H\u0002\u001a.\u0010)\u001a\u00020*2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u00132\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\b\u00101\u001a\u0004\u0018\u000102\u001a\"\u00103\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001a2\u0006\u00104\u001a\u00020\u001e2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0013\u001a \u00105\u001a\u000206*\u0002002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00132\u0006\u0010\u001f\u001a\u00020 \u001a.\u00107\u001a\u00020**\u00020$2\u0006\u0010\b\u001a\u00020\t2\f\u00108\u001a\b\u0012\u0004\u0012\u00020\r0\u00132\f\u00109\u001a\b\u0012\u0004\u0012\u00020\r0\u0013\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"DELETE_MODULE_FILE_PROPERTY", "", "makeCompileServices", "Lorg/jetbrains/kotlin/config/Services;", "incrementalCaches", "", "Lorg/jetbrains/kotlin/modules/TargetId;", "Lorg/jetbrains/kotlin/load/kotlin/incremental/components/IncrementalCache;", "lookupTracker", "Lorg/jetbrains/kotlin/incremental/components/LookupTracker;", "compilationCanceledStatus", "Lorg/jetbrains/kotlin/progress/CompilationCanceledStatus;", "makeModuleFile", "Ljava/io/File;", "name", "isTest", "", "outputDir", "sourcesToCompile", "", "commonSources", "javaSourceRoots", "Lorg/jetbrains/kotlin/build/JvmSourceRoot;", "classpath", "friendDirs", "mapClassesFqNamesToFiles", "", "caches", "Lorg/jetbrains/kotlin/incremental/IncrementalCacheCommon;", "classesFqNames", "Lorg/jetbrains/kotlin/name/FqName;", "reporter", "Lorg/jetbrains/kotlin/incremental/ICReporter;", "excludes", "mapLookupSymbolsToFiles", "lookupStorage", "Lorg/jetbrains/kotlin/incremental/LookupStorage;", "lookupSymbols", "Lorg/jetbrains/kotlin/incremental/LookupSymbol;", "sanitizeJavaIdentifier", "string", "updateIncrementalCache", "", "generatedFiles", "Lorg/jetbrains/kotlin/build/GeneratedFile;", "cache", "Lorg/jetbrains/kotlin/incremental/IncrementalJvmCache;", "changesCollector", "Lorg/jetbrains/kotlin/incremental/ChangesCollector;", "javaChangesTracker", "Lorg/jetbrains/kotlin/incremental/JavaClassesTrackerImpl;", "withSubtypes", "typeFqName", "getDirtyData", "Lorg/jetbrains/kotlin/incremental/DirtyData;", "update", "filesToCompile", "removedFiles", "kotlin-build-common"})
public final class BuildUtilKt {
    @NotNull
    public static final String DELETE_MODULE_FILE_PROPERTY = "kotlin.delete.module.file.after.build";

    @NotNull
    public static final File makeModuleFile(@NotNull String name, boolean isTest, @NotNull File outputDir2, @NotNull Iterable<? extends File> sourcesToCompile, @NotNull Iterable<? extends File> commonSources, @NotNull Iterable<JvmSourceRoot> javaSourceRoots, @NotNull Iterable<? extends File> classpath, @NotNull Iterable<? extends File> friendDirs) {
        File scriptFile;
        Collection<File> collection;
        Object object;
        File it;
        boolean bl;
        Iterable iterable;
        Iterable<? extends File> $this$mapTo$iv$iv;
        Iterable<? extends File> $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)outputDir2, (String)"outputDir");
        Intrinsics.checkNotNullParameter(sourcesToCompile, (String)"sourcesToCompile");
        Intrinsics.checkNotNullParameter(commonSources, (String)"commonSources");
        Intrinsics.checkNotNullParameter(javaSourceRoots, (String)"javaSourceRoots");
        Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
        Intrinsics.checkNotNullParameter(friendDirs, (String)"friendDirs");
        KotlinModuleXmlBuilder builder = new KotlinModuleXmlBuilder();
        String string2 = outputDir2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"outputDir.absolutePath");
        Iterable<? extends File> iterable2 = sourcesToCompile;
        String string3 = string2;
        String string4 = name;
        KotlinModuleXmlBuilder kotlinModuleXmlBuilder = builder;
        boolean $i$f$map = false;
        void var11_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object t : $this$mapTo$iv$iv) {
            File file2 = (File)t;
            iterable = destination$iv$iv;
            bl = false;
            object = it.getAbsoluteFile();
            iterable.add(object);
        }
        iterable = (List)destination$iv$iv;
        $this$map$iv = commonSources;
        Iterable<? extends File> iterable3 = classpath;
        object = javaSourceRoots;
        iterable = iterable;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object object2 : $this$mapTo$iv$iv) {
            it = (File)object2;
            collection = destination$iv$iv;
            bl = false;
            File file3 = it.getAbsoluteFile();
            collection.add(file3);
        }
        collection = (List)destination$iv$iv;
        kotlinModuleXmlBuilder.addModule(string4, string3, iterable, (Iterable<JvmSourceRoot>)object, iterable3, (Iterable<? extends File>)collection, null, "java-production", isTest, SetsKt.setOf((Object)outputDir2), friendDirs);
        File file4 = scriptFile = File.createTempFile("kjps", BuildUtilKt.sanitizeJavaIdentifier(name) + ".script.xml");
        Intrinsics.checkNotNullExpressionValue((Object)file4, (String)"scriptFile");
        FilesKt.writeText$default((File)file4, (String)((Object)builder.asText()).toString(), null, (int)2, null);
        return scriptFile;
    }

    private static final String sanitizeJavaIdentifier(String string2) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder2 = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder2;
        boolean bl5 = false;
        String string3 = string2;
        int n = string3.length();
        for (int i = 0; i < n; ++i) {
            char c;
            char c2 = c = string3.charAt(i);
            boolean bl6 = false;
            if (!Character.isJavaIdentifierPart(c2)) continue;
            if ($this$buildString.length() == 0) {
                c2 = c;
                bl6 = false;
                if (!Character.isJavaIdentifierStart(c2)) {
                    $this$buildString.append('_');
                }
            }
            $this$buildString.append(c);
        }
        String string4 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"StringBuilder().apply(builderAction).toString()");
        return string4;
    }

    @NotNull
    public static final Services makeCompileServices(@NotNull Map<TargetId, ? extends IncrementalCache> incrementalCaches, @NotNull LookupTracker lookupTracker, @Nullable CompilationCanceledStatus compilationCanceledStatus) {
        Services.Builder $this$with;
        block0: {
            Intrinsics.checkNotNullParameter(incrementalCaches, (String)"incrementalCaches");
            Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
            Services.Builder builder = new Services.Builder();
            boolean bl = false;
            boolean bl2 = false;
            $this$with = builder;
            boolean bl3 = false;
            $this$with.register(LookupTracker.class, lookupTracker);
            $this$with.register(IncrementalCompilationComponents.class, new IncrementalCompilationComponentsImpl(incrementalCaches));
            CompilationCanceledStatus compilationCanceledStatus2 = compilationCanceledStatus;
            if (compilationCanceledStatus2 == null) break block0;
            CompilationCanceledStatus compilationCanceledStatus3 = compilationCanceledStatus2;
            boolean bl4 = false;
            boolean bl5 = false;
            CompilationCanceledStatus it = compilationCanceledStatus3;
            boolean bl6 = false;
            $this$with.register(CompilationCanceledStatus.class, it);
        }
        return $this$with.build();
    }

    /*
     * WARNING - void declaration
     */
    public static final void updateIncrementalCache(@NotNull Iterable<? extends GeneratedFile> generatedFiles, @NotNull IncrementalJvmCache cache2, @NotNull ChangesCollector changesCollector, @Nullable JavaClassesTrackerImpl javaChangesTracker) {
        Intrinsics.checkNotNullParameter(generatedFiles, (String)"generatedFiles");
        Intrinsics.checkNotNullParameter((Object)cache2, (String)"cache");
        Intrinsics.checkNotNullParameter((Object)changesCollector, (String)"changesCollector");
        for (GeneratedFile generatedFile : generatedFiles) {
            if (generatedFile instanceof GeneratedJvmClass) {
                cache2.saveFileToCache((GeneratedJvmClass)generatedFile, changesCollector);
                continue;
            }
            if (!GeneratedFilesKt.isModuleMappingFile(generatedFile.getOutputFile())) continue;
            cache2.saveModuleMappingToCache((Collection<? extends File>)generatedFile.getSourceFiles(), generatedFile.getOutputFile());
        }
        Object object = javaChangesTracker;
        if (object != null && (object = ((JavaClassesTrackerImpl)object).getJavaClassesUpdates()) != null) {
            Iterable iterable = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : iterable) {
                void source;
                SerializedJavaClassWithSource $dstr$source$serializedJavaClass = (SerializedJavaClassWithSource)element$iv;
                boolean bl = false;
                File file2 = $dstr$source$serializedJavaClass.component1();
                SerializedJavaClass serializedJavaClass = $dstr$source$serializedJavaClass.component2();
                cache2.saveJavaClassProto((File)source, serializedJavaClass, changesCollector);
            }
        }
        cache2.clearCacheForRemovedClasses(changesCollector);
    }

    public static final void update(@NotNull LookupStorage $this$update, @NotNull LookupTracker lookupTracker, @NotNull Iterable<? extends File> filesToCompile, @NotNull Iterable<? extends File> removedFiles) {
        Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)lookupTracker, (String)"lookupTracker");
        Intrinsics.checkNotNullParameter(filesToCompile, (String)"filesToCompile");
        Intrinsics.checkNotNullParameter(removedFiles, (String)"removedFiles");
        if (!(lookupTracker instanceof LookupTrackerImpl)) {
            throw (Throwable)((Object)new AssertionError((Object)("Lookup tracker is expected to be LookupTrackerImpl, got " + lookupTracker.getClass())));
        }
        $this$update.removeLookupsFrom((Sequence<? extends File>)SequencesKt.plus((Sequence)CollectionsKt.asSequence(filesToCompile), (Sequence)CollectionsKt.asSequence(removedFiles)));
        MultiMap<LookupSymbol, String> multiMap = ((LookupTrackerImpl)lookupTracker).getLookups();
        Set set = ((LookupTrackerImpl)lookupTracker).getPathInterner().getValues();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"lookupTracker.pathInterner.values");
        $this$update.addAll(multiMap, set);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DirtyData getDirtyData(@NotNull ChangesCollector $this$getDirtyData, @NotNull Iterable<? extends IncrementalCacheCommon> caches, @NotNull ICReporter reporter) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirtyData, (String)"$this$getDirtyData");
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        HashSet<LookupSymbol> dirtyLookupSymbols = new HashSet<LookupSymbol>();
        HashSet<FqName> dirtyClassesFqNames = new HashSet<FqName>();
        for (ChangeInfo change : $this$getDirtyData.changes()) {
            LookupSymbol lookupSymbol;
            Collection collection;
            Collection<FqName> fqNames;
            reporter.reportVerbose((Function0<String>)((Function0)new Function0<String>(change){
                final /* synthetic */ ChangeInfo $change;

                @NotNull
                public final String invoke() {
                    return "Process " + this.$change;
                }
                {
                    this.$change = changeInfo;
                    super(0);
                }
            }));
            if (change instanceof ChangeInfo.SignatureChanged) {
                fqNames = !((ChangeInfo.SignatureChanged)change).getAreSubclassesAffected() ? (Collection)CollectionsKt.listOf((Object)change.getFqName()) : (Collection)BuildUtilKt.withSubtypes(change.getFqName(), caches);
                dirtyClassesFqNames.addAll(fqNames);
                for (FqName classFqName : fqNames) {
                    String scope2;
                    String name;
                    boolean bl = !classFqName.isRoot();
                    boolean bl2 = false;
                    if (_Assertions.ENABLED && !bl) {
                        boolean $i$a$-assert-BuildUtilKt$getDirtyData$32 = false;
                        String $i$a$-assert-BuildUtilKt$getDirtyData$32 = classFqName + " is root when processing " + change;
                        throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-BuildUtilKt$getDirtyData$32));
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)classFqName.parent().asString(), (String)"classFqName.parent().asString()");
                    Name name2 = classFqName.shortName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classFqName.shortName()");
                    Intrinsics.checkNotNullExpressionValue((Object)name2.getIdentifier(), (String)"classFqName.shortName().identifier");
                    dirtyLookupSymbols.add(new LookupSymbol(name, scope2));
                }
                continue;
            }
            if (!(change instanceof ChangeInfo.MembersChanged)) continue;
            fqNames = BuildUtilKt.withSubtypes(change.getFqName(), caches);
            dirtyClassesFqNames.addAll(fqNames);
            for (String name : ((ChangeInfo.MembersChanged)change).getNames()) {
                Iterable $this$mapTo$iv = fqNames;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    FqName fqName2 = (FqName)item$iv;
                    collection = dirtyLookupSymbols;
                    boolean bl = false;
                    String string2 = it.asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.asString()");
                    lookupSymbol = new LookupSymbol(name, string2);
                    collection.add(lookupSymbol);
                }
            }
            Iterable $this$mapTo$iv = fqNames;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                FqName $i$a$-assert-BuildUtilKt$getDirtyData$32 = (FqName)item$iv;
                collection = dirtyLookupSymbols;
                boolean bl = false;
                String string3 = SamConversionResolverKt.getSAM_LOOKUP_NAME().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"SAM_LOOKUP_NAME.asString()");
                String string4 = it.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it.asString()");
                lookupSymbol = new LookupSymbol(string3, string4);
                collection.add(lookupSymbol);
            }
        }
        return new DirtyData((Collection<LookupSymbol>)dirtyLookupSymbols, (Collection<FqName>)dirtyClassesFqNames);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<File> mapLookupSymbolsToFiles(@NotNull LookupStorage lookupStorage, @NotNull Iterable<LookupSymbol> lookupSymbols, @NotNull ICReporter reporter, @NotNull Set<? extends File> excludes) {
        Intrinsics.checkNotNullParameter((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkNotNullParameter(lookupSymbols, (String)"lookupSymbols");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        HashSet dirtyFiles = new HashSet();
        for (LookupSymbol lookup : lookupSymbols) {
            void $this$filterTo$iv$iv;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv = lookupStorage.get(lookup);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p1;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                File file2 = new File((String)p1);
                collection.add(file2);
            }
            Iterable $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                File it = (File)element$iv$iv;
                boolean bl = false;
                if (!(!excludes.contains(it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List affectedFiles = (List)destination$iv$iv;
            reporter.reportMarkDirtyMember(affectedFiles, lookup.getScope(), lookup.getName());
            dirtyFiles.addAll(affectedFiles);
        }
        return dirtyFiles;
    }

    public static /* synthetic */ Set mapLookupSymbolsToFiles$default(LookupStorage lookupStorage, Iterable iterable, ICReporter iCReporter, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return BuildUtilKt.mapLookupSymbolsToFiles(lookupStorage, iterable, iCReporter, set);
    }

    @NotNull
    public static final Set<File> mapClassesFqNamesToFiles(@NotNull Iterable<? extends IncrementalCacheCommon> caches, @NotNull Iterable<FqName> classesFqNames, @NotNull ICReporter reporter, @NotNull Set<? extends File> excludes) {
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        Intrinsics.checkNotNullParameter(classesFqNames, (String)"classesFqNames");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter(excludes, (String)"excludes");
        HashMap fqNameToAffectedFiles = new HashMap();
        for (IncrementalCacheCommon entry : caches) {
            for (FqName fqName2 : classesFqNames) {
                Object object;
                File srcFile = entry.getSourceFileIfClass(fqName2);
                if (srcFile == null || excludes.contains(srcFile) || FileUtilsKt.isJavaFile(srcFile)) continue;
                Map $this$getOrPut$iv = fqNameToAffectedFiles;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(fqName2);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new HashSet();
                    $this$getOrPut$iv.put(fqName2, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Set)object).add(srcFile);
            }
        }
        Map map2 = fqNameToAffectedFiles;
        boolean bl = false;
        Iterator<Object> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = (Map.Entry)iterator2.next();
            boolean bl2 = false;
            FqName fqName3 = (FqName)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            Set affectedFiles = (Set)entry2.getValue();
            Iterable iterable = affectedFiles;
            String string2 = fqName3.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classFqName.asString()");
            reporter.reportMarkDirtyClass(iterable, string2);
        }
        Collection collection = fqNameToAffectedFiles.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"fqNameToAffectedFiles.values");
        return (Set)AddToStdlibKt.flattenTo(collection, (Collection)new HashSet());
    }

    public static /* synthetic */ Set mapClassesFqNamesToFiles$default(Iterable iterable, Iterable iterable2, ICReporter iCReporter, Set set, int n, Object object) {
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        return BuildUtilKt.mapClassesFqNamesToFiles(iterable, iterable2, iCReporter, set);
    }

    @NotNull
    public static final Set<FqName> withSubtypes(@NotNull FqName typeFqName, @NotNull Iterable<? extends IncrementalCacheCommon> caches) {
        Intrinsics.checkNotNullParameter((Object)typeFqName, (String)"typeFqName");
        Intrinsics.checkNotNullParameter(caches, (String)"caches");
        LinkedHashSet<FqName> types2 = new LinkedHashSet<FqName>(CollectionsKt.listOf((Object)typeFqName));
        boolean bl = false;
        HashSet<FqName> subtypes = new HashSet<FqName>();
        while (true) {
            Iterator iterator2;
            Collection collection = types2;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) break;
            Intrinsics.checkNotNullExpressionValue(types2.iterator(), (String)"types.iterator()");
            FqName unprocessedType = (FqName)iterator2.next();
            iterator2.remove();
            Sequence $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence(caches), (Function1)((Function1)new Function1<IncrementalCacheCommon, Sequence<? extends FqName>>(unprocessedType){
                final /* synthetic */ FqName $unprocessedType;

                @NotNull
                public final Sequence<FqName> invoke(@NotNull IncrementalCacheCommon it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    FqName fqName2 = this.$unprocessedType;
                    Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"unprocessedType");
                    return it.getSubtypesOf(fqName2);
                }
                {
                    this.$unprocessedType = fqName2;
                    super(1);
                }
            })), (Function1)((Function1)new Function1<FqName, Boolean>(subtypes){
                final /* synthetic */ HashSet $subtypes;

                public final boolean invoke(@NotNull FqName it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return !this.$subtypes.contains(it);
                }
                {
                    this.$subtypes = hashSet;
                    super(1);
                }
            }));
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FqName it = (FqName)element$iv;
                boolean bl3 = false;
                types2.add(it);
            }
            subtypes.add(unprocessedType);
        }
        return subtypes;
    }
}

