/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.annotations;

import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.JvmDefaultMode;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.deserialization.PlatformDependentDeclarationFilterKt;
import org.jetbrains.kotlin.load.java.JvmAbi;
import org.jetbrains.kotlin.metadata.jvm.deserialization.JvmProtoBufUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0010\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u000f*\u00020\u0010\u001a\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u000f*\u00020\u0013H\u0002\u001a\f\u0010\u0014\u001a\u0004\u0018\u00010\u000f*\u00020\u0010\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u000f*\u00020\u0010\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u0018\u001a\n\u0010\u0019\u001a\u00020\u0017*\u00020\u0010\u001a\n\u0010\u001a\u001a\u00020\u0017*\u00020\u0010\u001a\n\u0010\u001b\u001a\u00020\u0017*\u00020\u0010\u001a\n\u0010\u001c\u001a\u00020\u0017*\u00020\u0018\u001a\u0012\u0010\u001d\u001a\u00020\u0017*\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\u0017*\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u0011\u0010\u0006\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0003\"\u0011\u0010\b\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0003\"\u0010\u0010\n\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u000b\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\f\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\r\u001a\u00020\u00018\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"JVM_DEFAULT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getJVM_DEFAULT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME", "JVM_OVERLOADS_FQ_NAME", "getJVM_OVERLOADS_FQ_NAME", "JVM_SYNTHETIC_ANNOTATION_FQ_NAME", "getJVM_SYNTHETIC_ANNOTATION_FQ_NAME", "STRICTFP_ANNOTATION_FQ_NAME", "SYNCHRONIZED_ANNOTATION_FQ_NAME", "TRANSIENT_ANNOTATION_FQ_NAME", "VOLATILE_ANNOTATION_FQ_NAME", "findJvmFieldAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "findJvmOverloadsAnnotation", "findJvmSyntheticAnnotation", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "findStrictfpAnnotation", "findSynchronizedAnnotation", "hasJvmDefaultAnnotation", "", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "hasJvmDefaultNoCompatibilityAnnotation", "hasJvmFieldAnnotation", "hasJvmSyntheticAnnotation", "hasPlatformDependentAnnotation", "isCallableMemberCompiledToJvmDefault", "jvmDefault", "Lorg/jetbrains/kotlin/config/JvmDefaultMode;", "isCompiledToJvmDefault", "frontend.java"})
public final class JvmAnnotationUtilKt {
    @NotNull
    private static final FqName JVM_DEFAULT_FQ_NAME = new FqName("kotlin.jvm.JvmDefault");
    @NotNull
    private static final FqName JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME = new FqName("kotlin.jvm.JvmDefaultWithoutCompatibility");
    @NotNull
    private static final FqName JVM_OVERLOADS_FQ_NAME = new FqName("kotlin.jvm.JvmOverloads");
    @NotNull
    private static final FqName JVM_SYNTHETIC_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.JvmSynthetic");
    @JvmField
    @NotNull
    public static final FqName SYNCHRONIZED_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Synchronized");
    @JvmField
    @NotNull
    public static final FqName STRICTFP_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Strictfp");
    @JvmField
    @NotNull
    public static final FqName VOLATILE_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Volatile");
    @JvmField
    @NotNull
    public static final FqName TRANSIENT_ANNOTATION_FQ_NAME = new FqName("kotlin.jvm.Transient");

    @NotNull
    public static final FqName getJVM_DEFAULT_FQ_NAME() {
        return JVM_DEFAULT_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME() {
        return JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_OVERLOADS_FQ_NAME() {
        return JVM_OVERLOADS_FQ_NAME;
    }

    @NotNull
    public static final FqName getJVM_SYNTHETIC_ANNOTATION_FQ_NAME() {
        return JVM_SYNTHETIC_ANNOTATION_FQ_NAME;
    }

    @Nullable
    public static final AnnotationDescriptor findJvmOverloadsAnnotation(@NotNull DeclarationDescriptor $this$findJvmOverloadsAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findJvmOverloadsAnnotation, (String)"$this$findJvmOverloadsAnnotation");
        return $this$findJvmOverloadsAnnotation.getAnnotations().findAnnotation(JVM_OVERLOADS_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findJvmFieldAnnotation(@NotNull DeclarationDescriptor $this$findJvmFieldAnnotation) {
        AnnotationDescriptor annotationDescriptor;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$findJvmFieldAnnotation, (String)"$this$findJvmFieldAnnotation");
        DeclarationDescriptor declarationDescriptor = $this$findJvmFieldAnnotation;
        if (!(declarationDescriptor instanceof PropertyDescriptor)) {
            declarationDescriptor = null;
        }
        if ((object = (PropertyDescriptor)declarationDescriptor) != null && (object = object.getBackingField()) != null && (object = object.getAnnotations()) != null) {
            FqName fqName2 = JvmAbi.JVM_FIELD_ANNOTATION_FQ_NAME;
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"JVM_FIELD_ANNOTATION_FQ_NAME");
            annotationDescriptor = object.findAnnotation(fqName2);
        } else {
            annotationDescriptor = null;
        }
        return annotationDescriptor;
    }

    public static final boolean hasJvmFieldAnnotation(@NotNull DeclarationDescriptor $this$hasJvmFieldAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmFieldAnnotation, (String)"$this$hasJvmFieldAnnotation");
        return JvmAnnotationUtilKt.findJvmFieldAnnotation($this$hasJvmFieldAnnotation) != null;
    }

    public static final boolean isCallableMemberCompiledToJvmDefault(@NotNull DeclarationDescriptor $this$isCallableMemberCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$isCallableMemberCompiledToJvmDefault, (String)"$this$isCallableMemberCompiledToJvmDefault");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmDefault), (String)"jvmDefault");
        return $this$isCallableMemberCompiledToJvmDefault instanceof CallableMemberDescriptor && JvmAnnotationUtilKt.isCompiledToJvmDefault((CallableMemberDescriptor)$this$isCallableMemberCompiledToJvmDefault, jvmDefault);
    }

    public static final boolean isCompiledToJvmDefault(@NotNull CallableMemberDescriptor $this$isCompiledToJvmDefault, @NotNull JvmDefaultMode jvmDefault) {
        Intrinsics.checkNotNullParameter((Object)$this$isCompiledToJvmDefault, (String)"$this$isCompiledToJvmDefault");
        Intrinsics.checkNotNullParameter((Object)((Object)jvmDefault), (String)"jvmDefault");
        CallableMemberDescriptor callableMemberDescriptor = DescriptorUtils.getDirectMember($this$isCompiledToJvmDefault);
        Intrinsics.checkNotNullExpressionValue((Object)callableMemberDescriptor, (String)"DescriptorUtils.getDirectMember(this)");
        CallableMemberDescriptor directMember = callableMemberDescriptor;
        DeclarationDescriptor declarationDescriptor = directMember.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"directMember.containingDeclaration");
        DeclarationDescriptor clazz = declarationDescriptor;
        if (directMember.getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME)) {
            return true;
        }
        if (!(clazz instanceof DeserializedClassDescriptor)) {
            return jvmDefault.getForAllMethodsWithBody();
        }
        return JvmProtoBufUtil.isNewPlaceForBodyGeneration(((DeserializedClassDescriptor)clazz).getClassProto());
    }

    public static final boolean hasJvmDefaultAnnotation(@NotNull CallableMemberDescriptor $this$hasJvmDefaultAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmDefaultAnnotation, (String)"$this$hasJvmDefaultAnnotation");
        return DescriptorUtils.getDirectMember($this$hasJvmDefaultAnnotation).getAnnotations().hasAnnotation(JVM_DEFAULT_FQ_NAME);
    }

    public static final boolean hasJvmDefaultNoCompatibilityAnnotation(@NotNull DeclarationDescriptor $this$hasJvmDefaultNoCompatibilityAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmDefaultNoCompatibilityAnnotation, (String)"$this$hasJvmDefaultNoCompatibilityAnnotation");
        return $this$hasJvmDefaultNoCompatibilityAnnotation.getAnnotations().hasAnnotation(JVM_DEFAULT_NO_COMPATIBILITY_FQ_NAME);
    }

    public static final boolean hasPlatformDependentAnnotation(@NotNull CallableMemberDescriptor $this$hasPlatformDependentAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasPlatformDependentAnnotation, (String)"$this$hasPlatformDependentAnnotation");
        return DescriptorUtils.getDirectMember($this$hasPlatformDependentAnnotation).getAnnotations().hasAnnotation(PlatformDependentDeclarationFilterKt.getPLATFORM_DEPENDENT_ANNOTATION_FQ_NAME());
    }

    private static final AnnotationDescriptor findJvmSyntheticAnnotation(Annotated $this$findJvmSyntheticAnnotation) {
        AnnotationDescriptor annotationDescriptor = $this$findJvmSyntheticAnnotation.getAnnotations().findAnnotation(JVM_SYNTHETIC_ANNOTATION_FQ_NAME);
        if (annotationDescriptor == null) {
            Object object;
            Annotated annotated = $this$findJvmSyntheticAnnotation;
            if (!(annotated instanceof PropertyDescriptor)) {
                annotated = null;
            }
            annotationDescriptor = (object = (PropertyDescriptor)annotated) != null && (object = object.getBackingField()) != null && (object = object.getAnnotations()) != null ? object.findAnnotation(JVM_SYNTHETIC_ANNOTATION_FQ_NAME) : null;
        }
        return annotationDescriptor;
    }

    public static final boolean hasJvmSyntheticAnnotation(@NotNull DeclarationDescriptor $this$hasJvmSyntheticAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$hasJvmSyntheticAnnotation, (String)"$this$hasJvmSyntheticAnnotation");
        return JvmAnnotationUtilKt.findJvmSyntheticAnnotation($this$hasJvmSyntheticAnnotation) != null;
    }

    @Nullable
    public static final AnnotationDescriptor findStrictfpAnnotation(@NotNull DeclarationDescriptor $this$findStrictfpAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findStrictfpAnnotation, (String)"$this$findStrictfpAnnotation");
        return $this$findStrictfpAnnotation.getAnnotations().findAnnotation(STRICTFP_ANNOTATION_FQ_NAME);
    }

    @Nullable
    public static final AnnotationDescriptor findSynchronizedAnnotation(@NotNull DeclarationDescriptor $this$findSynchronizedAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$findSynchronizedAnnotation, (String)"$this$findSynchronizedAnnotation");
        return $this$findSynchronizedAnnotation.getAnnotations().findAnnotation(SYNCHRONIZED_ANNOTATION_FQ_NAME);
    }
}

