/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinPluginVersion;
import org.jetbrains.kotlin.idea.PlatformVersion;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001f\u0010\r\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/KidKotlinPluginVersion;", "Lorg/jetbrains/kotlin/idea/KotlinPluginVersion;", "buildNumber", "", "platformVersion", "Lorg/jetbrains/kotlin/idea/PlatformVersion;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/idea/PlatformVersion;)V", "getBuildNumber", "()Ljava/lang/String;", "getPlatformVersion", "()Lorg/jetbrains/kotlin/idea/PlatformVersion;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "kotlin.idea"})
public final class KidKotlinPluginVersion
implements KotlinPluginVersion {
    @Nullable
    private final String buildNumber;
    @NotNull
    private final PlatformVersion platformVersion;
    private static final Regex KID_KOTLIN_VERSION_REGEX;
    public static final Companion Companion;

    @Override
    @Nullable
    public String getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    @NotNull
    public PlatformVersion getPlatformVersion() {
        return this.platformVersion;
    }

    public KidKotlinPluginVersion(@Nullable String buildNumber, @NotNull PlatformVersion platformVersion) {
        Intrinsics.checkNotNullParameter((Object)platformVersion, (String)"platformVersion");
        this.buildNumber = buildNumber;
        this.platformVersion = platformVersion;
    }

    static {
        Companion = new Companion(null);
        String string = "([\\d]{3}).([\\d]+)-kid";
        boolean bl = false;
        KID_KOTLIN_VERSION_REGEX = new Regex(string);
    }

    @Nullable
    public final String component1() {
        return this.getBuildNumber();
    }

    @NotNull
    public final PlatformVersion component2() {
        return this.getPlatformVersion();
    }

    @NotNull
    public final KidKotlinPluginVersion copy(@Nullable String buildNumber, @NotNull PlatformVersion platformVersion) {
        Intrinsics.checkNotNullParameter((Object)platformVersion, (String)"platformVersion");
        return new KidKotlinPluginVersion(buildNumber, platformVersion);
    }

    public static /* synthetic */ KidKotlinPluginVersion copy$default(KidKotlinPluginVersion kidKotlinPluginVersion, String string, PlatformVersion platformVersion, int n, Object object) {
        if ((n & 1) != 0) {
            string = kidKotlinPluginVersion.getBuildNumber();
        }
        if ((n & 2) != 0) {
            platformVersion = kidKotlinPluginVersion.getPlatformVersion();
        }
        return kidKotlinPluginVersion.copy(string, platformVersion);
    }

    @NotNull
    public String toString() {
        return "KidKotlinPluginVersion(buildNumber=" + this.getBuildNumber() + ", platformVersion=" + this.getPlatformVersion() + ")";
    }

    public int hashCode() {
        String string = this.getBuildNumber();
        PlatformVersion platformVersion = this.getPlatformVersion();
        return (string != null ? string.hashCode() : 0) * 31 + (platformVersion != null ? platformVersion.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof KidKotlinPluginVersion)) break block3;
                KidKotlinPluginVersion kidKotlinPluginVersion = (KidKotlinPluginVersion)object;
                if (!Intrinsics.areEqual((Object)this.getBuildNumber(), (Object)kidKotlinPluginVersion.getBuildNumber()) || !Intrinsics.areEqual((Object)this.getPlatformVersion(), (Object)kidKotlinPluginVersion.getPlatformVersion())) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/KidKotlinPluginVersion$Companion;", "", "()V", "KID_KOTLIN_VERSION_REGEX", "Lkotlin/text/Regex;", "parse", "Lorg/jetbrains/kotlin/idea/KidKotlinPluginVersion;", "version", "", "kotlin.idea"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public final KidKotlinPluginVersion parse(@NotNull String version) {
            void platformNumber;
            MatchResult.Destructured destructured;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            MatchResult matchResult = KID_KOTLIN_VERSION_REGEX.matchEntire((CharSequence)version);
            if (matchResult == null) {
                return null;
            }
            MatchResult matchResult2 = matchResult;
            MatchResult.Destructured destructured2 = destructured = matchResult2.getDestructured();
            boolean bl = false;
            String string = (String)destructured2.getMatch().getGroupValues().get(1);
            destructured2 = destructured;
            bl = false;
            String buildNumber = (String)destructured2.getMatch().getGroupValues().get(2);
            String platformVersionText = "20" + StringsKt.take((String)platformNumber, (int)2) + "." + StringsKt.takeLast((String)platformNumber, (int)1);
            PlatformVersion platformVersion = new PlatformVersion(PlatformVersion.Platform.IDEA, platformVersionText);
            return new KidKotlinPluginVersion(buildNumber, platformVersion);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

