/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.codeInsight.highlighting.BraceMatcher;
import com.intellij.codeInsight.highlighting.BraceMatchingUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.editor.KotlinEditorOptions;
import org.jetbrains.kotlin.idea.editor.KotlinTypedHandlerInner;
import org.jetbrains.kotlin.idea.editor.LtGtTypingUtils;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;

public class KotlinTypedHandler
extends TypedHandlerDelegate {
    private boolean kotlinLTTyped;
    private boolean isGlobalPreviousDollarInString;
    private static final Key<Integer> PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY = Key.create((String)"PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY");

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file, @NotNull FileType fileType) {
        if (project2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            KotlinTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            KotlinTypedHandler.$$$reportNull$$$0(3);
        }
        if (!(file instanceof KtFile)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$0(4);
            }
            return result2;
        }
        switch (c) {
            case ')': {
                KotlinTypedHandler.dataClassValParameterInsert(project2, editor2, file, true);
                break;
            }
            case '<': {
                this.kotlinLTTyped = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.shouldAutoCloseAngleBracket(editor2.getCaretModel().getOffset(), editor2);
                KotlinTypedHandler.autoPopupParameterInfo(project2, editor2);
                TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.CONTINUE;
                if (result3 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(5);
                }
                return result3;
            }
            case '>': {
                if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && LtGtTypingUtils.handleKotlinGTInsert(editor2)) {
                    TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(6);
                    }
                    return result4;
                }
                TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.CONTINUE;
                if (result5 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(7);
                }
                return result5;
            }
            case '{': {
                int offset = editor2.getCaretModel().getOffset();
                if (offset == 0) {
                    TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result6 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(8);
                    }
                    return result6;
                }
                HighlighterIterator iterator = ((EditorEx)editor2).getHighlighter().createIterator(offset - 1);
                while (!iterator.atEnd() && iterator.getTokenType() == TokenType.WHITE_SPACE) {
                    iterator.retreat();
                }
                if (iterator.atEnd() || !KotlinTypedHandlerInner.SUPPRESS_AUTO_INSERT_CLOSE_BRACE_AFTER.contains(iterator.getTokenType())) {
                    AutoPopupController.getInstance((Project)project2).autoPopupParameterInfo(editor2, null);
                    TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.CONTINUE;
                    if (result7 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(9);
                    }
                    return result7;
                }
                int tokenBeforeBraceOffset = iterator.getStart();
                Document document = editor2.getDocument();
                PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
                PsiElement leaf = file.findElementAt(offset);
                if (leaf != null) {
                    ASTNode nonWhitespaceSibling;
                    PsiElement parent2 = leaf.getParent();
                    if (parent2 != null && KotlinTypedHandlerInner.CONTROL_FLOW_EXPRESSIONS.contains(parent2.getNode().getElementType()) && (nonWhitespaceSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)leaf.getNode())) != null && nonWhitespaceSibling.getStartOffset() == tokenBeforeBraceOffset) {
                        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)"{", (boolean)false, (boolean)true);
                        KotlinTypedHandler.indentBrace(project2, editor2);
                        TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.STOP;
                        if (result8 == null) {
                            KotlinTypedHandler.$$$reportNull$$$0(10);
                        }
                        return result8;
                    }
                    if (leaf.getText().equals("}") && parent2 instanceof KtFunctionLiteral && document.getLineNumber(offset) == document.getLineNumber(parent2.getTextRange().getStartOffset())) {
                        EditorModificationUtil.insertStringAtCaret((Editor)editor2, (String)"{} ", (boolean)false, (boolean)false);
                        editor2.getCaretModel().moveToOffset(offset + 1);
                        TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.STOP;
                        if (result9 == null) {
                            KotlinTypedHandler.$$$reportNull$$$0(11);
                        }
                        return result9;
                    }
                }
                TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
                if (result10 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(12);
                }
                return result10;
            }
            case '.': {
                KotlinTypedHandler.autoPopupMemberLookup(project2, editor2);
                TypedHandlerDelegate.Result result11 = TypedHandlerDelegate.Result.CONTINUE;
                if (result11 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(13);
                }
                return result11;
            }
            case '@': {
                KotlinTypedHandler.autoPopupLabelLookup(project2, editor2);
                KotlinTypedHandler.autoPopupKDocTag(project2, editor2);
                TypedHandlerDelegate.Result result12 = TypedHandlerDelegate.Result.CONTINUE;
                if (result12 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(14);
                }
                return result12;
            }
            case ':': {
                KotlinTypedHandler.autoPopupCallableReferenceLookup(project2, editor2);
                TypedHandlerDelegate.Result result13 = TypedHandlerDelegate.Result.CONTINUE;
                if (result13 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(15);
                }
                return result13;
            }
            case '[': {
                KotlinTypedHandler.autoPopupParameterInfo(project2, editor2);
                TypedHandlerDelegate.Result result14 = TypedHandlerDelegate.Result.CONTINUE;
                if (result14 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(16);
                }
                return result14;
            }
        }
        TypedHandlerDelegate.Result result15 = TypedHandlerDelegate.Result.CONTINUE;
        if (result15 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(17);
        }
        return result15;
    }

    private static void autoPopupParameterInfo(Project project2, Editor editor2) {
        int offset = editor2.getCaretModel().getOffset();
        if (offset == 0) {
            return;
        }
        HighlighterIterator iterator = ((EditorEx)editor2).getHighlighter().createIterator(offset - 1);
        IElementType tokenType = iterator.getTokenType();
        if (KtTokens.COMMENTS.contains(tokenType) || tokenType == KtTokens.REGULAR_STRING_PART || tokenType == KtTokens.OPEN_QUOTE || tokenType == KtTokens.CHARACTER_LITERAL) {
            return;
        }
        AutoPopupController.getInstance((Project)project2).autoPopupParameterInfo(editor2, null);
    }

    private static void autoPopupMemberLookup(Project project2, Editor editor2) {
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, file -> {
            int offset = editor2.getCaretModel().getOffset();
            PsiElement lastToken = file.findElementAt(offset - 1);
            if (lastToken == null) {
                return false;
            }
            IElementType elementType = lastToken.getNode().getElementType();
            if (elementType == KtTokens.DOT || elementType == KtTokens.SAFE_ACCESS) {
                return true;
            }
            if (elementType == KtTokens.REGULAR_STRING_PART && lastToken.getTextRange().getStartOffset() == offset - 1) {
                PsiElement prevSibling = lastToken.getParent().getPrevSibling();
                return prevSibling instanceof KtSimpleNameStringTemplateEntry;
            }
            return false;
        });
    }

    private static void autoPopupKDocTag(Project project2, Editor editor2) {
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, file -> {
            int offset = editor2.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            return lastElement.getNode().getElementType() == KDocTokens.TEXT;
        });
    }

    private static void autoPopupLabelLookup(Project project2, Editor editor2) {
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, file -> {
            int offset = editor2.getCaretModel().getOffset();
            CharSequence chars = editor2.getDocument().getCharsSequence();
            if (!(KotlinTypedHandler.endsWith(chars, offset, "this@") || KotlinTypedHandler.endsWith(chars, offset, "return@") || KotlinTypedHandler.endsWith(chars, offset, "break@") || KotlinTypedHandler.endsWith(chars, offset, "continue@"))) {
                return false;
            }
            PsiElement lastElement = file.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            return lastElement.getNode().getElementType() == KtTokens.AT;
        });
    }

    private static void autoPopupCallableReferenceLookup(Project project2, Editor editor2) {
        AutoPopupController.getInstance((Project)project2).autoPopupMemberLookup(editor2, file -> {
            int offset = editor2.getCaretModel().getOffset();
            PsiElement lastElement = file.findElementAt(offset - 1);
            if (lastElement == null) {
                return false;
            }
            return lastElement.getNode().getElementType() == KtTokens.COLONCOLON;
        });
    }

    private static boolean endsWith(CharSequence chars, int offset, String text2) {
        if (offset < text2.length()) {
            return false;
        }
        return chars.subSequence(offset - text2.length(), offset).toString().equals(text2);
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file) {
        int offset;
        PsiElement element3;
        if (project2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(18);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(19);
        }
        if (file == null) {
            KotlinTypedHandler.$$$reportNull$$$0(20);
        }
        if (!(file instanceof KtFile)) {
            TypedHandlerDelegate.Result result2 = TypedHandlerDelegate.Result.CONTINUE;
            if (result2 == null) {
                KotlinTypedHandler.$$$reportNull$$$0(21);
            }
            return result2;
        }
        Integer previousDollarInStringOffset = null;
        if (this.isGlobalPreviousDollarInString) {
            this.isGlobalPreviousDollarInString = false;
            previousDollarInStringOffset = (Integer)editor2.getUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY);
        }
        editor2.putUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY, null);
        if (this.kotlinLTTyped) {
            this.kotlinLTTyped = false;
            LtGtTypingUtils.handleKotlinAutoCloseLT(editor2);
            TypedHandlerDelegate.Result result3 = TypedHandlerDelegate.Result.STOP;
            if (result3 == null) {
                KotlinTypedHandler.$$$reportNull$$$0(22);
            }
            return result3;
        }
        if (c == ',' || c == ')') {
            KotlinTypedHandler.dataClassValParameterInsert(project2, editor2, file, false);
        } else if (c == '{' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
            int offset2 = editor2.getCaretModel().getOffset();
            PsiElement previousElement2 = file.findElementAt(offset2 - 1);
            if (previousElement2 instanceof LeafPsiElement && ((LeafPsiElement)previousElement2).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_START) {
                boolean isSimpleLongTemplateEntry;
                boolean isNextTokenIsIdentifier;
                PsiElement currentElement = file.findElementAt(offset2);
                boolean bl = isNextTokenIsIdentifier = currentElement instanceof LeafPsiElement && ((LeafPsiElement)currentElement).getElementType() == KtTokens.IDENTIFIER;
                if (!isNextTokenIsIdentifier) {
                    editor2.getDocument().insertString(offset2, (CharSequence)"}");
                    TypedHandlerDelegate.Result result4 = TypedHandlerDelegate.Result.STOP;
                    if (result4 == null) {
                        KotlinTypedHandler.$$$reportNull$$$0(23);
                    }
                    return result4;
                }
                PsiElement lastInLongTemplateEntry = previousElement2.getParent().getLastChild();
                boolean bl2 = isSimpleLongTemplateEntry = lastInLongTemplateEntry instanceof LeafPsiElement && ((LeafPsiElement)lastInLongTemplateEntry).getElementType() == KtTokens.LONG_TEMPLATE_ENTRY_END && lastInLongTemplateEntry.getParent().getTextLength() == currentElement.getTextLength() + "${}".length();
                if (!isSimpleLongTemplateEntry) {
                    boolean isAfterTypedDollar;
                    boolean bl3 = isAfterTypedDollar = previousDollarInStringOffset != null && previousDollarInStringOffset == offset2 - 1;
                    if (isAfterTypedDollar) {
                        editor2.getDocument().insertString(offset2, (CharSequence)"}");
                        TypedHandlerDelegate.Result result5 = TypedHandlerDelegate.Result.STOP;
                        if (result5 == null) {
                            KotlinTypedHandler.$$$reportNull$$$0(24);
                        }
                        return result5;
                    }
                }
            }
        } else if (c == ':') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project2, file, KtClassOrObject.class) || KotlinTypedHandler.autoIndentCase(editor2, project2, file, KtOperationReferenceExpression.class)) {
                TypedHandlerDelegate.Result result6 = TypedHandlerDelegate.Result.STOP;
                if (result6 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(25);
                }
                return result6;
            }
        } else if (c == '.') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project2, file, KtQualifiedExpression.class)) {
                TypedHandlerDelegate.Result result7 = TypedHandlerDelegate.Result.STOP;
                if (result7 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(26);
                }
                return result7;
            }
        } else if (c == '|') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project2, file, KtOperationReferenceExpression.class)) {
                TypedHandlerDelegate.Result result8 = TypedHandlerDelegate.Result.STOP;
                if (result8 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(27);
                }
                return result8;
            }
        } else if (c == '&') {
            if (KotlinTypedHandler.autoIndentCase(editor2, project2, file, KtOperationReferenceExpression.class)) {
                TypedHandlerDelegate.Result result9 = TypedHandlerDelegate.Result.STOP;
                if (result9 == null) {
                    KotlinTypedHandler.$$$reportNull$$$0(28);
                }
                return result9;
            }
        } else if (c == '$' && (element3 = file.findElementAt(offset = editor2.getCaretModel().getOffset())) instanceof LeafPsiElement && ((LeafPsiElement)element3).getElementType() == KtTokens.REGULAR_STRING_PART) {
            editor2.putUserData(PREVIOUS_IN_STRING_DOLLAR_TYPED_OFFSET_KEY, (Object)offset);
            this.isGlobalPreviousDollarInString = true;
        }
        TypedHandlerDelegate.Result result10 = TypedHandlerDelegate.Result.CONTINUE;
        if (result10 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(29);
        }
        return result10;
    }

    private static void dataClassValParameterInsert(@NotNull Project project2, @NotNull Editor editor2, @NotNull PsiFile file, boolean beforeType) {
        if (project2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(30);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(31);
        }
        if (file == null) {
            KotlinTypedHandler.$$$reportNull$$$0(32);
        }
        if (!KotlinEditorOptions.getInstance().isAutoAddValKeywordToDataClassParameters()) {
            return;
        }
        Document document = editor2.getDocument();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        int commaOffset = editor2.getCaretModel().getOffset();
        if (!beforeType) {
            --commaOffset;
        }
        if (commaOffset < 1) {
            return;
        }
        PsiElement elementOnCaret = file.findElementAt(commaOffset);
        if (elementOnCaret == null) {
            return;
        }
        boolean contextMatched = false;
        PsiElement parentElement = elementOnCaret.getParent();
        if (parentElement instanceof KtParameterList && (parentElement = parentElement.getParent()) instanceof KtPrimaryConstructor && (parentElement = parentElement.getParent()) instanceof KtClass) {
            KtClass klassElement = (KtClass)parentElement;
            boolean bl = contextMatched = klassElement.isData() || klassElement.hasModifier(KtTokens.INLINE_KEYWORD);
        }
        if (!contextMatched) {
            return;
        }
        PsiElement leftElement = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)elementOnCaret);
        if (!(leftElement instanceof KtParameter)) {
            return;
        }
        KtParameter ktParameter = (KtParameter)leftElement;
        KtTypeReference typeReference = ktParameter.getTypeReference();
        if (typeReference == null) {
            return;
        }
        if (ktParameter.hasValOrVar()) {
            return;
        }
        if (typeReference.getTextLength() == 0) {
            return;
        }
        document.insertString(leftElement.getTextOffset(), (CharSequence)"val ");
    }

    private static void indentBrace(@NotNull Project project2, @NotNull Editor editor2) {
        if (project2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(33);
        }
        if (editor2 == null) {
            KotlinTypedHandler.$$$reportNull$$$0(34);
        }
        int offset = editor2.getCaretModel().getOffset() - 1;
        Document document = editor2.getDocument();
        CharSequence chars = document.getCharsSequence();
        if (offset < 0 || chars.charAt(offset) != '{') {
            return;
        }
        int spaceStart = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t");
        if (spaceStart < 0 || chars.charAt(spaceStart) == '\n' || chars.charAt(spaceStart) == '\r') {
            boolean isBrace;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            documentManager.commitDocument(document);
            PsiFile file = documentManager.getPsiFile(document);
            if (file == null || !file.isWritable()) {
                return;
            }
            PsiElement element3 = file.findElementAt(offset);
            if (element3 == null) {
                return;
            }
            EditorHighlighter highlighter = ((EditorEx)editor2).getHighlighter();
            HighlighterIterator iterator = highlighter.createIterator(offset);
            FileType fileType = file.getFileType();
            BraceMatcher braceMatcher = BraceMatchingUtil.getBraceMatcher((FileType)fileType, (HighlighterIterator)iterator);
            boolean bl = isBrace = braceMatcher.isLBraceToken(iterator, chars, fileType) || braceMatcher.isRBraceToken(iterator, chars, fileType);
            if (element3.getNode() != null && isBrace) {
                ApplicationManager.getApplication().runWriteAction(() -> {
                    int newOffset = CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, offset);
                    editor2.getCaretModel().moveToOffset(newOffset + 1);
                    editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
                    editor2.getSelectionModel().removeSelection();
                });
            }
        }
    }

    private static boolean autoIndentCase(Editor editor2, Project project2, PsiFile file, Class<?> kclass) {
        int offset = editor2.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project2).commitDocument(editor2.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null) {
            PsiElement prevLeaf2 = PsiTreeUtil.prevLeaf((PsiElement)currElement);
            if (!(prevLeaf2 instanceof PsiWhiteSpace) || !prevLeaf2.getText().contains("\n")) {
                return false;
            }
            PsiElement parent2 = currElement.getParent();
            if (kclass.isInstance(parent2)) {
                int curElementLength = currElement.getText().length();
                if (offset < curElementLength) {
                    return false;
                }
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(file, offset - curElementLength);
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: 
            case 31: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/editor/KotlinTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "dataClassValParameterInsert";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "indentBrace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

