/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b\u001a\n\u0010\n\u001a\u00020\u0001*\u00020\u0006\u00a8\u0006\u000b"}, d2={"trailingCommaAllowedInModule", "", "source", "Lcom/intellij/psi/PsiElement;", "adjustLineIndent", "", "Lcom/intellij/psi/PsiFile;", "startOffset", "", "endOffset", "commitAndUnblockDocument", "kotlin.idea"})
public final class UtilsKt {
    public static final boolean commitAndUnblockDocument(@NotNull PsiFile $this$commitAndUnblockDocument) {
        Intrinsics.checkNotNullParameter((Object)$this$commitAndUnblockDocument, (String)"$this$commitAndUnblockDocument");
        VirtualFile virtualFile = $this$commitAndUnblockDocument.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026tualFile) ?: return false");
        Document document2 = document;
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)$this$commitAndUnblockDocument.getProject());
        documentManager.doPostponedOperationsAndUnblockDocument(document2);
        documentManager.commitDocument(document2);
        return true;
    }

    public static final void adjustLineIndent(@NotNull PsiFile $this$adjustLineIndent, int startOffset, int endOffset2) {
        Intrinsics.checkNotNullParameter((Object)$this$adjustLineIndent, (String)"$this$adjustLineIndent");
        if (!UtilsKt.commitAndUnblockDocument($this$adjustLineIndent)) {
            return;
        }
        CodeStyleManager.getInstance((Project)$this$adjustLineIndent.getProject()).adjustLineIndent($this$adjustLineIndent, new TextRange(startOffset, endOffset2));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean trailingCommaAllowedInModule(@NotNull PsiElement source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (Registry.is((String)"kotlin.formatter.allowTrailingCommaInAnyProject", (boolean)false)) return true;
        Module module = ProjectRootsUtilKt.getModule((PsiElement)source);
        Module module2 = module;
        if (module == null) return false;
        LanguageVersionSettings languageVersionSettings = PlatformKt.getLanguageVersionSettings((Module)module2);
        module2 = languageVersionSettings;
        if (languageVersionSettings == null) return false;
        if (!module2.supportsFeature(LanguageFeature.TrailingCommas)) return false;
        return true;
    }
}

