/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.caches.resolve;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.ModuleInfo;
import org.jetbrains.kotlin.analyzer.PlatformAnalysisParameters;
import org.jetbrains.kotlin.analyzer.ResolverForModuleFactory;
import org.jetbrains.kotlin.backend.common.serialization.metadata.KlibMetadataModuleDescriptorFactory;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.caches.resolve.IdePlatformKindResolution;
import org.jetbrains.kotlin.caches.resolve.JsKlibLibraryInfo;
import org.jetbrains.kotlin.caches.resolve.JsMetadataLibraryInfo;
import org.jetbrains.kotlin.caches.resolve.JsPlatformKindResolution;
import org.jetbrains.kotlin.caches.resolve.JsResolverForModuleFactory;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.context.ProjectContext;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProvider;
import org.jetbrains.kotlin.idea.caches.project.LibraryInfo;
import org.jetbrains.kotlin.idea.caches.project.SdkInfo;
import org.jetbrains.kotlin.idea.caches.resolve.BuiltInsCacheKey;
import org.jetbrains.kotlin.idea.framework.JSLibraryKind;
import org.jetbrains.kotlin.idea.klib.UtilsKt;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.konan.util.KlibMetadataFactories;
import org.jetbrains.kotlin.library.KotlinLibrary;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.impl.JsIdePlatformKind;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.resolve.TargetEnvironment;
import org.jetbrains.kotlin.serialization.deserialization.FlexibleTypeDeserializer;
import org.jetbrains.kotlin.serialization.js.DynamicTypeDeserializer;
import org.jetbrains.kotlin.serialization.konan.impl.KlibMetadataModuleDescriptorFactoryImpl;
import org.jetbrains.kotlin.storage.StorageManager;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 12\u00020\u0001:\u00011B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J*\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0016J\u001a\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010,\u001a\u0004\u0018\u00010\u0012H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/JsPlatformKindResolution;", "Lorg/jetbrains/kotlin/caches/resolve/IdePlatformKindResolution;", "()V", "kind", "Lorg/jetbrains/kotlin/platform/impl/JsIdePlatformKind;", "getKind", "()Lorg/jetbrains/kotlin/platform/impl/JsIdePlatformKind;", "libraryKind", "Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "getLibraryKind", "()Lcom/intellij/openapi/roots/libraries/PersistentLibraryKind;", "createBuiltIns", "Lorg/jetbrains/kotlin/builtins/KotlinBuiltIns;", "moduleInfo", "Lorg/jetbrains/kotlin/analyzer/ModuleInfo;", "projectContext", "Lorg/jetbrains/kotlin/context/ProjectContext;", "sdkDependency", "Lorg/jetbrains/kotlin/idea/caches/project/SdkInfo;", "createKlibPackageFragmentProvider", "Lorg/jetbrains/kotlin/descriptors/PackageFragmentProvider;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "createLibraryInfo", "", "Lorg/jetbrains/kotlin/idea/caches/project/LibraryInfo;", "project", "Lcom/intellij/openapi/project/Project;", "library", "Lcom/intellij/openapi/roots/libraries/Library;", "createResolverForModuleFactory", "Lorg/jetbrains/kotlin/analyzer/ResolverForModuleFactory;", "settings", "Lorg/jetbrains/kotlin/analyzer/PlatformAnalysisParameters;", "environment", "Lorg/jetbrains/kotlin/resolve/TargetEnvironment;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "getKeyForBuiltIns", "Lorg/jetbrains/kotlin/idea/caches/resolve/BuiltInsCacheKey;", "sdkInfo", "isLibraryFileForPlatform", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "kotlin.core"})
public final class JsPlatformKindResolution
implements IdePlatformKindResolution {
    private static final KlibMetadataFactories metadataFactories;
    private static final KlibMetadataModuleDescriptorFactoryImpl metadataModuleDescriptorFactory;
    public static final Companion Companion;

    @Override
    public boolean isLibraryFileForPlatform(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)"js") || Intrinsics.areEqual((Object)virtualFile.getExtension(), (Object)"kjsm") || UtilsKt.isKlibLibraryRootForPlatform(virtualFile, JsPlatforms.INSTANCE.getDefaultJsPlatform());
    }

    @Override
    @Nullable
    public PersistentLibraryKind<?> getLibraryKind() {
        return JSLibraryKind.INSTANCE;
    }

    @NotNull
    public JsIdePlatformKind getKind() {
        return JsIdePlatformKind.INSTANCE;
    }

    @Override
    @NotNull
    public BuiltInsCacheKey getKeyForBuiltIns(@NotNull ModuleInfo moduleInfo, @Nullable SdkInfo sdkInfo) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        return BuiltInsCacheKey.DefaultBuiltInsKey.INSTANCE;
    }

    @Override
    @NotNull
    public KotlinBuiltIns createBuiltIns(@NotNull ModuleInfo moduleInfo, @NotNull ProjectContext projectContext, @Nullable SdkInfo sdkDependency) {
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)projectContext, (String)"projectContext");
        return (KotlinBuiltIns)DefaultBuiltIns.Companion.getInstance();
    }

    @Override
    @NotNull
    public ResolverForModuleFactory createResolverForModuleFactory(@NotNull PlatformAnalysisParameters settings2, @NotNull TargetEnvironment environment, @NotNull TargetPlatform platform) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        return new JsResolverForModuleFactory(environment);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<LibraryInfo> createLibraryInfo(@NotNull Project project, @NotNull Library library) {
        List list;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)library, (String)"library");
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        Object $this$filter$iv = virtualFileArray;
        boolean $i$f$filter = false;
        VirtualFile[] virtualFileArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var9_8 = $this$filterTo$iv$iv;
        int n = ((void)var9_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var9_8[i];
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it");
            if (!UtilsKt.isKlibLibraryRootForPlatform((VirtualFile)v1, JsPlatforms.INSTANCE.getDefaultJsPlatform())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List klibFiles = (List)destination$iv$iv;
        $this$filter$iv = klibFiles;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty()) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = klibFiles;
            boolean $i$f$mapNotNull = false;
            $this$filterTo$iv$iv = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                JsKlibLibraryInfo jsKlibLibraryInfo;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (PathUtil.getLocalPath((VirtualFile)it) == null) {
                    jsKlibLibraryInfo = null;
                } else {
                    String path;
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"PathUtil.getLocalPath(it\u2026?: return@mapNotNull null");
                    jsKlibLibraryInfo = new JsKlibLibraryInfo(project, library, path);
                }
                if (jsKlibLibraryInfo == null) continue;
                JsKlibLibraryInfo jsKlibLibraryInfo2 = jsKlibLibraryInfo;
                boolean bl3 = false;
                boolean bl4 = false;
                JsKlibLibraryInfo it$iv$iv = jsKlibLibraryInfo2;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.listOf((Object)new JsMetadataLibraryInfo(project, library));
        }
        return list;
    }

    @Override
    @Nullable
    public PackageFragmentProvider createKlibPackageFragmentProvider(@NotNull ModuleInfo moduleInfo, @NotNull StorageManager storageManager, @NotNull LanguageVersionSettings languageVersionSettings, @NotNull ModuleDescriptor moduleDescriptor) {
        JsKlibLibraryInfo jsKlibLibraryInfo;
        Intrinsics.checkNotNullParameter((Object)moduleInfo, (String)"moduleInfo");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        ModuleInfo moduleInfo2 = moduleInfo;
        if (!(moduleInfo2 instanceof JsKlibLibraryInfo)) {
            moduleInfo2 = null;
        }
        return (jsKlibLibraryInfo = (JsKlibLibraryInfo)moduleInfo2) != null && (jsKlibLibraryInfo = jsKlibLibraryInfo.getResolvedKotlinLibrary()) != null ? UtilsKt.createKlibPackageFragmentProvider((KotlinLibrary)jsKlibLibraryInfo, storageManager, (KlibMetadataModuleDescriptorFactory)metadataModuleDescriptorFactory, languageVersionSettings, moduleDescriptor, (LookupTracker)LookupTracker.DO_NOTHING.INSTANCE) : null;
    }

    static {
        Companion = new Companion(null);
        metadataFactories = new KlibMetadataFactories((Function1)Companion.metadataFactories.1.INSTANCE, (FlexibleTypeDeserializer)DynamicTypeDeserializer.INSTANCE);
        metadataModuleDescriptorFactory = new KlibMetadataModuleDescriptorFactoryImpl(metadataFactories.getDefaultDescriptorFactory(), metadataFactories.getDefaultPackageFragmentsFactory(), metadataFactories.getFlexibleTypeDeserializer(), metadataFactories.getPlatformDependentTypeTransformer());
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/caches/resolve/JsPlatformKindResolution$Companion;", "", "()V", "metadataFactories", "Lorg/jetbrains/kotlin/konan/util/KlibMetadataFactories;", "metadataModuleDescriptorFactory", "Lorg/jetbrains/kotlin/serialization/konan/impl/KlibMetadataModuleDescriptorFactoryImpl;", "kotlin.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

