/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script;

import com.intellij.diagnostic.PluginException;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.script.experimental.annotations.KotlinScript;
import kotlin.script.experimental.host.HostConfigurationKt;
import kotlin.script.experimental.host.ScriptingHostConfiguration;
import kotlin.script.experimental.host.ScriptingHostConfigurationKeys;
import kotlin.script.experimental.jvm.JvmDependency;
import kotlin.script.templates.ScriptTemplateDefinition;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptDefinitionSourceFromContributor;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinitionsSource;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aP\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0007\u001a\u00020\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b\u001a\n\u0010\f\u001a\u00020\r*\u00020\u000e\u00a8\u0006\u000f"}, d2={"loadDefinitionsFromTemplates", "", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinition;", "templateClassNames", "", "templateClasspath", "Ljava/io/File;", "baseHostConfiguration", "Lkotlin/script/experimental/host/ScriptingHostConfiguration;", "additionalResolverClasspath", "defaultCompilerOptions", "", "asSource", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDefinitionsSource;", "Lorg/jetbrains/kotlin/idea/core/script/ScriptDefinitionContributor;", "kotlin.core"})
public final class ScriptDefinitionsManagerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ScriptDefinition> loadDefinitionsFromTemplates(@NotNull List<String> templateClassNames, @NotNull List<? extends File> templateClasspath, @NotNull ScriptingHostConfiguration baseHostConfiguration, @NotNull List<? extends File> additionalResolverClasspath, @NotNull Iterable<String> defaultCompilerOptions) {
        void $this$mapNotNullTo$iv$iv;
        Iterable thisCollection$iv;
        Object object;
        Collection destination$iv$iv;
        ClassLoader classLoader;
        Intrinsics.checkNotNullParameter(templateClassNames, (String)"templateClassNames");
        Intrinsics.checkNotNullParameter(templateClasspath, (String)"templateClasspath");
        Intrinsics.checkNotNullParameter((Object)baseHostConfiguration, (String)"baseHostConfiguration");
        Intrinsics.checkNotNullParameter(additionalResolverClasspath, (String)"additionalResolverClasspath");
        Intrinsics.checkNotNullParameter(defaultCompilerOptions, (String)"defaultCompilerOptions");
        List classpath = CollectionsKt.plus((Collection)templateClasspath, (Iterable)additionalResolverClasspath);
        StringBuilder stringBuilder = new StringBuilder().append("Loading script definitions ").append(templateClassNames).append(" using classpath: ");
        Iterable iterable = classpath;
        String string = File.pathSeparator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"File.pathSeparator");
        ScriptUtilsKt.scriptingInfoLog(stringBuilder.append(CollectionsKt.joinToString$default((Iterable)iterable, (CharSequence)string, null, null, (int)0, null, null, (int)62, null)).toString());
        ClassLoader baseLoader = ScriptDefinitionContributor.class.getClassLoader();
        if (classpath.isEmpty()) {
            classLoader = baseLoader;
        } else {
            Collection<URL> collection;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = classpath;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object = (File)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                URL uRL = it.toURI().toURL();
                collection.add(uRL);
            }
            collection = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            URL[] uRLArray = thisCollection$iv.toArray(new URL[0]);
            if (uRLArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ClassLoader classLoader2 = baseLoader;
            URL[] uRLArray2 = uRLArray;
            classLoader = new URLClassLoader(uRLArray2, classLoader2);
        }
        ClassLoader loader = classLoader;
        Iterable $this$mapNotNull$iv = templateClassNames;
        boolean $i$f$mapNotNull = false;
        thisCollection$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            ScriptDefinition scriptDefinition;
            ScriptDefinition scriptDefinition2;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            String templateClassName = (String)element$iv$iv;
            boolean bl2 = false;
            try {
                ScriptDefinition scriptDefinition3;
                Object v6;
                boolean $i$f$firstIsInstanceOrNull;
                Iterable $this$firstIsInstanceOrNull$iv;
                ScriptingHostConfiguration hostConfiguration;
                KClass template;
                block17: {
                    Class<?> clazz = loader.loadClass(templateClassName);
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"loader.loadClass(templateClassName)");
                    template = JvmClassMappingKt.getKotlinClass(clazz);
                    hostConfiguration = new ScriptingHostConfiguration(new ScriptingHostConfiguration[]{baseHostConfiguration}, (Function1)new Function1<ScriptingHostConfiguration.Builder, Unit>(loader, baseHostConfiguration, templateClasspath, defaultCompilerOptions){
                        final /* synthetic */ ClassLoader $loader$inlined;
                        final /* synthetic */ ScriptingHostConfiguration $baseHostConfiguration$inlined;
                        final /* synthetic */ List $templateClasspath$inlined;
                        final /* synthetic */ Iterable $defaultCompilerOptions$inlined;
                        {
                            this.$loader$inlined = classLoader;
                            this.$baseHostConfiguration$inlined = scriptingHostConfiguration;
                            this.$templateClasspath$inlined = list;
                            this.$defaultCompilerOptions$inlined = iterable;
                            super(1);
                        }

                        public final void invoke(@NotNull ScriptingHostConfiguration.Builder $receiver) {
                            Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                            $receiver.invoke(HostConfigurationKt.getConfigurationDependencies((ScriptingHostConfigurationKeys)((ScriptingHostConfigurationKeys)$receiver)), (Object[])new JvmDependency[]{new JvmDependency(this.$templateClasspath$inlined)});
                        }
                    });
                    $this$firstIsInstanceOrNull$iv = template.getAnnotations();
                    $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                        if (!(element$iv instanceof ScriptTemplateDefinition)) continue;
                        v6 = element$iv;
                        break block17;
                    }
                    v6 = null;
                }
                if (v6 != null) {
                    scriptDefinition3 = (ScriptDefinition)new ScriptDefinition.FromLegacyTemplate(hostConfiguration, template, templateClasspath, defaultCompilerOptions);
                } else {
                    Object v8;
                    block18: {
                        $this$firstIsInstanceOrNull$iv = template.getAnnotations();
                        $i$f$firstIsInstanceOrNull = false;
                        for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                            if (!(element$iv instanceof KotlinScript)) continue;
                            v8 = element$iv;
                            break block18;
                        }
                        v8 = null;
                    }
                    if (v8 != null) {
                        scriptDefinition3 = (ScriptDefinition)new ScriptDefinition.FromTemplate(hostConfiguration, template, Reflection.getOrCreateKotlinClass(ScriptDefinition.class), defaultCompilerOptions);
                    } else {
                        ScriptUtilsKt.scriptingWarnLog("Cannot find a valid script definition annotation on the class " + template);
                        scriptDefinition3 = null;
                    }
                }
                scriptDefinition2 = scriptDefinition3;
            }
            catch (ClassNotFoundException e) {
                ScriptUtilsKt.scriptingWarnLog("Cannot load script definition class " + templateClassName);
                scriptDefinition2 = null;
            }
            catch (Throwable e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                String message = "Cannot load script definition class " + templateClassName;
                PluginId thirdPartyPlugin = PluginManagerCore.getPluginByClassName((String)templateClassName);
                if (thirdPartyPlugin != null) {
                    ScriptUtilsKt.scriptingErrorLog(message, (Throwable)new PluginException(message, e, thirdPartyPlugin));
                } else {
                    ScriptUtilsKt.scriptingErrorLog(message, e);
                }
                scriptDefinition2 = null;
            }
            if (scriptDefinition2 == null) continue;
            boolean bl3 = false;
            boolean bl4 = false;
            ScriptDefinition it$iv$iv = scriptDefinition;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List loadDefinitionsFromTemplates$default(List list, List list2, ScriptingHostConfiguration scriptingHostConfiguration, List list3, Iterable iterable, int n, Object object) {
        if ((n & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        return ScriptDefinitionsManagerKt.loadDefinitionsFromTemplates(list, list2, scriptingHostConfiguration, list3, iterable);
    }

    @NotNull
    public static final ScriptDefinitionsSource asSource(@NotNull ScriptDefinitionContributor $this$asSource) {
        Intrinsics.checkNotNullParameter((Object)$this$asSource, (String)"$this$asSource");
        return $this$asSource instanceof ScriptDefinitionsSource ? (ScriptDefinitionsSource)$this$asSource : (ScriptDefinitionsSource)new ScriptDefinitionSourceFromContributor($this$asSource, null, 2, null);
    }
}

