/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingColors;
import org.jetbrains.kotlin.idea.highlighter.KotlinHighlightingLexer;
import org.jetbrains.kotlin.kdoc.lexer.KDocTokens;
import org.jetbrains.kotlin.lexer.KtTokens;

public class KotlinHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    private static final Map<IElementType, TextAttributesKey> keys2 = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public Lexer getHighlightingLexer() {
        return new KotlinHighlightingLexer();
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = KotlinHighlighter.pack((TextAttributesKey)keys1.get(tokenType), (TextAttributesKey)keys2.get(tokenType));
        if (textAttributesKeyArray == null) {
            KotlinHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    static {
        KotlinHighlighter.fillMap(keys1, (TokenSet)KtTokens.KEYWORDS, (TextAttributesKey)KotlinHighlightingColors.KEYWORD);
        keys1.put((IElementType)KtTokens.VAL_KEYWORD, KotlinHighlightingColors.VAL_KEYWORD);
        keys1.put((IElementType)KtTokens.VAR_KEYWORD, KotlinHighlightingColors.VAR_KEYWORD);
        keys1.put((IElementType)KtTokens.AS_SAFE, KotlinHighlightingColors.KEYWORD);
        keys1.put((IElementType)KtTokens.INTEGER_LITERAL, KotlinHighlightingColors.NUMBER);
        keys1.put((IElementType)KtTokens.FLOAT_LITERAL, KotlinHighlightingColors.NUMBER);
        KotlinHighlighter.fillMap(keys1, (TokenSet)TokenSet.andNot((TokenSet)KtTokens.OPERATIONS, (TokenSet)TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{KtTokens.IDENTIFIER, KtTokens.AT}), KtTokens.KEYWORDS})), (TextAttributesKey)KotlinHighlightingColors.OPERATOR_SIGN);
        keys1.put((IElementType)KtTokens.LPAR, KotlinHighlightingColors.PARENTHESIS);
        keys1.put((IElementType)KtTokens.RPAR, KotlinHighlightingColors.PARENTHESIS);
        keys1.put((IElementType)KtTokens.LBRACE, KotlinHighlightingColors.BRACES);
        keys1.put((IElementType)KtTokens.RBRACE, KotlinHighlightingColors.BRACES);
        keys1.put((IElementType)KtTokens.LBRACKET, KotlinHighlightingColors.BRACKETS);
        keys1.put((IElementType)KtTokens.RBRACKET, KotlinHighlightingColors.BRACKETS);
        keys1.put((IElementType)KtTokens.COMMA, KotlinHighlightingColors.COMMA);
        keys1.put((IElementType)KtTokens.SEMICOLON, KotlinHighlightingColors.SEMICOLON);
        keys1.put((IElementType)KtTokens.COLON, KotlinHighlightingColors.COLON);
        keys1.put((IElementType)KtTokens.COLONCOLON, KotlinHighlightingColors.DOUBLE_COLON);
        keys1.put((IElementType)KtTokens.QUEST, KotlinHighlightingColors.QUEST);
        keys1.put((IElementType)KtTokens.DOT, KotlinHighlightingColors.DOT);
        keys1.put((IElementType)KtTokens.ARROW, KotlinHighlightingColors.ARROW);
        keys1.put((IElementType)KtTokens.OPEN_QUOTE, KotlinHighlightingColors.STRING);
        keys1.put((IElementType)KtTokens.CLOSING_QUOTE, KotlinHighlightingColors.STRING);
        keys1.put((IElementType)KtTokens.REGULAR_STRING_PART, KotlinHighlightingColors.STRING);
        keys1.put((IElementType)KtTokens.LONG_TEMPLATE_ENTRY_END, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put((IElementType)KtTokens.LONG_TEMPLATE_ENTRY_START, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put((IElementType)KtTokens.SHORT_TEMPLATE_ENTRY_START, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put((IElementType)KtTokens.ESCAPE_SEQUENCE, KotlinHighlightingColors.STRING_ESCAPE);
        keys1.put((IElementType)KtTokens.CHARACTER_LITERAL, KotlinHighlightingColors.STRING);
        keys1.put((IElementType)KtTokens.EOL_COMMENT, KotlinHighlightingColors.LINE_COMMENT);
        keys1.put((IElementType)KtTokens.SHEBANG_COMMENT, KotlinHighlightingColors.LINE_COMMENT);
        keys1.put((IElementType)KtTokens.BLOCK_COMMENT, KotlinHighlightingColors.BLOCK_COMMENT);
        keys1.put(KtTokens.DOC_COMMENT, KotlinHighlightingColors.DOC_COMMENT);
        KotlinHighlighter.fillMap(keys1, (TokenSet)KDocTokens.KDOC_HIGHLIGHT_TOKENS, (TextAttributesKey)KotlinHighlightingColors.DOC_COMMENT);
        keys1.put((IElementType)KDocTokens.TAG_NAME, KotlinHighlightingColors.DOC_COMMENT);
        keys2.put((IElementType)KDocTokens.TAG_NAME, KotlinHighlightingColors.KDOC_TAG);
        keys1.put(TokenType.BAD_CHARACTER, KotlinHighlightingColors.BAD_CHARACTER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/idea/highlighter/KotlinHighlighter", "getTokenHighlights"));
    }
}

