/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.roots.DependencyScope;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.ManifestBuilder;

public abstract class ManifestImporter {
    public static final ExtensionPointName<ManifestImporter> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.manifestImporter");

    @NotNull
    public static ManifestImporter getManifestImporter(@NotNull String packaging) {
        if (packaging == null) {
            ManifestImporter.$$$reportNull$$$0(0);
        }
        for (ManifestImporter importer : (ManifestImporter[])EXTENSION_POINT_NAME.getExtensions()) {
            if (!importer.isApplicable(packaging)) continue;
            ManifestImporter manifestImporter = importer;
            if (manifestImporter == null) {
                ManifestImporter.$$$reportNull$$$0(1);
            }
            return manifestImporter;
        }
        return new DefaultManifestImporter();
    }

    @NotNull
    public String getClasspath(@NotNull MavenProject mavenProject, @Nullable Element manifestConfiguration) {
        if (mavenProject == null) {
            ManifestImporter.$$$reportNull$$$0(2);
        }
        StringBuilder classpath = new StringBuilder();
        String classpathPrefix = ManifestBuilder.getClasspathPrefix(manifestConfiguration);
        for (MavenArtifact mavenArtifact : mavenProject.getDependencies()) {
            DependencyScope scope = MavenModuleImporter.selectScope(mavenArtifact.getScope());
            if (!scope.isForProductionCompile() && !scope.isForProductionRuntime()) continue;
            if (classpath.length() > 0) {
                classpath.append(" ");
            }
            classpath.append(classpathPrefix);
            String artifactFileName = mavenArtifact.getArtifactId() + "-" + mavenArtifact.getVersion() + "." + mavenArtifact.getExtension();
            classpath.append(this.doGetClasspathItem(mavenProject, mavenArtifact, artifactFileName));
        }
        String string = classpath.toString();
        if (string == null) {
            ManifestImporter.$$$reportNull$$$0(3);
        }
        return string;
    }

    protected abstract boolean isApplicable(String var1);

    protected abstract String doGetClasspathItem(@NotNull MavenProject var1, @NotNull MavenArtifact var2, @NotNull String var3);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packaging";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/importing/ManifestImporter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/importing/ManifestImporter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getManifestImporter";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClasspath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getManifestImporter";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClasspath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class DefaultManifestImporter
    extends ManifestImporter {
        private DefaultManifestImporter() {
        }

        @Override
        protected boolean isApplicable(String packaging) {
            return true;
        }

        @Override
        protected String doGetClasspathItem(@NotNull MavenProject mavenProject, @NotNull MavenArtifact mavenArtifact, @NotNull String artifactFileName) {
            if (mavenProject == null) {
                DefaultManifestImporter.$$$reportNull$$$0(0);
            }
            if (mavenArtifact == null) {
                DefaultManifestImporter.$$$reportNull$$$0(1);
            }
            if (artifactFileName == null) {
                DefaultManifestImporter.$$$reportNull$$$0(2);
            }
            return artifactFileName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mavenProject";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "mavenArtifact";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "artifactFileName";
                    break;
                }
            }
            objectArray[1] = "org/jetbrains/idea/maven/importing/ManifestImporter$DefaultManifestImporter";
            objectArray[2] = "doGetClasspathItem";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

