/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.DynamicBundle;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentType;
import com.intellij.execution.target.TargetEnvironmentsManager;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRCSettingsWatcher;
import org.jetbrains.idea.maven.execution.MavenSettingsObservable;
import org.jetbrains.idea.maven.execution.target.MavenRuntimeTargetConfiguration;
import org.jetbrains.idea.maven.project.MavenConfigurableBundle;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectBundle;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenEnvironmentForm
implements PanelWithAnchor,
MavenSettingsObservable {
    private JPanel panel;
    private LabeledComponent<ComponentWithBrowseButton<TextFieldWithHistory>> mavenHomeComponent;
    private ContextHelpLabel mavenHomeOnTargetHelpLabel;
    private TextFieldWithHistory mavenHomeField;
    private LabeledComponent<JBLabel> mavenVersionLabelComponent;
    private LabeledComponent<TextFieldWithBrowseButton> settingsFileComponent;
    private LabeledComponent<TextFieldWithBrowseButton> localRepositoryComponent;
    private JCheckBox settingsOverrideCheckBox;
    private JCheckBox localRepositoryOverrideCheckBox;
    private JComponent anchor;
    private final PathOverrider userSettingsFileOverrider;
    private final PathOverrider localRepositoryOverrider;
    private boolean isUpdating = false;
    private final Alarm myUpdateAlarm;
    private String myTargetName;

    public MavenEnvironmentForm() {
        this.$$$setupUI$$$();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        DocumentAdapter listener2 = new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (MavenEnvironmentForm.this.isUpdating) {
                        return;
                    }
                    if (!MavenEnvironmentForm.this.panel.isShowing()) {
                        return;
                    }
                    MavenEnvironmentForm.this.myUpdateAlarm.cancelAllRequests();
                    MavenEnvironmentForm.this.myUpdateAlarm.addRequest(() -> {
                        MavenEnvironmentForm.this.isUpdating = true;
                        MavenEnvironmentForm.this.userSettingsFileOverrider.updateDefault();
                        MavenEnvironmentForm.this.localRepositoryOverrider.updateDefault();
                        MavenEnvironmentForm.this.isUpdating = false;
                    }, 100);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/MavenEnvironmentForm$1", "textChanged"));
            }
        };
        this.userSettingsFileOverrider = new PathOverrider(this.settingsFileComponent, this.settingsOverrideCheckBox, (DocumentListener)listener2, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveUserSettingsFile("");
            }
        });
        this.localRepositoryOverrider = new PathOverrider(this.localRepositoryComponent, this.localRepositoryOverrideCheckBox, (DocumentListener)listener2, new PathProvider(){

            @Override
            @Nullable
            protected File getFile() {
                return MavenUtil.resolveLocalRepository("", FileUtil.toSystemIndependentName((String)MavenEnvironmentForm.this.mavenHomeField.getText().trim()), ((TextFieldWithBrowseButton)MavenEnvironmentForm.this.settingsFileComponent.getComponent()).getText());
            }
        });
        this.mavenHomeField.addDocumentListener((DocumentListener)listener2);
        this.setAnchor((JComponent)this.mavenHomeComponent.getLabel());
    }

    private void createUIComponents() {
        this.mavenHomeField = new TextFieldWithHistory();
        this.mavenHomeField.setHistorySize(-1);
        ArrayList<String> foundMavenHomes = new ArrayList<String>();
        foundMavenHomes.add("Bundled (Maven 3)");
        File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(null);
        File bundledMavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory("Bundled (Maven 3)");
        if (mavenHomeDirectory != null && !FileUtil.filesEqual((File)mavenHomeDirectory, (File)bundledMavenHomeDirectory)) {
            foundMavenHomes.add(FileUtil.toSystemIndependentName((String)mavenHomeDirectory.getPath()));
        }
        this.mavenHomeField.setHistory(foundMavenHomes);
        this.mavenHomeComponent = LabeledComponent.create((JComponent)new ComponentWithBrowseButton((JComponent)this.mavenHomeField, null), (String)MavenConfigurableBundle.message("maven.settings.environment.home.directory", new Object[0]));
        this.mavenHomeOnTargetHelpLabel = ContextHelpLabel.create((String)MavenConfigurableBundle.message("maven.settings.on.targets.environment.home.directory.context.help", new Object[0]));
        this.mavenHomeOnTargetHelpLabel.setVisible(false);
        this.mavenHomeOnTargetHelpLabel.setOpaque(true);
        this.mavenHomeComponent.add((Component)this.mavenHomeOnTargetHelpLabel, (Object)"East");
        JBLabel versionLabel = new JBLabel();
        versionLabel.setOpaque(true);
        versionLabel.setVerticalAlignment(1);
        versionLabel.setVerticalTextPosition(1);
        this.mavenVersionLabelComponent = LabeledComponent.create((JComponent)versionLabel, (String)"");
    }

    public boolean isModified(MavenGeneralSettings data) {
        MavenGeneralSettings formData = new MavenGeneralSettings();
        this.setData(formData);
        return !formData.equals(data);
    }

    public void setData(MavenGeneralSettings data) {
        data.setMavenHome(FileUtil.toSystemIndependentName((String)this.mavenHomeField.getText().trim()));
        data.setUserSettingsFile(this.userSettingsFileOverrider.getResult());
        data.setLocalRepository(this.localRepositoryOverrider.getResult());
    }

    public void getData(MavenGeneralSettings data) {
        String text;
        String resolvedMavenHome = MavenEnvironmentForm.resolveMavenHome(data.getMavenHome());
        String mavenHome = (String)ObjectUtils.chooseNotNull((Object)resolvedMavenHome, (Object)data.getMavenHome());
        String string = text = mavenHome != null ? FileUtil.toSystemIndependentName((String)mavenHome) : null;
        if ("Bundled (Maven 3)".equals(mavenHome)) {
            text = MavenProjectBundle.message("maven.bundled.version.title", new Object[0]);
        }
        this.mavenHomeField.setText(text);
        this.mavenHomeField.addCurrentTextToHistory();
        this.updateMavenVersionLabel();
        this.userSettingsFileOverrider.reset(data.getUserSettingsFile());
        this.localRepositoryOverrider.reset(data.getLocalRepository());
    }

    @Override
    public void registerSettingsWatcher(@NotNull MavenRCSettingsWatcher watcher) {
        if (watcher == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(0);
        }
        watcher.registerComponent("mavenHome", (Component)this.mavenHomeField);
        watcher.registerComponent("settingsFileOverride.checkbox", this.userSettingsFileOverrider.checkBox);
        watcher.registerComponent("settingsFileOverride.text", (Component)this.userSettingsFileOverrider.component);
        watcher.registerComponent("localRepoOverride.checkbox", this.localRepositoryOverrider.checkBox);
        watcher.registerComponent("localRepoOverride.text", (Component)this.localRepositoryOverrider.component);
    }

    @Nullable
    private static String resolveMavenHome(@Nullable String mavenHome) {
        if (StringUtil.equals((CharSequence)"Bundled (Maven 3)", (CharSequence)mavenHome)) {
            return mavenHome;
        }
        File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(mavenHome);
        return mavenHomeDirectory != null ? mavenHomeDirectory.getPath() : null;
    }

    private void updateMavenVersionLabel() {
        boolean localTarget = this.myTargetName == null;
        String version = MavenUtil.getMavenVersion(MavenServerManager.getMavenHomeFile(this.getMavenHome()));
        String versionText = null;
        if (version != null) {
            versionText = MavenProjectBundle.message("label.invalid.maven.home.version", version);
        } else if (localTarget) {
            versionText = MavenProjectBundle.message("label.invalid.maven.home.directory", new Object[0]);
        }
        ((JBLabel)this.mavenVersionLabelComponent.getComponent()).setText(StringUtil.notNullize((String)versionText));
    }

    @Nullable
    public String getMavenHome() {
        String mavenHome = FileUtil.toSystemIndependentName((String)this.mavenHomeField.getText().trim());
        File mavenHomeFile = MavenServerManager.getMavenHomeFile(mavenHome);
        return mavenHomeFile != null ? mavenHomeFile.getPath() : null;
    }

    public JComponent createComponent() {
        ((ComponentWithBrowseButton)this.mavenHomeComponent.getComponent()).addBrowseFolderListener(MavenProjectBundle.message("maven.select.maven.home.directory", new Object[0]), "", null, BrowseFilesListener.SINGLE_DIRECTORY_DESCRIPTOR, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
        this.mavenHomeField.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    4.$$$reportNull$$$0(0);
                }
                MavenEnvironmentForm.this.updateMavenVersionLabel();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/idea/maven/project/MavenEnvironmentForm$4", "textChanged"));
            }
        });
        ((TextFieldWithBrowseButton)this.settingsFileComponent.getComponent()).addBrowseFolderListener(MavenProjectBundle.message("maven.select.maven.settings.file", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
        ((TextFieldWithBrowseButton)this.localRepositoryComponent.getComponent()).addBrowseFolderListener(MavenProjectBundle.message("maven.select.local.repository", new Object[0]), "", null, FileChooserDescriptorFactory.createSingleFolderDescriptor());
        return this.panel;
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.mavenHomeComponent.setAnchor(anchor);
        this.mavenVersionLabelComponent.setAnchor(anchor);
        this.settingsFileComponent.setAnchor(anchor);
        this.localRepositoryComponent.setAnchor(anchor);
    }

    @ApiStatus.Internal
    void apply(@NotNull Project project, @Nullable String targetName) {
        boolean targetChanged;
        if (project == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(1);
        }
        boolean localTarget = targetName == null;
        boolean bl = targetChanged = !Objects.equals(this.myTargetName, targetName);
        if (targetChanged) {
            String mavenHomeInputLabel;
            this.myTargetName = targetName;
            ((ComponentWithBrowseButton)this.mavenHomeComponent.getComponent()).getButton().setVisible(localTarget);
            this.mavenHomeOnTargetHelpLabel.setVisible(!localTarget);
            if (localTarget) {
                mavenHomeInputLabel = MavenConfigurableBundle.message("maven.settings.environment.home.directory", new Object[0]);
            } else {
                TargetEnvironmentsManager targetManager = TargetEnvironmentsManager.getInstance((Project)project);
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)targetManager.getTargets().findByName(targetName);
                String typeId = targetEnvironmentConfiguration != null ? targetEnvironmentConfiguration.getTypeId() : null;
                TargetEnvironmentType targetEnvironmentType = null;
                if (typeId != null) {
                    targetEnvironmentType = (TargetEnvironmentType)TargetEnvironmentType.EXTENSION_NAME.findFirstSafe(type -> type.getId() == typeId);
                }
                mavenHomeInputLabel = targetEnvironmentType != null ? MessageFormat.format("<html><body><nobr>{0}</nobr></body></html>", MavenConfigurableBundle.message("maven.settings.on.targets.environment.home.directory", targetEnvironmentType.getDisplayName())) : MavenConfigurableBundle.message("maven.settings.environment.home.directory", new Object[0]);
            }
            this.mavenHomeComponent.setText(mavenHomeInputLabel);
            this.reloadMavenHomeComponents(project, targetName);
        } else if (!localTarget) {
            this.reloadMavenHomeComponents(project, targetName);
        }
    }

    private void reloadMavenHomeComponents(@NotNull Project project, @Nullable String targetName) {
        if (project == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(2);
        }
        List<String> targetMavenHomes = MavenEnvironmentForm.findTargetMavenHomes(project, targetName);
        if (!this.mavenHomeField.getHistory().equals(targetMavenHomes)) {
            EdtInvocationManager.getInstance().invokeLater(() -> this.mavenHomeField.setHistory(targetMavenHomes));
        }
        String mavenHomeFieldText = this.mavenHomeField.getText();
        if (targetMavenHomes.isEmpty()) {
            if (!mavenHomeFieldText.isEmpty()) {
                EdtInvocationManager.getInstance().invokeLater(() -> this.mavenHomeField.setSelectedItem((Object)""));
            }
        } else if (!targetMavenHomes.contains(mavenHomeFieldText)) {
            EdtInvocationManager.getInstance().invokeLater(() -> {
                if (!targetMavenHomes.contains(this.mavenHomeField.getText())) {
                    this.mavenHomeField.setSelectedItem(targetMavenHomes.get(0));
                }
            });
        }
    }

    private static List<String> findTargetMavenHomes(@NotNull Project project, @Nullable String targetName) {
        boolean localTarget;
        if (project == null) {
            MavenEnvironmentForm.$$$reportNull$$$0(3);
        }
        List<String> mavenHomes = new ArrayList<String>();
        boolean bl = localTarget = targetName == null;
        if (localTarget) {
            mavenHomes.add("Bundled (Maven 3)");
            File mavenHomeDirectory = MavenUtil.resolveMavenHomeDirectory(null);
            if (mavenHomeDirectory != null) {
                mavenHomes.add(FileUtil.toSystemIndependentName((String)mavenHomeDirectory.getPath()));
            }
        } else {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = (TargetEnvironmentConfiguration)TargetEnvironmentsManager.getInstance((Project)project).getTargets().findByName(targetName);
            if (targetEnvironmentConfiguration != null) {
                mavenHomes = targetEnvironmentConfiguration.getRuntimes().resolvedConfigs().stream().filter(runtimeConfiguration -> runtimeConfiguration instanceof MavenRuntimeTargetConfiguration).map(runtimeConfiguration -> ((MavenRuntimeTargetConfiguration)((Object)runtimeConfiguration)).getHomePath()).collect(Collectors.toList());
            }
        }
        return mavenHomes;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watcher";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/project/MavenEnvironmentForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "registerSettingsWatcher";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "apply";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadMavenHomeComponents";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findTargetMavenHomes";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox2;
        LabeledComponent labeledComponent2;
        JPanel jPanel;
        this.createUIComponents();
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.settingsFileComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.environment.user.settings"));
        jPanel.add((Component)labeledComponent2, new GridConstraints(2, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.settingsOverrideCheckBox = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.override"));
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.localRepositoryComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setLabelLocation("West");
        labeledComponent.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.environment.local.repository"));
        jPanel.add((Component)labeledComponent, new GridConstraints(3, 0, 1, 1, 0, 1, 7, 3, null, null, null));
        this.localRepositoryOverrideCheckBox = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.override"));
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 1, 1, 1, 4, 0, 3, 0, null, null, null));
        LabeledComponent<ComponentWithBrowseButton<TextFieldWithHistory>> labeledComponent3 = this.mavenHomeComponent;
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setText(DynamicBundle.getBundle((String)"messages/MavenConfigurableBundle", MavenEnvironmentForm.class).getString("maven.settings.environment.home.directory"));
        jPanel.add((Component)labeledComponent3, new GridConstraints(0, 0, 1, 2, 0, 1, 7, 3, null, null, null));
        LabeledComponent<JBLabel> labeledComponent4 = this.mavenVersionLabelComponent;
        labeledComponent4.setLabelLocation("West");
        labeledComponent4.setText("");
        jPanel.add((Component)labeledComponent4, new GridConstraints(1, 0, 1, 1, 9, 0, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static class PathOverrider {
        private final TextFieldWithBrowseButton component;
        private final JCheckBox checkBox;
        private final PathProvider pathProvider;
        private Boolean isOverridden;
        @NlsSafe
        private String overrideText;

        PathOverrider(LabeledComponent<TextFieldWithBrowseButton> component, JCheckBox checkBox, DocumentListener docListener, PathProvider pathProvider) {
            this.component = (TextFieldWithBrowseButton)component.getComponent();
            this.component.getTextField().getDocument().addDocumentListener(docListener);
            this.checkBox = checkBox;
            this.pathProvider = pathProvider;
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    this.update();
                }
            });
        }

        private void update() {
            boolean override = this.checkBox.isSelected();
            if (Comparing.equal((Object)this.isOverridden, (Object)override)) {
                return;
            }
            this.isOverridden = override;
            this.component.setEditable(override);
            this.component.setEnabled(override && this.checkBox.isEnabled());
            if (override) {
                if (this.overrideText != null) {
                    this.component.setText(this.overrideText);
                }
            } else {
                if (!StringUtil.isEmptyOrSpaces((String)this.component.getText())) {
                    this.overrideText = this.component.getText();
                }
                this.component.setText(this.pathProvider.getPath());
            }
        }

        private void updateDefault() {
            if (!this.checkBox.isSelected()) {
                this.component.setText(this.pathProvider.getPath());
            }
        }

        public void reset(@NlsSafe String text) {
            this.isOverridden = null;
            this.checkBox.setSelected(!StringUtil.isEmptyOrSpaces((String)text));
            this.overrideText = StringUtil.isEmptyOrSpaces((String)text) ? null : text;
            this.update();
        }

        public String getResult() {
            return this.checkBox.isSelected() ? this.component.getText().trim() : "";
        }
    }

    private static abstract class PathProvider {
        private PathProvider() {
        }

        @NlsSafe
        public String getPath() {
            File file = this.getFile();
            return file == null ? "" : file.getPath();
        }

        @Nullable
        protected abstract File getFile();
    }
}

