/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.internal.statistic.IdeActivity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.statistics.ExternalSystemStatUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.concurrency.Semaphore;
import java.util.LinkedList;
import java.util.Queue;
import org.jetbrains.idea.maven.execution.SoutMavenConsole;
import org.jetbrains.idea.maven.project.MavenConsole;
import org.jetbrains.idea.maven.project.MavenEmbeddersManager;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;
import org.jetbrains.idea.maven.utils.MavenTask;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenProjectsProcessor {
    private final Project myProject;
    private final @NlsContexts.Command String myTitle;
    private final boolean myCancellable;
    private final MavenEmbeddersManager myEmbeddersManager;
    private final Queue<MavenProjectsProcessorTask> myQueue = new LinkedList<MavenProjectsProcessorTask>();
    private boolean isProcessing;
    private volatile boolean isStopped;

    public MavenProjectsProcessor(Project project, @NlsContexts.Command String title, boolean cancellable, MavenEmbeddersManager embeddersManager) {
        this.myProject = project;
        this.myTitle = title;
        this.myCancellable = cancellable;
        this.myEmbeddersManager = embeddersManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleTask(MavenProjectsProcessorTask task) {
        Queue<MavenProjectsProcessorTask> queue = this.myQueue;
        synchronized (queue) {
            if (!this.isProcessing && !ApplicationManager.getApplication().isUnitTestMode()) {
                this.isProcessing = true;
                this.startProcessing(task);
                return;
            }
            if (this.myQueue.contains(task)) {
                return;
            }
            this.myQueue.add(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(MavenProjectsProcessorTask task) {
        Queue<MavenProjectsProcessorTask> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCompletion() {
        if (this.isStopped) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            while (true) {
                MavenProjectsProcessorTask task;
                Queue<MavenProjectsProcessorTask> queue = this.myQueue;
                synchronized (queue) {
                    task = this.myQueue.poll();
                    if (task == null) {
                        return;
                    }
                }
                this.startProcessing(task);
            }
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.scheduleTask(new MavenProjectsProcessorWaitForCompletionTask(semaphore));
        while (!this.isStopped && !semaphore.waitFor(1000L)) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.isStopped = true;
        Queue<MavenProjectsProcessorTask> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.clear();
        }
    }

    private void startProcessing(final MavenProjectsProcessorTask task) {
        MavenUtil.runInBackground(this.myProject, this.myTitle, this.myCancellable, new MavenTask(){

            @Override
            public void run(MavenProgressIndicator indicator) throws MavenProcessCanceledException {
                Condition condition = mavenProgressIndicator -> MavenProjectsProcessor.this.isStopped;
                indicator.addCancelCondition((Condition<MavenProgressIndicator>)condition);
                try {
                    MavenProjectsProcessor.this.doProcessPendingTasks(indicator, task);
                }
                finally {
                    indicator.removeCancelCondition((Condition<MavenProgressIndicator>)condition);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doProcessPendingTasks(MavenProgressIndicator indicator, MavenProjectsProcessorTask task) throws MavenProcessCanceledException {
        int counter = 0;
        try {
            while (true) {
                int remained;
                indicator.checkCanceled();
                Queue<MavenProjectsProcessorTask> queue = this.myQueue;
                synchronized (queue) {
                    remained = this.myQueue.size();
                }
                indicator.setFraction((double)(++counter) / (double)(counter + remained));
                MavenProjectsProcessorTask finalTask = task;
                IdeActivity activity = ExternalSystemStatUtilKt.importActivityStarted((Project)this.myProject, (ProjectSystemId)MavenUtil.SYSTEM_ID, data -> data.addData("task_class", finalTask.getClass().getName()));
                try {
                    MavenGeneralSettings mavenGeneralSettings = MavenProjectsManager.getInstance(this.myProject).getGeneralSettings();
                    task.perform(this.myProject, this.myEmbeddersManager, new SoutMavenConsole(mavenGeneralSettings.getOutputLevel(), mavenGeneralSettings.isPrintErrorStackTraces()), indicator);
                }
                catch (MavenProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    this.logImportErrorIfNotControlFlow(e);
                }
                finally {
                    activity.finished();
                }
                Queue<MavenProjectsProcessorTask> queue2 = this.myQueue;
                synchronized (queue2) {
                    task = this.myQueue.poll();
                    if (task == null) {
                        this.isProcessing = false;
                        return;
                    }
                }
            }
        }
        catch (MavenProcessCanceledException e) {
            Queue<MavenProjectsProcessorTask> queue = this.myQueue;
            synchronized (queue) {
                while (true) {
                    if (this.myQueue.isEmpty()) {
                        this.isProcessing = false;
                        throw e;
                    }
                    MavenProjectsProcessorTask removedTask = this.myQueue.remove();
                    if (!(removedTask instanceof MavenProjectsProcessorWaitForCompletionTask)) continue;
                    ((MavenProjectsProcessorWaitForCompletionTask)removedTask).mySemaphore.up();
                }
            }
        }
    }

    private void logImportErrorIfNotControlFlow(Throwable e) {
        if (e instanceof ControlFlowException) {
            ExceptionUtil.rethrowAllAsUnchecked((Throwable)e);
        }
        ReadAction.run(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            MavenProjectsManager.getInstance(this.myProject).showServerException(e);
        });
    }

    private static class MavenProjectsProcessorWaitForCompletionTask
    implements MavenProjectsProcessorTask {
        private final Semaphore mySemaphore;

        MavenProjectsProcessorWaitForCompletionTask(Semaphore semaphore) {
            this.mySemaphore = semaphore;
        }

        @Override
        public void perform(Project project, MavenEmbeddersManager embeddersManager, MavenConsole console, MavenProgressIndicator indicator) throws MavenProcessCanceledException {
            this.mySemaphore.up();
        }
    }
}

