/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.NlsContexts;
import java.io.IOException;
import java.rmi.Remote;
import java.rmi.server.UnicastRemoteObject;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenRemoteObject;
import org.jetbrains.idea.maven.server.MavenServerProgressIndicator;
import org.jetbrains.idea.maven.server.RemoteObjectWrapper;
import org.jetbrains.idea.maven.server.security.MavenToken;
import org.jetbrains.idea.maven.utils.MavenProgressIndicator;

public abstract class MavenRemoteObjectWrapper<T>
extends RemoteObjectWrapper<T> {
    public static final MavenToken ourToken = new MavenToken(UUID.randomUUID().toString());

    protected MavenRemoteObjectWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        super(parent);
    }

    static <Some extends MavenRemoteObject> Some doWrapAndExport(Some object) {
        try {
            Remote remote = UnicastRemoteObject.exportObject(object, 0);
            if (remote == null) {
                return null;
            }
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static MavenServerProgressIndicator wrapAndExport(MavenProgressIndicator indicator) {
        return MavenRemoteObjectWrapper.doWrapAndExport(new RemoteMavenServerProgressIndicator(indicator));
    }

    private static class RemoteMavenServerProgressIndicator
    extends MavenRemoteObject
    implements MavenServerProgressIndicator {
        private final MavenProgressIndicator myProcess;

        RemoteMavenServerProgressIndicator(MavenProgressIndicator process2) {
            this.myProcess = process2;
        }

        public void setText(@NlsContexts.ProgressText String text) {
            this.myProcess.setText(text);
        }

        public void setText2(@NlsContexts.ProgressDetails String text) {
            this.myProcess.setText2(text);
        }

        public void startedDownload(MavenServerProgressIndicator.ResolveType type, String dependencyId) {
            this.myProcess.startedDownload(type, dependencyId);
        }

        public void completedDownload(MavenServerProgressIndicator.ResolveType type, String dependencyId) {
            this.myProcess.completedDownload(type, dependencyId);
        }

        public void failedDownload(MavenServerProgressIndicator.ResolveType type, String dependencyId, String errorMessage, String stackTrace) {
            this.myProcess.failedDownload(type, dependencyId, errorMessage, stackTrace);
        }

        public boolean isCanceled() {
            return this.myProcess.isCanceled();
        }

        public void setIndeterminate(boolean value) {
            this.myProcess.getIndicator().setIndeterminate(value);
        }

        public void setFraction(double fraction) {
            this.myProcess.setFraction(fraction);
        }
    }
}

