/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.i18n.folding;

import com.intellij.codeInsight.navigation.actions.GotoDeclarationHandlerBase;
import com.intellij.codeInspection.i18n.folding.EditPropertyValueAction;
import com.intellij.codeInspection.i18n.folding.PropertyFoldingBuilder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.Nullable;

public class I18nMessageGotoDeclarationHandler
extends GotoDeclarationHandlerBase {
    public PsiElement getGotoDeclarationTarget(@Nullable PsiElement element, Editor editor) {
        if (!(element instanceof PsiJavaToken)) {
            return null;
        }
        FoldRegion region = editor.getFoldingModel().getCollapsedRegionAtOffset(element.getTextRange().getStartOffset());
        if (region == null) {
            return null;
        }
        PsiElement editableElement = EditPropertyValueAction.getEditableElement(region);
        if (editableElement instanceof PsiLiteralExpression) {
            return I18nMessageGotoDeclarationHandler.resolve(editableElement);
        }
        if (editableElement instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)editableElement;
            for (PsiExpression expression : methodCall.getArgumentList().getExpressions()) {
                if (!(expression instanceof PsiLiteralExpression) || !PropertyFoldingBuilder.isI18nProperty((PsiLiteralExpression)expression)) continue;
                return I18nMessageGotoDeclarationHandler.resolve((PsiElement)expression);
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement resolve(PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiReference[] references = element.getReferences();
        return references.length == 0 ? null : references[0].resolve();
    }
}

